/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.AppIdGenerator;
import org.tizen.common.util.CollectionUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.StringUtil;
import org.tizen.web.common.CommonMessages;
import org.tizen.web.common.WebCommonActivator;

public class ChromeLauncher {
    private static final Logger logger = LoggerFactory.getLogger(ChromeLauncher.class);
    public static final String CHROME_PARAM_APP = "--app=";
    public static final String CHROME_PARAM_USERDATADIR = "--user-data-dir=";
    public static List<Process> procList = new ArrayList<Process>();
    private List<String> options = new ArrayList<String>();

    protected String[] createCommandArgs(String url, TYPE type) throws FileNotFoundException {
        String chrome = WebCommonActivator.getChromeExceutePath();
        if (StringUtil.isEmpty((CharSequence)chrome)) {
            throw new FileNotFoundException(CommonMessages.CANNOT_FIND_CHROME);
        }
        ArrayList<String> commandArgs = new ArrayList<String>();
        commandArgs.add(chrome);
        commandArgs.addAll(Arrays.asList(this.getOptions()));
        if (TYPE.APP.equals((Object)type)) {
            commandArgs.add(CHROME_PARAM_APP + url);
        } else if (TYPE.URL.equals((Object)type)) {
            commandArgs.add(url);
        }
        if (OSChecker.isMAC()) {
            commandArgs.add(CHROME_PARAM_USERDATADIR + ProfileUtil.createProfile());
        }
        return commandArgs.toArray(new String[commandArgs.size()]);
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public Process launch(String url, TYPE type) throws IOException {
        String[] cmd = this.createCommandArgs(url, type);
        Process proc = Runtime.getRuntime().exec(cmd);
        ProfileUtil.createBackupLastProfile();
        procList.add(proc);
        return proc;
    }

    public void setOptions(String ... options) {
        this.options.clear();
        this.options.addAll(Arrays.asList(options));
    }

    public void addOption(String option) {
        if (!this.options.contains(option)) {
            this.options.add(option);
        }
    }

    public String[] getOptions() {
        return this.options.toArray(new String[this.options.size()]);
    }

    public static class ProfileUtil {
        public static ArrayList<String> profileList = new ArrayList();
        public static final String PROFILE_BASE_NAME = ".CustomProfile";
        public static final String PROFILE_BACKUP_NAME = "Default";

        public static boolean isEnableProfile(String profile) {
            if (!FilenameUtil.isVaildName((String)profile)) {
                return false;
            }
            return !FileUtil.isExist((String)profile);
        }

        public static boolean isFirstRun() {
            return profileList.size() < 1;
        }

        public static boolean removeProfile(String profile) {
            File file = new File(profile);
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    ProfileUtil.removeProfile(f.getAbsolutePath());
                    ++n2;
                }
            }
            return file.delete();
        }

        public static void removeProfileAll() {
            Iterator<String> iter = profileList.iterator();
            while (iter.hasNext()) {
                ProfileUtil.removeProfile(iter.next());
            }
        }

        public static void addProfileList(String profile) {
            if (profileList.contains(profile)) {
                return;
            }
            profileList.add(profile);
        }

        public static void removeProfileList(String profile) {
            if (!profileList.contains(profile)) {
                return;
            }
            ProfileUtil.removeProfile(profile);
            profileList.remove(profile);
        }

        public static void removeProfileListAll() {
            ProfileUtil.removeProfileAll();
            profileList.clear();
        }

        public static String getBaseProfileDirectory() {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            File workspaceDir = workspace.getRoot().getLocation().toFile();
            File profileDir = new File(workspaceDir, PROFILE_BASE_NAME);
            if (!FileUtil.isExist((String)profileDir.getAbsolutePath())) {
                FileUtil.createDirectory((File)profileDir);
            }
            return profileDir.getAbsolutePath();
        }

        public static void copyBackupProfile(String dest) {
            File destfile = new File(dest);
            if (!destfile.isDirectory()) {
                dest = destfile.getParent();
            }
            if (!PROFILE_BACKUP_NAME.equals(FilenameUtil.getFilename((String)dest))) {
                dest = FilenameUtil.addTailingPath((String)dest, (String)PROFILE_BACKUP_NAME);
            }
            String backupProfileDir = FilenameUtil.addTailingPath((String)ProfileUtil.getBaseProfileDirectory(), (String)PROFILE_BACKUP_NAME);
            try {
                FileUtil.copyRecursively((String)backupProfileDir, (String)dest, (boolean)true);
            }
            catch (IOException e) {
                logger.error("Failed to copy", (Throwable)e);
            }
        }

        public static void crearteBackupProfile(String ori) {
            File orifile = new File(ori);
            if (!orifile.isDirectory()) {
                ori = orifile.getParent();
            }
            if (!PROFILE_BACKUP_NAME.equals(FilenameUtil.getFilename((String)ori))) {
                ori = FilenameUtil.addTailingPath((String)ori, (String)PROFILE_BACKUP_NAME);
            }
            String backupProfileDir = FilenameUtil.addTailingPath((String)ProfileUtil.getBaseProfileDirectory(), (String)PROFILE_BACKUP_NAME);
            try {
                FileUtil.copyRecursively((String)ori, (String)backupProfileDir, (boolean)true);
            }
            catch (IOException e) {
                logger.error("Failed to copy", (Throwable)e);
            }
        }

        public static void createBackupLastProfile() {
            if (OSChecker.isMAC()) {
                String profile = (String)CollectionUtil.pickupLast(profileList);
                ProfileUtil.crearteBackupProfile(profile);
            }
        }

        public static String createProfile() {
            File profileDir = new File(ProfileUtil.getBaseProfileDirectory());
            if (ProfileUtil.isFirstRun()) {
                File[] fileArray = profileDir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!PROFILE_BACKUP_NAME.equals(file.getName())) {
                        ProfileUtil.removeProfile(file.getAbsolutePath());
                    }
                    ++n2;
                }
                PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                    public boolean preShutdown(IWorkbench workbench, boolean forced) {
                        ProfileUtil.createBackupLastProfile();
                        ProfileUtil.removeProfileListAll();
                        return true;
                    }

                    public void postShutdown(IWorkbench workbench) {
                    }
                });
            }
            String randomValue = AppIdGenerator.getInstance().create();
            String profile = FilenameUtil.addTailingPath((String)profileDir.getAbsolutePath(), (String)randomValue);
            FileUtil.createDirectory((String)profile);
            ProfileUtil.copyBackupProfile(profile);
            ProfileUtil.addProfileList(profile);
            return profile;
        }

        public static void backupLastProfile() {
        }
    }

    public static enum TYPE {
        APP,
        URL;

    }
}

