/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.common;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.css.ui.internal.CSSUIPlugin;
import org.eclipse.wst.html.ui.internal.HTMLUIPlugin;
import org.osgi.framework.BundleContext;
import org.tizen.common.util.StringUtil;

public class WebCommonActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.tizen.web.common";
    private static final String REGEX_SPACES = "[\\s,]+";
    private static WebCommonActivator plugin;
    public static final QualifiedName useMinUifwQName;
    public static final QualifiedName rootNativeAppQName;
    public static final QualifiedName usedTargetLibraryQName;
    public static final QualifiedName needFullInstallQName;
    public static final QualifiedName companionWearableWebAppQName;
    public static final QualifiedName alwayLaunchWithoutAskingQName;
    public static final QualifiedName optimizeResourcesQName;
    public static final QualifiedName excludingOptimizeResourcesQName;

    static {
        useMinUifwQName = new QualifiedName(PLUGIN_ID, "useMinUifw");
        rootNativeAppQName = new QualifiedName(PLUGIN_ID, "root.native.app.name");
        usedTargetLibraryQName = new QualifiedName(PLUGIN_ID, "usedLibraryType");
        needFullInstallQName = new QualifiedName(PLUGIN_ID, "need.to.full.install");
        companionWearableWebAppQName = new QualifiedName(PLUGIN_ID, "companion.wearble.web");
        alwayLaunchWithoutAskingQName = new QualifiedName(PLUGIN_ID, "zimlaunch.without.asking");
        optimizeResourcesQName = new QualifiedName(PLUGIN_ID, "optimize.resources");
        excludingOptimizeResourcesQName = new QualifiedName(PLUGIN_ID, "excluding.optimize.resources");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.setCodeAssistPreference();
    }

    private void setCodeAssistPreference() {
        HTMLUIPlugin.getDefault().getPreferenceStore().setDefault("html_content_assist_display_on_own_page", "org.eclipse.wst.html.ui.proposalCategory.htmlTags\u0000org.eclipse.wst.css.ui.proposalCategory.css");
        HTMLUIPlugin.getDefault().getPreferenceStore().setDefault("html_content_assist_display_on_default_page", "org.eclipse.wst.html.ui.proposalCategory.htmlTags\u0000org.eclipse.wst.css.ui.proposalCategory.css");
        CSSUIPlugin.getDefault().getPreferenceStore().setDefault("css_content_assist_display_on_own_page", "org.eclipse.wst.css.ui.proposalCategory.css");
        CSSUIPlugin.getDefault().getPreferenceStore().setDefault("css_content_assist_display_on_default_page", "org.eclipse.wst.css.ui.proposalCategory.css");
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static WebCommonActivator getDefault() {
        return plugin;
    }

    public static String getChromeExceutePath() {
        IPreferenceStore store = WebCommonActivator.getDefault().getPreferenceStore();
        String chrome = store.getString("CHROME_EXECUTABLE");
        return chrome;
    }

    public static String[] getChromeOptions() {
        IPreferenceStore store = WebCommonActivator.getDefault().getPreferenceStore();
        String[] extraParams = store.getString("EXTRA_PARAM").split(REGEX_SPACES);
        String profilePath = store.getString("PROFILE_PATH");
        if (!StringUtil.isEmpty((CharSequence)profilePath)) {
            profilePath = "--user-data-dir=" + profilePath;
        }
        ArrayList<String> options = new ArrayList<String>();
        options.addAll(Arrays.asList(extraParams));
        options.add(profilePath);
        return options.toArray(new String[options.size()]);
    }

    public static boolean enableAutoBuild(boolean enable) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        boolean isAutoBuilding = desc.isAutoBuilding();
        if (isAutoBuilding != enable) {
            desc.setAutoBuilding(enable);
            workspace.setDescription(desc);
        }
        return isAutoBuilding;
    }
}

