/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.compressor.minifier.core;

import com.googlecode.htmlcompressor.compressor.HtmlCompressor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTMLCompressor
extends HtmlCompressor {
    protected String preserveBlocks(String html, List<String> preBlocks, List<String> taBlocks, List<String> scriptBlocks, List<String> styleBlocks, List<String> eventBlocks, List<String> condCommentBlocks, List<String> skipBlocks, List<String> lineBreakBlocks, List<List<String>> userBlocks) {
        List preservePatterns = this.getPreservePatterns();
        if (preservePatterns != null) {
            int p = 0;
            while (p < preservePatterns.size()) {
                ArrayList<String> userBlock = new ArrayList<String>();
                Matcher matcher = ((Pattern)preservePatterns.get(p)).matcher(html);
                int index = 0;
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    if (matcher.group(0).trim().length() > 0) {
                        // empty if block
                    }
                    userBlock.add(matcher.group(0));
                    matcher.appendReplacement(sb, MessageFormat.format("%%%~COMPRESS~USER{0,number,#}~{1,number,#}~%%%", p, index++));
                }
                matcher.appendTail(sb);
                html = sb.toString();
                userBlocks.add(userBlock);
                ++p;
            }
        }
        Matcher matcher = skipPattern.matcher(html);
        int skipBlockIndex = 0;
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(1).trim().length() > 0) {
                // empty if block
            }
            skipBlocks.add(matcher.group(1));
            matcher.appendReplacement(sb, MessageFormat.format("%%%~COMPRESS~SKIP~{0,number,#}~%%%", skipBlockIndex++));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        HtmlCompressor condCommentCompressor = this.createCompressorClone();
        matcher = condCommentPattern.matcher(html);
        int index = 0;
        sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).trim().length() > 0) {
                // empty if block
            }
            condCommentBlocks.add(String.valueOf(matcher.group(1)) + condCommentCompressor.compress(matcher.group(2)) + matcher.group(3));
            matcher.appendReplacement(sb, MessageFormat.format("%%%~COMPRESS~COND~{0,number,#}~%%%", index++));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = eventPattern1.matcher(html);
        index = 0;
        sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).trim().length() > 0) {
                // empty if block
            }
            eventBlocks.add(matcher.group(2));
            matcher.appendReplacement(sb, "$1" + MessageFormat.format("%%%~COMPRESS~EVENT~{0,number,#}~%%%", index++) + "$3");
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = eventPattern2.matcher(html);
        sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).trim().length() > 0) {
                // empty if block
            }
            eventBlocks.add(matcher.group(2));
            matcher.appendReplacement(sb, "$1" + MessageFormat.format("%%%~COMPRESS~EVENT~{0,number,#}~%%%", index++) + "$3");
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = prePattern.matcher(html);
        index = 0;
        sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).trim().length() > 0) {
                // empty if block
            }
            preBlocks.add(matcher.group(2));
            matcher.appendReplacement(sb, "$1" + MessageFormat.format("%%%~COMPRESS~PRE~{0,number,#}~%%%", index++) + "$3");
        }
        matcher.appendTail(sb);
        html = sb.toString();
        Pattern scriptPattern = Pattern.compile("(<script.*?)((/>|</script>))", 34);
        matcher = scriptPattern.matcher(html);
        index = 0;
        sb = new StringBuffer();
        while (matcher.find()) {
            String group = matcher.group().trim();
            if (group.indexOf("/>") > 0) continue;
            Matcher subMatcher = HtmlCompressor.scriptPattern.matcher(group);
            while (subMatcher.find()) {
                if (subMatcher.group(2).trim().length() <= 0) continue;
                String type = "";
                Matcher typeMatcher = typeAttrPattern.matcher(subMatcher.group(1));
                if (typeMatcher.find()) {
                    type = typeMatcher.group(2).toLowerCase();
                }
                if (type.length() == 0 || type.equals("text/javascript") || type.equals("application/javascript")) {
                    scriptBlocks.add(subMatcher.group(2));
                    matcher.appendReplacement(sb, "$1" + MessageFormat.format("%%%~COMPRESS~SCRIPT~{0,number,#}~%%%", index++) + "$3");
                    continue;
                }
                if (type.equals("text/x-jquery-tmpl")) continue;
                skipBlocks.add(subMatcher.group(2));
                matcher.appendReplacement(sb, "$1" + MessageFormat.format("%%%~COMPRESS~SKIP~{0,number,#}~%%%", skipBlockIndex++) + "$3");
            }
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = stylePattern.matcher(html);
        index = 0;
        sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).trim().length() > 0) {
                // empty if block
            }
            styleBlocks.add(matcher.group(2));
            matcher.appendReplacement(sb, "$1" + MessageFormat.format("%%%~COMPRESS~STYLE~{0,number,#}~%%%", index++) + "$3");
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = taPattern.matcher(html);
        index = 0;
        sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).trim().length() > 0) {
                // empty if block
            }
            taBlocks.add(matcher.group(2));
            matcher.appendReplacement(sb, "$1" + MessageFormat.format("%%%~COMPRESS~TEXTAREA~{0,number,#}~%%%", index++) + "$3");
        }
        matcher.appendTail(sb);
        html = sb.toString();
        if (this.isPreserveLineBreaks()) {
            matcher = lineBreakPattern.matcher(html);
            index = 0;
            sb = new StringBuffer();
            while (matcher.find()) {
                lineBreakBlocks.add(matcher.group(1));
                matcher.appendReplacement(sb, MessageFormat.format("%%%~COMPRESS~LT~{0,number,#}~%%%", index++));
            }
            matcher.appendTail(sb);
            html = sb.toString();
        }
        return html;
    }
}

