/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.util;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.tizen.common.Surrogate;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.util.StringUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.web.zimlaunch.Activator;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.TizenDeviceInfo;
import org.tizen.web.zimlaunch.resource.TizenWebAppInfo;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.util.Messages;

public class WRTCommandUtil {
    private Surrogate<Activator> su;

    public void setSurrogate(Surrogate<Activator> su) {
        this.su = su;
    }

    private WRTCommandUtil() {
    }

    public static WRTCommandUtil getInstance() {
        return WRTCommandUtilHolder.instance;
    }

    public String getCommand(String key, ZimLaunchResource resource) throws Exception {
        File appFile;
        if (resource == null || StringUtil.isEmpty((CharSequence)key)) {
            WRTCommandUtil.defaultAbort();
        }
        String errMsg = "";
        int code = 0;
        IPreferenceStore store = this.getPreferenceStore();
        StringBuffer sbcmd = new StringBuffer(store.getString(key));
        String cmd = store.getString(key);
        TizenWebAppInfo appInfo = resource.getAppinfo();
        TizenDeviceInfo devInfo = resource.getDeviceinfo();
        if (appInfo == null || devInfo == null) {
            WRTCommandUtil.defaultAbort();
        }
        int timeout = devInfo.getTimeout();
        String appID = appInfo.getAppID();
        String appPkgName = appInfo.getAppPackageID();
        String appGUID = appInfo.getAppGUID();
        String appWidgetID = appInfo.getAppWidgetID();
        if (StringUtil.isEmpty((CharSequence)appID)) {
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONVERT_WRTCMD_HANDLE);
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONVERT_WRT_CMD_CAN_NOT_FIND_APPID.getCode();
            TizenWebIDEException.abort(Messages.STEP_CONVERT_WRTCMD_HANDLE_FAILED, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        if ((appFile = appInfo.getAppFile()) == null) {
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONVERT_WRTCMD_HANDLE);
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONVERT_WRT_CMD_CAN_NOT_FIND_FILE.getCode();
            TizenWebIDEException.abort(Messages.STEP_CONVERT_WRTCMD_HANDLE_FAILED, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        String regex = "%timeout";
        Pattern pattern = Pattern.compile(regex);
        Matcher match = pattern.matcher(sbcmd);
        while (match.find()) {
            cmd = cmd.replace(regex, "\"" + Integer.toString(timeout) + "\"");
        }
        regex = "%widgetGUID";
        pattern = Pattern.compile(regex);
        match = pattern.matcher(sbcmd);
        while (match.find()) {
            cmd = cmd.replace(regex, "\"" + appGUID + "\"");
        }
        regex = "%widgetID";
        pattern = Pattern.compile(regex);
        match = pattern.matcher(sbcmd);
        while (match.find()) {
            cmd = cmd.replace(regex, "\"" + appID + "\"");
        }
        regex = "%packageID";
        pattern = Pattern.compile(regex);
        match = pattern.matcher(sbcmd);
        while (match.find()) {
            cmd = cmd.replace(regex, "\"" + appPkgName + "\"");
        }
        regex = "%appwidgetID";
        pattern = Pattern.compile(regex);
        match = pattern.matcher(sbcmd);
        while (match.find()) {
            cmd = cmd.replace(regex, "\"" + appWidgetID + "\"");
        }
        regex = "%widgetPackageName";
        pattern = Pattern.compile(regex);
        match = pattern.matcher(sbcmd);
        while (match.find()) {
            cmd = cmd.replace(regex, "\"" + appID + "\"");
        }
        regex = "%widgetPath";
        pattern = Pattern.compile(regex);
        match = pattern.matcher(sbcmd);
        while (match.find()) {
            cmd = cmd.replace(regex, "\"" + WRTCommandUtil.getPackageTransferAbsolutePath(devInfo.getDevice(), appFile) + "\"");
        }
        return cmd;
    }

    public static String getPackageTransferAbsolutePath(IDevice device, File appFile) {
        return String.valueOf(TizenPlatformConstants.getAppTmpDirectory((IDevice)device)) + "/" + appFile.getName();
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.getActivator().getPreferenceStore();
    }

    protected Activator getActivator() {
        Activator plugin = (Activator)((Object)this.su.getAdapter());
        return plugin;
    }

    protected static void defaultAbort() throws Exception {
        String errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONVERT_WRTCMD_HANDLE);
        int code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONVERT_WRT_CMD.getCode();
        TizenWebIDEException.abort(Messages.STEP_CONVERT_WRTCMD_HANDLE_FAILED, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
    }

    /* synthetic */ WRTCommandUtil(WRTCommandUtil wRTCommandUtil) {
        this();
    }

    private static class WRTCommandUtilHolder {
        private static final WRTCommandUtil instance = new WRTCommandUtil(null);

        private WRTCommandUtilHolder() {
        }
    }
}

