/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.page;

import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;
import org.tizen.common.ui.widget.ImageButton;
import org.tizen.web.config.schema.model.Feature;
import org.tizen.web.editor.configuration.ConfigurationEditor;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.feature.FeatureContentProvider;
import org.tizen.web.editor.configuration.feature.FeatureEditingSupport;
import org.tizen.web.editor.configuration.feature.FeatureLabelProvider;
import org.tizen.web.editor.configuration.feature.FeatureSorter;
import org.tizen.web.editor.configuration.feature.support.AddFeatureDialog;
import org.tizen.web.editor.configuration.page.AbstractFormPage;
import org.tizen.web.editor.configuration.support.AbstractChangeListener;

public class FeaturePage
extends AbstractFormPage {
    public static final String FeaturePage_ID = "Features";
    private ImageButton addButton;
    private ImageButton removeButton;
    private TableViewer viewer;
    private FeatureEditingSupport nameEditingSupport;
    private SelectionListener addBtnSelectionListener;
    private SelectionListener removeBtnSelectionListener;
    private ISelectionChangedListener viewerSelectionChangedListener;
    private AbstractChangeListener changeListener;

    public FeaturePage(ConfigurationEditor editor) {
        super(editor, FeaturePage_ID, Messages.FeaturePage_ID);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.createForm(Messages.FeaturePage_ID, "icons/ConfigurationEditor/40_title_features.png");
        Composite page = this.createPage(this.body);
        Composite section = this.editorToolkit.createSection(page, Messages.FeaturePage_SectionLabel, Messages.FeaturePage_SectionDescription);
        this.createFeaturesContent(section);
        ((Section)section.getParent()).setExpanded(true);
        this.addListener();
    }

    protected void createFeaturesContent(Composite parent) {
        Composite base = this.editorToolkit.createComposite(parent, 64);
        GridLayout grid = new GridLayout(1, false);
        grid.verticalSpacing = 0;
        base.setLayout((Layout)grid);
        base.setLayoutData((Object)new GridData(1808));
        Composite featureComposite = this.editorToolkit.createComposite(base, 0);
        grid = new GridLayout(1, false);
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 0;
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        featureComposite.setLayout((Layout)grid);
        featureComposite.setLayoutData((Object)new GridData(768));
        Composite tableBtns = this.editorToolkit.createComposite(featureComposite);
        grid = new GridLayout(3, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        tableBtns.setLayout((Layout)grid);
        tableBtns.setLayoutData((Object)new GridData(3, 2, true, false));
        this.addButton = this.editorToolkit.createAddButton(tableBtns);
        this.removeButton = this.editorToolkit.createRemoveButton(tableBtns);
        this.removeButton.setEnabled(false);
        this.viewer = new TableViewer(base, 68354);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = new GridData(768);
        data.heightHint = 248;
        table.setLayoutData((Object)data);
        TableViewerColumn nameColumn = new TableViewerColumn(this.viewer, 0);
        nameColumn.getColumn().setText(Messages.FeaturePage_TreeviewerFeatureNameColumn);
        nameColumn.getColumn().setToolTipText(Messages.FeaturePage_TreeviewerFeatureNameColumnTooltip);
        this.nameEditingSupport = new FeatureEditingSupport((ColumnViewer)this.viewer, 0);
        nameColumn.setEditingSupport((EditingSupport)this.nameEditingSupport);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        this.viewer.getTable().setLayout((Layout)tableLayout);
        FeatureContentProvider contentProvider = new FeatureContentProvider();
        FeatureLabelProvider tableLabelProvider = new FeatureLabelProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)tableLabelProvider);
    }

    @Override
    public void setFocus() {
        super.setFocus();
        this.viewer.getControl().setFocus();
    }

    @Override
    public void loadStatus(ITizenConfigurator config) {
        this.tizenConfig = config;
        this.removeListener();
        this.viewer.setInput((Object)this.tizenConfig);
        this.viewer.refresh();
        this.viewer.getTable().setEnabled(true);
        this.viewer.setSorter((ViewerSorter)new FeatureSorter());
        this.addListener();
    }

    @Override
    public void addListener() {
        this.createListener();
        if (this.viewerSelectionChangedListener != null) {
            this.viewer.addSelectionChangedListener(this.viewerSelectionChangedListener);
        }
    }

    @Override
    public void removeListener() {
        this.viewer.removeSelectionChangedListener(this.viewerSelectionChangedListener);
    }

    @Override
    public void createListener() {
        if (this.changeListener == null) {
            this.changeListener = new AbstractChangeListener(){

                @Override
                public void notifyChange() {
                    FeaturePage.this.viewer.refresh();
                    FeaturePage.this.markDirty();
                }
            };
        }
        if (this.viewerSelectionChangedListener == null) {
            this.viewerSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!selection.isEmpty()) {
                        FeaturePage.this.removeButton.setEnabled(true);
                    } else {
                        FeaturePage.this.removeButton.setEnabled(false);
                    }
                }
            };
        }
        if (this.addBtnSelectionListener == null) {
            this.addBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AddFeatureDialog dialog = new AddFeatureDialog(FeaturePage.this.body.getShell(), Messages.AddFeatureWizard_Title, FeaturePage.this.tizenConfig);
                    if (dialog.open() == 0 && FeaturePage.this.changeListener != null) {
                        FeaturePage.this.changeListener.notifyChange();
                    }
                }
            };
            this.addButton.addSelectionListener(this.addBtnSelectionListener);
        }
        if (this.removeBtnSelectionListener == null) {
            this.removeBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = FeaturePage.this.viewer.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        for (Object object : (IStructuredSelection)selection) {
                            if (!(object instanceof Feature)) continue;
                            FeaturePage.this.tizenConfig.removeFeature((Feature)object);
                            FeaturePage.this.viewer.remove(object);
                            FeaturePage.this.changeListener.notifyChange();
                        }
                    }
                }
            };
            this.removeButton.addSelectionListener(this.removeBtnSelectionListener);
        }
    }
}

