/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.builder.IBuildDependency;
import org.tizen.common.util.FileUtil;
import org.tizen.web.builder.ide.manager.BuildManager;
import org.tizen.web.project.initializer.WebLibraryLocation;

public class WebNavigatorContentProvider
implements ITreeContentProvider,
IResourceChangeListener {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public WebNavigatorContentProvider() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this, 4);
    }

    public Object[] getChildren(Object parentElement) {
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return EMPTY_ARRAY;
    }

    public void dispose() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IBuildDependency dependency;
        IResource resource = event.getResource();
        try {
            IProject project = resource.getProject();
            WebLibraryLocation libLocation = new WebLibraryLocation(project);
            IPath path = libLocation.getWorkingLibPath();
            FileUtil.recursiveDelete((File)path.toFile());
        }
        catch (IllegalStateException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (resource instanceof IProject && (dependency = BuildManager.getBuildDependency((String)resource.getName())) != null) {
            dependency.clear();
        }
    }
}

