/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.command;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.sdb.command.ApplicationCommand;
import org.tizen.common.sdb.command.InstallCommand;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.ApplicationCmdService;
import org.tizen.web.zimlaunch.notification.TizenWebConsole;

public class WebInstallCommand
extends InstallCommand {
    private String packageFile;
    private String args = "";
    private String localPkgFilePath;
    protected static final Logger logger = LoggerFactory.getLogger(WebInstallCommand.class);

    public WebInstallCommand(IDevice device, String packageFile, String localPkgFilePath, TizenWebConsole console) {
        super(device, (ITizenConsoleManager)console);
        this.pkgType = ApplicationCmdService.PackageType.WebPkg;
        this.packageFile = packageFile;
        this.device = device;
        this.localPkgFilePath = localPkgFilePath;
    }

    protected String getPath() {
        if (ApplicationCommand.isAppCmdSupported((IDevice)this.getDevice())) {
            return this.localPkgFilePath;
        }
        return String.valueOf(TizenPlatformConstants.getAppTmpDirectory((IDevice)this.device)) + "/" + this.packageFile;
    }

    protected String getArgs() {
        String pkgCmdDebugModeSupport = null;
        try {
            pkgCmdDebugModeSupport = this.device.getPlatformCapability().getPkgcmdDebugModeSupport();
        }
        catch (Exception e) {
            logger.debug("Failed to get platform capability", (Throwable)e);
        }
        if ("enabled".equals(pkgCmdDebugModeSupport)) {
            this.args = String.valueOf(this.args) + "-G";
        }
        return this.args;
    }
}

