/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.builder;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.tizen.common.Architecture;
import org.tizen.common.util.Assert;
import org.tizen.common.util.DialogUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.project.Messages;
import org.tizen.web.project.util.BuildErrorChecker;

public class HybridAppBuilder {
    protected static String getBuildArchitecture(IProject project) throws CoreException {
        String projectArch = BuildErrorChecker.getBuildArchitecture(project);
        if (projectArch == null) {
            throw HybridAppBuilder.newCoreException(Messages.bind((String)Messages.HybridAppBuilder_FailToGetArchitecture, (Object)project.getName()));
        }
        return projectArch;
    }

    public static void checkArchitecture(IProject project, IDevice device) throws CoreException {
        IProject[] referencedOSPProjects;
        Assert.notNull((Object)device);
        String deviceArch = device.getArch().name();
        IProject[] iProjectArray = referencedOSPProjects = ProjectUtil.getReferencedNativeProjects((IProject)project);
        int n = referencedOSPProjects.length;
        int n2 = 0;
        while (n2 < n) {
            int retValue;
            IProject ospProject = iProjectArray[n2];
            String projectName = ospProject.getName();
            String projectArch = HybridAppBuilder.getBuildArchitecture(ospProject);
            String archGroupName = Architecture.getGroup((String)projectArch).name();
            if (!archGroupName.equalsIgnoreCase(deviceArch) && (retValue = DialogUtil.openQuestionDialog((String)Messages.HybridAppBuilder_NotMatchedArchContinueQuestion)) != 32) {
                throw HybridAppBuilder.newCoreException(Messages.bind((String)Messages.HybridAppBuilder_GuideForNotMatchedArch, (Object)projectName, (Object)archGroupName));
            }
            ++n2;
        }
    }

    protected static CoreException newCoreException(String msg) {
        return new CoreException((IStatus)new Status(4, "org.tizen.web.project", msg));
    }

    protected static CoreException newCoreException(String msg, Throwable e) {
        return new CoreException((IStatus)new Status(4, "org.tizen.web.project", msg, e));
    }
}

