/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.cli.command;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.core.command.sdb.ForwardSdbCommand;
import org.tizen.common.util.Assert;
import org.tizen.common.util.LocalPortChecker;
import org.tizen.common.util.StringUtil;
import org.tizen.web.common.JSONArray;
import org.tizen.web.common.JSONException;
import org.tizen.web.common.JSONObject;
import org.tizen.web.common.JSONTokener;
import org.tizen.web.zimlaunch.cli.command.WRTCommand;
import org.tizen.web.zimlaunch.cli.command.WgtInfoCommand;
import org.tizen.web.zimlaunch.exception.HTTPResponseCode;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;

public class DebugCommand
extends WRTCommand {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final String WRT_LAUNCHER_RUN_COMMAND = "/usr/bin/wrt-launcher --start";
    protected static final String WRT_LAUNCHER_RUN_COMMNAD_TIME = "--timeout=";
    protected static final String WRT_LAUNCHER_DEBUG_OPTION = "--debug";
    protected String widgetID;
    protected String localPort;
    protected String remotePort;
    protected String inspectorURL;

    public String getInspectorURL() {
        return this.inspectorURL;
    }

    public void setInspectorURL(String inspectorURL) {
        this.inspectorURL = inspectorURL;
    }

    public String getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(String localPort) {
        this.localPort = localPort;
    }

    public String getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(String port) {
        this.remotePort = port;
    }

    public String getWidgetID() {
        return this.widgetID;
    }

    public DebugCommand(String wigetID) {
        this.widgetID = wigetID;
    }

    protected String getPackageName(Executor executor, ExecutionContext context) throws Exception {
        WgtInfoCommand getWgtInfoCommand = new WgtInfoCommand(this.getWidgetID());
        getWgtInfoCommand.setDevice(this.getDevice());
        getWgtInfoCommand.setPrintOption(this.isPrintOption());
        getWgtInfoCommand.run(executor, context);
        return getWgtInfoCommand.getPackageName();
    }

    protected void initRemotePort() {
        String[] line = StringUtil.split((String)this.getResult(), (String)"\r\n");
        String port = "9222";
        String[] stringArray = line;
        int n = line.length;
        int n2 = 0;
        while (n2 < n) {
            String tmp = stringArray[n2];
            String[] contents = StringUtil.split((String)tmp, (String)" ");
            boolean isThisLine = false;
            String[] stringArray2 = contents;
            int n3 = contents.length;
            int n4 = 0;
            while (n4 < n3) {
                String content = stringArray2[n4];
                if ("port:".equals(content)) {
                    isThisLine = true;
                    break;
                }
                ++n4;
            }
            if (isThisLine) {
                port = contents[contents.length - 1];
                break;
            }
            ++n2;
        }
        this.setRemotePort(port);
    }

    protected void initLocalPort() {
        String port = this.getRemotePort();
        int localPort = LocalPortChecker.getAvailableLocalPort((int)1, (int)Integer.parseInt(port));
        this.setLocalPort(Integer.toString(localPort));
    }

    protected void initPort() {
        this.initRemotePort();
        this.initLocalPort();
    }

    protected ForwardSdbCommand createForward(Executor executor, ExecutionContext context) {
        this.initPort();
        String remotePort = this.getRemotePort();
        String localPort = this.getLocalPort();
        ForwardSdbCommand forward = new ForwardSdbCommand(Integer.parseInt(localPort), Integer.parseInt(remotePort));
        return forward;
    }

    protected void setUrl(String port, String urlpart) {
        String urlString = "http://127.0.0.1:" + port + "/" + urlpart;
        this.setInspectorURL(urlString);
    }

    protected HttpClient createHttpClient() {
        return new DefaultHttpClient();
    }

    protected void initInspectorURL() throws ClientProtocolException, IOException, JSONException {
        String responseUrl = "";
        try {
            responseUrl = this.getResponseUrl("WidgetDebug");
        }
        catch (Exception exception) {
            responseUrl = this.getResponseUrl("pagelist.json");
        }
        this.setUrl(this.getLocalPort(), responseUrl);
    }

    private String getResponseUrl(String path) throws ClientProtocolException, IOException, JSONException {
        String responseURL;
        block14: {
            responseURL = "";
            HttpClient httpclient = this.createHttpClient();
            httpclient.getParams().setParameter("http.protocol.expect-continue", (Object)false);
            httpclient.getParams().setParameter("http.connection.timeout", (Object)90000);
            httpclient.getParams().setParameter("http.socket.timeout", (Object)90000);
            try {
                HttpEntity entity;
                HttpGet httpget = new HttpGet("http://127.0.0.1:" + this.getLocalPort() + "/" + path);
                HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
                int code = response.getStatusLine().getStatusCode();
                if (200 != code) {
                    String msg = HTTPResponseCode.getDescriptionforCode(code);
                    Assert.fail((Object)((Object)((Object)TizenWebIDEExceptionCode.WEB_IDE_FAIL_TO_WEBKIT_RESPONSE) + msg));
                }
                if ((entity = response.getEntity()) == null) break block14;
                InputStream instream = entity.getContent();
                int contentLength = (int)entity.getContentLength();
                try {
                    String content = StringUtil.asString((InputStream)instream);
                    if (content.length() != contentLength) {
                        Assert.fail((Object)((Object)TizenWebIDEExceptionCode.WEB_IDE_FAIL_TO_READ_CONTENT));
                    }
                    if (path.equals("WidgetDebug")) {
                        JSONObject obj = new JSONObject(new JSONTokener(content));
                        responseURL = obj.getString("inspector_url");
                    } else {
                        JSONArray jsonArray = new JSONArray(new JSONTokener(content));
                        JSONObject jsonObj = jsonArray.getJSONObject(0);
                        responseURL = jsonObj.getString("inspectorUrl");
                    }
                }
                finally {
                    try {
                        instream.close();
                    }
                    catch (IOException e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            finally {
                httpclient.getConnectionManager().shutdown();
            }
        }
        return responseURL;
    }

    protected void initInspectorEnvironment(Executor executor, ExecutionContext context) throws Exception {
        ForwardSdbCommand forward = this.createForward(executor, context);
        forward.setDevice(this.getDevice());
        forward.run(executor, context);
        try {
            this.initInspectorURL();
        }
        catch (Exception exception) {
            forward.undo(executor, context);
        }
    }

    @Override
    protected boolean checkCommandReturnCode() {
        if (!this.getResult().contains("result: launched")) {
            return false;
        }
        return super.checkCommandReturnCode();
    }

    @Override
    public void run(Executor executor, ExecutionContext context) throws Exception {
        String msg;
        String name = this.getWidgetID();
        Assert.notNull((Object)name);
        this.setCommand("/usr/bin/wrt-launcher --start " + name + " " + WRT_LAUNCHER_DEBUG_OPTION + " " + WRT_LAUNCHER_RUN_COMMNAD_TIME + this.getTime());
        super.run(executor, context);
        if (this.checkCommandReturnCode()) {
            msg = MessageFormat.format("''{0}'' debug launch successful.", this.getWidgetID());
            try {
                this.initInspectorEnvironment(executor, context);
            }
            catch (Exception e) {
                context.getPrompter().notify("Remote inspector initialization failed.");
                throw e;
            }
            msg = String.valueOf(msg) + System.getProperty("line.separator") + "DEBUG URL: " + this.getInspectorURL();
        } else {
            msg = MessageFormat.format("''{0}'' debug launch failed.", this.getWidgetID());
        }
        if (this.isPrintOption()) {
            context.getPrompter().notify(msg);
        }
        this.clearResult();
        this.setResult(msg);
    }

    @Override
    public void undo(Executor executor, ExecutionContext context) throws Exception {
        super.undo(executor, context);
    }
}

