/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.validation;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.Version;
import org.tizen.common.util.CollectionUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.ValidationUtil;
import org.tizen.web.config.schema.model.ActivationType;
import org.tizen.web.config.schema.model.AppControl;
import org.tizen.web.config.schema.model.BackgroundCategory;
import org.tizen.web.config.schema.model.Mime;
import org.tizen.web.config.schema.model.Operation;
import org.tizen.web.config.schema.model.Uri;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;
import org.tizen.web.editor.configuration.IMobileConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.validation.W3CNonSchemaBasedValidatorHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MobileNonSchemaBasedValidatorHandler
extends W3CNonSchemaBasedValidatorHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String tempElement = "";
    protected String tizenContentElement = "";
    protected String tizenIconElement = "";
    protected List<AppControl> appControls = null;
    protected boolean isContainedScreenSizeFeature = false;
    private String requiredVersion;
    private List<BackgroundCategory> backgroundCategories;

    @Override
    public void init(IFile file) throws ConfigurationException {
        super.init(file);
        try {
            IMobileConfigurator config = (IMobileConfigurator)ConfiguratorFactory.unmarshalWidgetConfiguration(file.getProject());
            this.appControls = config.getAppControls();
            this.requiredVersion = config.getApplicationRequiredVersion();
            this.backgroundCategories = config.getBackgroundCategories();
        }
        catch (ClassCastException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if ("tizen:src".equalsIgnoreCase(qName)) {
            this.checkForNameAttribute(attributes, qName);
        } else if ("tizen:operation".equalsIgnoreCase(qName)) {
            this.checkForNameAttribute(attributes, qName);
        } else if ("tizen:application".equalsIgnoreCase(qName)) {
            this.checkForPkgIdInAppId(attributes);
            this.checkForRequiredVersionAttribute(attributes);
        } else if ("tizen:box-icon".equalsIgnoreCase(qName)) {
            this.checkForSrcAttributeInProject(attributes);
        } else if ("tizen:box-content".equalsIgnoreCase(qName)) {
            this.checkForSrcAttributeInProjectAndURL(attributes);
        } else if ("tizen:pd".equalsIgnoreCase(qName)) {
            this.checkForSrcAttributeInProjectAndURL(attributes);
        } else if ("tizen:box-size".equalsIgnoreCase(qName)) {
            this.checkForTizenAttributeInProject(attributes);
        } else if ("tizen:content".equalsIgnoreCase(qName)) {
            this.checkForTizenContentSrcAttribute(attributes);
        } else if ("feature".equalsIgnoreCase(qName)) {
            if (!this.isContainedScreenSizeFeature) {
                this.checkForFeatureNameAttribute(attributes);
            }
        } else if ("tizen:setting".equalsIgnoreCase(qName)) {
            this.checkForTizenSettingAttribute(attributes);
        }
        this.tempElement = qName;
    }

    private boolean shouldSetBGCategory(String requiredVersion) {
        Version compare = new Version("2.4");
        Version required = new Version(requiredVersion);
        return compare.compareTo(required) != 1;
    }

    private void checkForTizenSettingAttribute(Attributes attributes) {
        if (this.shouldSetBGCategory(this.requiredVersion) && ActivationType.ENABLE.value().equalsIgnoreCase(attributes.getValue("background-support")) && CollectionUtil.isEmpty(this.backgroundCategories)) {
            this.createMarker(Messages.Validator_ShouldSetBackgroundCategory, 1);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.tempElement.equals("tizen:icon")) {
            this.tizenIconElement = new String(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if ("tizen:icon".equalsIgnoreCase(qName)) {
            this.checkForTizenIconElement();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (StringUtil.isEmpty((CharSequence)this.contentElement) && !this.isProjectMember("index.html") && StringUtil.isEmpty((CharSequence)this.tizenContentElement)) {
            this.createMarker(Messages.Validator_InvalidContentElement, 2);
        }
        if (!this.isContainedScreenSizeFeature) {
            this.createMarker(Messages.Validator_ContainedScreenSizeFeature, 1);
        }
        if (this.appControls != null && this.appControls.size() >= 2) {
            this.checkForDuplicateAppControl(this.appControls);
        }
        super.endDocument();
    }

    protected void checkForTizenIconElement() {
        if (!StringUtil.isEmpty((CharSequence)this.tizenIconElement)) {
            this.tizenIconElement = StringUtil.trimTrailing((String)this.tizenIconElement);
            if (this.configFile.getProject().findMember(this.tizenIconElement) == null) {
                this.createMarker(Messages.Validator_InvalidTizenIconElement, 2);
            }
        }
    }

    protected void checkForNameAttribute(Attributes attributes, String qName) {
        String attributeValue;
        int index = attributes.getIndex("name");
        if (index != -1 && ((attributeValue = attributes.getValue(index)) == null || attributeValue.trim().length() == 0)) {
            this.createMarker(MessageFormat.format(Messages.Validator_BlankAttribute, attributes.getLocalName(index), qName), 2);
        }
    }

    protected void checkForPkgIdInAppId(Attributes attributes) {
        String pkgId;
        String appId;
        int appIdIndex = attributes.getIndex("id");
        int pkgIdIndex = attributes.getIndex("package");
        if (appIdIndex != -1 && pkgIdIndex != -1 && !(appId = attributes.getValue(appIdIndex)).startsWith(pkgId = attributes.getValue(pkgIdIndex))) {
            this.createMarker(Messages.NonSchemaBasedValidator_NotEqualPkgId, 2);
        }
    }

    protected void checkForRequiredVersionAttribute(Attributes attributes) {
        int index = attributes.getIndex("required_version");
        if (index != -1) {
            String attributeValue = attributes.getValue(index);
            if (this.config == null) {
                try {
                    this.config = ConfiguratorFactory.unmarshalWidgetConfiguration(this.configFile.getProject());
                }
                catch (ConfigurationException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (this.config != null && !ValidationUtil.checkForRequiredVersion((String)attributeValue)) {
                this.createMarker(Messages.NonSchemaBasedValidator_InvalidRequiredVersion, 2);
            }
        }
    }

    protected void checkForSrcAttributeInProject(Attributes attributes) {
        String attributeValue;
        int index = attributes.getIndex("src");
        if (index != -1 && !this.isProjectMember(attributeValue = attributes.getValue(index))) {
            this.createMarker(MessageFormat.format(Messages.Validator_InvalidSRCAttribute, attributeValue), 2);
        }
    }

    protected void checkForSrcAttributeInProjectAndURL(Attributes attributes) {
        String attributeValue;
        int index = attributes.getIndex("src");
        if (index != -1 && !this.isProjectMember(attributeValue = attributes.getValue(index)) && !ValidationUtil.checkForURL((String)attributeValue)) {
            this.createMarker(MessageFormat.format(Messages.Validator_InvalidSRCAttribute, attributeValue), 2);
        }
    }

    protected void checkForTizenAttributeInProject(Attributes attributes) {
        String attributeValue;
        int index = attributes.getIndex("preview");
        if (index != -1 && !this.isProjectMember(attributeValue = attributes.getValue(index))) {
            this.createMarker(MessageFormat.format(Messages.Validator_InvalidPreviewAttribute, attributeValue), 2);
        }
    }

    protected void checkForTizenContentSrcAttribute(Attributes attributes) {
        int index = attributes.getIndex("src");
        if (index != -1) {
            this.tizenContentElement = attributes.getValue(index);
            if (!ValidationUtil.checkForURL((String)this.tizenContentElement)) {
                if (!ValidationUtil.checkForServiceContentFileExtension((String)this.tizenContentElement)) {
                    this.createMarker(MessageFormat.format(Messages.Validator_InvalidFileName, this.tizenContentElement), 2);
                } else if (!this.isProjectMember(this.tizenContentElement)) {
                    this.createMarker(MessageFormat.format(Messages.Validator_ResourceNotFound, this.tizenContentElement), 2);
                }
            }
        }
    }

    protected void checkForFeatureNameAttribute(Attributes attributes) {
        String name;
        int index = attributes.getIndex("name");
        if (index != -1 && (name = attributes.getValue(index)).contains("screen.size")) {
            this.isContainedScreenSizeFeature = true;
        }
    }

    protected void checkForDuplicateAppControl(List<AppControl> lists) {
        if (lists == null || lists.size() < 2) {
            return;
        }
        int baseIndex = 0;
        while (baseIndex < lists.size()) {
            AppControl baseAppControl = lists.get(baseIndex);
            String baseOperation = "";
            String baseUri = "";
            String baseMime = "";
            for (Object baseControl : baseAppControl.getSrcOrOperationOrUri()) {
                if (baseControl instanceof Operation) {
                    baseOperation = ((Operation)baseControl).getName().trim();
                    continue;
                }
                if (baseControl instanceof Uri) {
                    baseUri = ((Uri)baseControl).getName();
                    continue;
                }
                if (!(baseControl instanceof Mime)) continue;
                baseMime = ((Mime)baseControl).getName();
            }
            int currentIndex = baseIndex + 1;
            while (currentIndex < lists.size()) {
                AppControl currentAppControl = lists.get(currentIndex);
                String currentOperation = "";
                String currentUri = "";
                String currentMime = "";
                for (Object currentControl : currentAppControl.getSrcOrOperationOrUri()) {
                    if (currentControl instanceof Operation) {
                        currentOperation = ((Operation)currentControl).getName().trim();
                        continue;
                    }
                    if (currentControl instanceof Uri) {
                        currentUri = ((Uri)currentControl).getName();
                        continue;
                    }
                    if (!(currentControl instanceof Mime)) continue;
                    currentMime = ((Mime)currentControl).getName();
                }
                if (baseOperation.equals(currentOperation) && baseUri.equals(currentUri) && baseMime.equals(currentMime)) {
                    this.createMarker(Messages.Validator_DuplicateAppControl, 2);
                    break;
                }
                ++currentIndex;
            }
            ++baseIndex;
        }
    }
}

