/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.dialogs.WorkingSetGroup;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileManipulations;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.util.SignatureUtility;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.WorkspaceUtil;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.project.wizard.extension.WebProjectCreator;
import org.tizen.web.project.wizard.operation.AbstractProjectTemplateOperation;
import org.tizen.web.project.wizard.operation.ContentAssistOperation;
import org.tizen.web.project.wizard.operation.DefaultNatureOperation;
import org.tizen.web.project.wizard.operation.IProjectTemplateOperation;
import org.tizen.web.project.wizard.operation.TizenProjectDescriptOperation;
import org.tizen.web.project.wizard.ui.UIMessages;

public class WebProjectImportWizardPage
extends WizardPage
implements IOverwriteQuery {
    private final Logger logger = LoggerFactory.getLogger(WebProjectImportWizardPage.class);
    private static final String DEFAULT_PAGE_NAME = UIMessages.getString("org.tizen.web.import.wizard.title");
    public static final String SAMPLE_DIRECTORY_NAME = "sample";
    public static final String METADATA_FOLDER = ".metadata";
    private ILeveledImportStructureProvider structureProvider;
    private static final String THIS_CLASS_NAME = "WebProjectImportWizardPage";
    private static final String STORE_COPY_PROJECT_ID = "WebProjectImportWizardPage.STORE_COPY_PROJECT_ID";
    private static final String STORE_ARCHIVE_SELECTED = "WebProjectImportWizardPage.STORE_ARCHIVE_SELECTED";
    private CheckboxTreeViewer projectsList;
    private Button copyCheckbox;
    private boolean copyFiles = true;
    private ProjectRecord[] selectedProjects = new ProjectRecord[0];
    private IProject[] wsProjects;
    private static String previouslyBrowsedDirectory = "";
    private static String previouslyBrowsedArchive = "";
    private Button projectFromDirectoryRadio;
    private Button projectFromArchiveRadio;
    private Text directoryPathField;
    private Text archivePathField;
    private Button browseDirectoriesButton;
    private Button browseArchivesButton;
    private static final String[] FILE_IMPORT_MASK = new String[]{"*.wgt"};
    private String initialPath;
    private String lastPath;
    private long lastModified;
    private WorkingSetGroup workingSetGroup;
    private IStructuredSelection currentSelection;
    List<IProject> createdProjects;
    private String alwaysQueryState;

    public WebProjectImportWizardPage() {
        this(DEFAULT_PAGE_NAME, null, null);
    }

    public WebProjectImportWizardPage(String pageName) {
        this(pageName, null, null);
    }

    public WebProjectImportWizardPage(String pageName, String initialPath, IStructuredSelection currentSelection) {
        super(pageName);
        this.initialPath = initialPath;
        this.currentSelection = currentSelection;
        this.setPageComplete(false);
        this.setTitle(UIMessages.getString("org.tizen.web.import.wizard.title"));
        this.setDescription(UIMessages.getString("org.tizen.web.import.wizard.message"));
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
        this.createProjectsList(workArea);
        this.createOptionsArea(workArea);
        this.createWorkingSetGroup(workArea);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)workArea);
    }

    private void createWorkingSetGroup(Composite workArea) {
        this.workingSetGroup = new WorkingSetGroup(workArea, this.currentSelection, WorkspaceUtil.getIdsOfWorkingSetDescriptors());
    }

    private void createOptionsArea(Composite workArea) {
        Composite optionsGroup = new Composite(workArea, 0);
        optionsGroup.setLayout((Layout)new GridLayout());
        optionsGroup.setLayoutData((Object)new GridData(768));
        this.copyCheckbox = new Button(optionsGroup, 32);
        this.copyCheckbox.setText(DataTransferMessages.WizardProjectsImportPage_CopyProjectsIntoWorkspace);
        this.copyCheckbox.setLayoutData((Object)new GridData(768));
        this.copyCheckbox.setSelection(this.copyFiles);
        this.copyCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebProjectImportWizardPage.this.copyFiles = WebProjectImportWizardPage.this.copyCheckbox.getSelection();
            }
        });
    }

    private void createProjectsList(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText(DataTransferMessages.WizardProjectsImportPage_ProjectsListTitle);
        Composite listComposite = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        this.projectsList = new CheckboxTreeViewer(listComposite, 2048);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = new PixelConverter(this.projectsList.getControl()).convertWidthInCharsToPixels(25);
        gridData.heightHint = new PixelConverter(this.projectsList.getControl()).convertHeightInCharsToPixels(10);
        this.projectsList.getControl().setLayoutData((Object)gridData);
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return WebProjectImportWizardPage.this.getProjectRecords();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.projectsList.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.projectsList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectRecord element = (ProjectRecord)event.getElement();
                if (element.hasConflicts) {
                    WebProjectImportWizardPage.this.projectsList.setChecked((Object)element, false);
                }
                WebProjectImportWizardPage.this.setPageComplete(WebProjectImportWizardPage.this.projectsList.getCheckedElements().length > 0);
            }
        });
        this.projectsList.setInput((Object)this);
        this.projectsList.setComparator(new ViewerComparator());
        this.createSelectionButtons(listComposite);
    }

    private void createSelectionButtons(Composite listComposite) {
        Composite buttonsComposite = new Composite(listComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(DataTransferMessages.DataTransfer_selectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < WebProjectImportWizardPage.this.selectedProjects.length) {
                    if (((WebProjectImportWizardPage)WebProjectImportWizardPage.this).selectedProjects[i].hasConflicts) {
                        WebProjectImportWizardPage.this.projectsList.setChecked((Object)WebProjectImportWizardPage.this.selectedProjects[i], false);
                    } else {
                        WebProjectImportWizardPage.this.projectsList.setChecked((Object)WebProjectImportWizardPage.this.selectedProjects[i], true);
                    }
                    ++i;
                }
                WebProjectImportWizardPage.this.setPageComplete(WebProjectImportWizardPage.this.projectsList.getCheckedElements().length > 0);
            }
        });
        Dialog.applyDialogFont((Control)selectAll);
        this.setButtonLayoutData(selectAll);
        Button deselectAll = new Button(buttonsComposite, 8);
        deselectAll.setText(DataTransferMessages.DataTransfer_deselectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebProjectImportWizardPage.this.projectsList.setCheckedElements(new Object[0]);
                WebProjectImportWizardPage.this.setPageComplete(false);
            }
        });
        Dialog.applyDialogFont((Control)deselectAll);
        this.setButtonLayoutData(deselectAll);
        Button refresh = new Button(buttonsComposite, 8);
        refresh.setText(DataTransferMessages.DataTransfer_refresh);
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WebProjectImportWizardPage.this.projectFromDirectoryRadio.getSelection()) {
                    WebProjectImportWizardPage.this.updateProjectsList(WebProjectImportWizardPage.this.directoryPathField.getText().trim());
                } else {
                    WebProjectImportWizardPage.this.updateProjectsList(WebProjectImportWizardPage.this.archivePathField.getText().trim());
                }
            }
        });
        Dialog.applyDialogFont((Control)refresh);
        this.setButtonLayoutData(refresh);
    }

    private void createProjectsRoot(Composite workArea) {
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.projectFromDirectoryRadio = new Button(projectGroup, 16);
        this.projectFromDirectoryRadio.setText(DataTransferMessages.WizardProjectsImportPage_RootSelectTitle);
        this.directoryPathField = new Text(projectGroup, 2048);
        GridData directoryPathData = new GridData(4, 0, true, false);
        directoryPathData.widthHint = new PixelConverter((Control)this.directoryPathField).convertWidthInCharsToPixels(25);
        this.directoryPathField.setLayoutData((Object)directoryPathData);
        this.browseDirectoriesButton = new Button(projectGroup, 8);
        this.browseDirectoriesButton.setText(DataTransferMessages.DataTransfer_browse);
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.projectFromArchiveRadio = new Button(projectGroup, 16);
        this.projectFromArchiveRadio.setText(UIMessages.getString("org.tizen.web.import.wizardpage.archivedialog.message"));
        this.archivePathField = new Text(projectGroup, 2048);
        GridData archivePathData = new GridData(4, 0, true, false);
        archivePathData.widthHint = new PixelConverter((Control)this.archivePathField).convertWidthInCharsToPixels(25);
        this.archivePathField.setLayoutData((Object)archivePathData);
        this.browseArchivesButton = new Button(projectGroup, 8);
        this.browseArchivesButton.setText(DataTransferMessages.DataTransfer_browse);
        this.setButtonLayoutData(this.browseArchivesButton);
        this.projectFromDirectoryRadio.setSelection(true);
        this.archivePathField.setEnabled(false);
        this.browseArchivesButton.setEnabled(false);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebProjectImportWizardPage.this.handleLocationDirectoryButtonPressed();
            }
        });
        this.browseArchivesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebProjectImportWizardPage.this.handleLocationArchiveButtonPressed();
            }
        });
        this.directoryPathField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    WebProjectImportWizardPage.this.updateProjectsList(WebProjectImportWizardPage.this.directoryPathField.getText().trim());
                }
            }
        });
        this.directoryPathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                WebProjectImportWizardPage.this.updateProjectsList(WebProjectImportWizardPage.this.directoryPathField.getText().trim());
            }
        });
        this.archivePathField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    WebProjectImportWizardPage.this.updateProjectsList(WebProjectImportWizardPage.this.archivePathField.getText().trim());
                }
            }
        });
        this.archivePathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                WebProjectImportWizardPage.this.updateProjectsList(WebProjectImportWizardPage.this.archivePathField.getText().trim());
            }
        });
        this.projectFromDirectoryRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebProjectImportWizardPage.this.directoryRadioSelected();
            }
        });
        this.projectFromArchiveRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebProjectImportWizardPage.this.archiveRadioSelected();
            }
        });
    }

    private void archiveRadioSelected() {
        if (this.projectFromArchiveRadio.getSelection()) {
            this.directoryPathField.setEnabled(false);
            this.browseDirectoriesButton.setEnabled(false);
            this.archivePathField.setEnabled(true);
            this.browseArchivesButton.setEnabled(true);
            this.updateProjectsList(this.archivePathField.getText());
            this.archivePathField.setFocus();
            this.copyCheckbox.setSelection(true);
            this.copyCheckbox.setEnabled(false);
        }
    }

    private void directoryRadioSelected() {
        if (this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setEnabled(true);
            this.browseDirectoriesButton.setEnabled(true);
            this.archivePathField.setEnabled(false);
            this.browseArchivesButton.setEnabled(false);
            this.updateProjectsList(this.directoryPathField.getText());
            this.directoryPathField.setFocus();
            this.copyCheckbox.setEnabled(true);
            this.copyCheckbox.setSelection(this.copyFiles);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setFocus();
        }
        if (visible && this.projectFromArchiveRadio.getSelection()) {
            this.archivePathField.setFocus();
        }
    }

    public void updateProjectsList(final String path) {
        if (path == null || path.length() == 0) {
            this.setMessage(UIMessages.getString("org.tizen.web.import.wizard.message"));
            this.selectedProjects = new ProjectRecord[0];
            this.projectsList.refresh(true);
            this.projectsList.setCheckedElements((Object[])this.selectedProjects);
            this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
            this.lastPath = path;
            return;
        }
        final File directory = new File(path);
        long modified = directory.lastModified();
        if (path.equals(this.lastPath) && this.lastModified == modified) {
            return;
        }
        this.lastPath = path;
        this.lastModified = modified;
        final boolean dirSelected = this.projectFromDirectoryRadio.getSelection();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(DataTransferMessages.WizardProjectsImportPage_SearchingMessage, 100);
                    WebProjectImportWizardPage.this.selectedProjects = new ProjectRecord[0];
                    monitor.worked(10);
                    if (!dirSelected && ArchiveFileManipulations.isZipFile((String)path)) {
                        ArrayList files = new ArrayList();
                        ZipFile sourceFile = WebProjectImportWizardPage.this.getSpecifiedZipSourceFile(path);
                        if (sourceFile == null) {
                            return;
                        }
                        WebProjectImportWizardPage.this.structureProvider = (ILeveledImportStructureProvider)new ZipLeveledStructureProvider(sourceFile);
                        Object child = WebProjectImportWizardPage.this.structureProvider.getRoot();
                        if (!WebProjectImportWizardPage.this.collectProjectFilesFromProvider(files, child, 0, monitor, path)) {
                            return;
                        }
                        WebProjectImportWizardPage.this.selectedProjects = new ProjectRecord[files.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                        for (ProjectRecord pr : files) {
                            ((WebProjectImportWizardPage)WebProjectImportWizardPage.this).selectedProjects[index++] = pr;
                        }
                    } else if (dirSelected && directory.isDirectory()) {
                        ArrayList files = new ArrayList();
                        if (!WebProjectImportWizardPage.this.collectProjectFilesFromDirectory(files, directory, null, monitor)) {
                            return;
                        }
                        WebProjectImportWizardPage.this.selectedProjects = new ProjectRecord[files.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                        for (File file : files) {
                            ((WebProjectImportWizardPage)WebProjectImportWizardPage.this).selectedProjects[index++] = new ProjectRecord(file);
                        }
                    } else {
                        monitor.worked(60);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log((String)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
        this.projectsList.refresh(true);
        ProjectRecord[] projects = this.getProjectRecords();
        boolean displayWarning = false;
        int i = 0;
        while (i < projects.length) {
            if (projects[i].hasConflicts) {
                displayWarning = true;
                this.projectsList.setGrayed((Object)projects[i], true);
            } else {
                this.projectsList.setChecked((Object)projects[i], true);
            }
            ++i;
        }
        if (displayWarning) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_projectsInWorkspace, 2);
        } else {
            this.setMessage(UIMessages.getString("org.tizen.web.import.wizard.message"));
        }
        this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
        if (this.selectedProjects.length == 0) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_noProjectsToImport, 2);
        }
    }

    private ZipFile getSpecifiedZipSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException zipException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_couldNotRead);
        }
        this.archivePathField.setFocus();
        return null;
    }

    protected void displayErrorDialog(String message) {
        MessageDialog.open((int)1, (Shell)this.getContainer().getShell(), (String)this.getErrorDialogTitle(), (String)message, (int)0x10000000);
    }

    protected String getErrorDialogTitle() {
        return IDEWorkbenchMessages.WizardExportPage_internalErrorTitle;
    }

    private boolean collectProjectFilesFromDirectory(Collection<File> files, File directory, Set<String> directoriesVisited, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_CheckingMessage, (Object)directory.getPath()));
        File[] contents = directory.listFiles();
        if (contents == null) {
            return false;
        }
        if (directoriesVisited == null) {
            directoriesVisited = new HashSet<String>();
            try {
                directoriesVisited.add(directory.getCanonicalPath());
            }
            catch (IOException exception) {
                StatusManager.getManager().handle(StatusUtil.newStatus((int)4, (String)exception.getLocalizedMessage(), (Throwable)exception));
            }
        }
        int i = 0;
        while (i < contents.length) {
            File file = contents[i];
            if (file.isFile() && file.getName().equals(".project")) {
                try {
                    if (this.isWebProject(file)) {
                        files.add(file);
                        return true;
                    }
                }
                catch (FileNotFoundException e) {
                    this.logger.warn(e.getMessage());
                }
                catch (CoreException e) {
                    this.logger.warn(e.getMessage());
                }
            }
            ++i;
        }
        i = 0;
        while (i < contents.length) {
            block16: {
                if (contents[i].isDirectory() && !contents[i].getName().equals(METADATA_FOLDER)) {
                    block15: {
                        try {
                            String canonicalPath = contents[i].getCanonicalPath();
                            if (directoriesVisited.add(canonicalPath)) break block15;
                            break block16;
                        }
                        catch (IOException exception) {
                            StatusManager.getManager().handle(StatusUtil.newStatus((int)4, (String)exception.getLocalizedMessage(), (Throwable)exception));
                        }
                    }
                    this.collectProjectFilesFromDirectory(files, contents[i], directoriesVisited, monitor);
                }
            }
            ++i;
        }
        return true;
    }

    private boolean isWebProject(File dotProject) throws CoreException, FileNotFoundException {
        boolean bl;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(dotProject);
            IProjectDescription projectDesc = ResourcesPlugin.getWorkspace().loadProjectDescription((InputStream)inputStream);
            ICommand[] buildSpec = projectDesc.getBuildSpec();
            ICommand findedBuilder = ProjectUtil.findCommand((ICommand[])buildSpec, (String)"org.tizen.web.project.builder.WebBuilder");
            bl = findedBuilder != null;
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{inputStream});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{inputStream});
        return bl;
    }

    private boolean collectProjectFilesFromProvider(Collection<ProjectRecord> files, Object entry, int level, IProgressMonitor monitor, String path) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_CheckingMessage, (Object)this.structureProvider.getLabel(entry)));
        List children = this.structureProvider.getChildren(entry);
        if (children == null) {
            children = Collections.EMPTY_LIST;
        }
        for (Object child : children) {
            String elementLabel;
            if (this.structureProvider.isFolder(child) || !(elementLabel = this.structureProvider.getLabel(child)).equalsIgnoreCase("config.xml")) continue;
            ProjectRecord project = new ProjectRecord(child, entry, level, path);
            if (project.getProjectName() == null) {
                return false;
            }
            files.add(project);
        }
        return true;
    }

    protected void handleLocationDirectoryButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.directoryPathField.getShell(), 0x10000000);
        dialog.setMessage(DataTransferMessages.WizardProjectsImportPage_SelectDialogTitle);
        String dirName = this.directoryPathField.getText().trim();
        if (dirName.length() == 0) {
            dirName = previouslyBrowsedDirectory;
        }
        if (dirName.length() == 0) {
            dialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.directoryPathField.setText(previouslyBrowsedDirectory);
            this.updateProjectsList(selectedDirectory);
        }
    }

    protected void handleLocationArchiveButtonPressed() {
        FileDialog dialog = new FileDialog(this.archivePathField.getShell(), 0x10000000);
        dialog.setFilterExtensions(FILE_IMPORT_MASK);
        dialog.setText(DataTransferMessages.WizardProjectsImportPage_SelectArchiveDialogTitle);
        String fileName = this.archivePathField.getText().trim();
        if (fileName.length() == 0) {
            fileName = previouslyBrowsedArchive;
        }
        if (fileName.length() == 0) {
            dialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(fileName).getParentFile();
            if (path != null && path.exists()) {
                dialog.setFilterPath(path.toString());
            }
        }
        String selectedArchive = dialog.open();
        if (selectedArchive != null) {
            previouslyBrowsedArchive = selectedArchive;
            this.archivePathField.setText(previouslyBrowsedArchive);
            this.updateProjectsList(selectedArchive);
        }
    }

    public boolean createProjects() {
        this.saveWidgetValues();
        final Object[] selected = this.projectsList.getCheckedElements();
        this.createdProjects = new ArrayList<IProject>();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("", selected.length);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    int i = 0;
                    while (i < selected.length) {
                        WebProjectImportWizardPage.this.createExistingProject((ProjectRecord)selected[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        ++i;
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            String message = DataTransferMessages.WizardExternalProjectImportPage_errorMessage;
            Object status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, "org.eclipse.ui.ide", 1, message, t);
            ErrorDialog.openError((Shell)this.getShell(), (String)message, null, (IStatus)status);
            return false;
        }
        ArchiveFileManipulations.closeStructureProvider((ILeveledImportStructureProvider)this.structureProvider, (Shell)this.getShell());
        this.addToWorkingSets();
        return true;
    }

    private void addToWorkingSets() {
        IWorkingSet[] selectedWorkingSets = this.workingSetGroup.getSelectedWorkingSets();
        if (selectedWorkingSets == null || selectedWorkingSets.length == 0) {
            return;
        }
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        for (IProject project : this.createdProjects) {
            workingSetManager.addToWorkingSets((IAdaptable)project, selectedWorkingSets);
        }
    }

    public void performCancel() {
        ArchiveFileManipulations.closeStructureProvider((ILeveledImportStructureProvider)this.structureProvider, (Shell)this.getShell());
    }

    private boolean createExistingProject(ProjectRecord record, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        String projectName = record.getProjectName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        this.createdProjects.add(project);
        if (record.description == null) {
            record.description = workspace.newProjectDescription(projectName);
            if (record.projectArchiveFile != null) {
                record.description.setLocation(null);
            } else {
                Path locationPath = new Path(record.projectSystemFile.getAbsolutePath());
                if (Platform.getLocation() != null && Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                    record.description.setLocation(null);
                } else {
                    record.description.setLocation((IPath)locationPath);
                }
            }
        } else {
            record.description.setName(projectName);
        }
        if (record.projectArchiveFile != null) {
            List fileSystemObjects = this.structureProvider.getChildren(record.parent);
            fileSystemObjects = this.filterZipSourceList(fileSystemObjects, new File(record.projectArchiveFilePath));
            this.structureProvider.setStrip(record.level);
            ImportOperation operation = new ImportOperation(project.getFullPath(), this.structureProvider.getRoot(), (IImportStructureProvider)this.structureProvider, (IOverwriteQuery)this, fileSystemObjects);
            operation.setContext(this.getShell());
            operation.run(monitor);
        } else {
            URI locationURI;
            File importSource = null;
            if (this.copyFiles && (locationURI = record.description.getLocationURI()) != null) {
                importSource = new File(locationURI);
                IProjectDescription iProjectDescription = workspace.newProjectDescription(projectName);
                iProjectDescription.setBuildSpec(record.description.getBuildSpec());
                iProjectDescription.setComment(record.description.getComment());
                iProjectDescription.setDynamicReferences(record.description.getDynamicReferences());
                iProjectDescription.setNatureIds(record.description.getNatureIds());
                iProjectDescription.setReferencedProjects(record.description.getReferencedProjects());
                record.description = iProjectDescription;
            }
            try {
                try {
                    monitor.beginTask(DataTransferMessages.WizardProjectsImportPage_CreateProjectsTask, 100);
                    project.create(record.description, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                    project.open((IProgressMonitor)new SubProgressMonitor(monitor, 70));
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
            if (this.copyFiles && importSource != null) {
                List filesToImport = FileSystemStructureProvider.INSTANCE.getChildren((Object)importSource);
                this.filterFileSourceList(filesToImport, importSource);
                ImportOperation importOperation = new ImportOperation(project.getFullPath(), (Object)importSource, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (IOverwriteQuery)this, filesToImport);
                importOperation.setContext(this.getShell());
                importOperation.setOverwriteResources(true);
                importOperation.setCreateContainerStructure(false);
                importOperation.run(monitor);
            }
        }
        LinkedList<AbstractProjectTemplateOperation> operations = new LinkedList<AbstractProjectTemplateOperation>();
        TizenProjectDescriptOperation descOperation = new TizenProjectDescriptOperation();
        operations.add(descOperation);
        operations.add(new DefaultNatureOperation());
        operations.add(descOperation);
        operations.add(new ContentAssistOperation());
        try {
            for (IProjectTemplateOperation iProjectTemplateOperation : operations) {
                if (iProjectTemplateOperation.execute(null, project, null)) continue;
                throw new OperationCanceledException();
            }
            WebProjectCreator webProjectCreator = new WebProjectCreator(project);
            webProjectCreator.initializeConfigurationForImport(monitor);
        }
        catch (IOException iOException) {
            this.logger.error(iOException.getMessage(), (Throwable)iOException);
            return false;
        }
        catch (CoreException coreException) {
            this.logger.error(coreException.getMessage(), (Throwable)coreException);
            return false;
        }
        catch (ConfigurationException configurationException) {
            this.logger.error(configurationException.getMessage(), (Throwable)configurationException);
            return false;
        }
        return true;
    }

    private void filterFileSourceList(List sources, File sourceRootPath) {
        sources.remove(new File(sourceRootPath, String.valueOf(sourceRootPath.getName()) + ".wgt"));
        sources.remove(new File(sourceRootPath, SignatureUtility.getAuthorFilename()));
        sources.remove(new File(sourceRootPath, SignatureUtility.getDistributorFilename((int)1)));
        sources.remove(new File(sourceRootPath, SignatureUtility.getDistributorFilename((int)2)));
    }

    private List filterZipSourceList(List sources, File sourceRootPath) {
        Object[] filterList = new String[]{sourceRootPath.getName(), SignatureUtility.getAuthorFilename(), SignatureUtility.getDistributorFilename((int)1), SignatureUtility.getDistributorFilename((int)2)};
        ArrayList<ZipEntry> filteredResult = new ArrayList<ZipEntry>();
        for (Object source : sources) {
            ZipEntry zipSource;
            String name;
            if (!(source instanceof ZipEntry) || ArrayUtil.contains((Object[])filterList, (Object)(name = (zipSource = (ZipEntry)source).getName()))) continue;
            filteredResult.add(zipSource);
        }
        return filteredResult;
    }

    public String queryOverwrite(String pathString) {
        String returnCode;
        if ("ALL".equals(this.alwaysQueryState)) {
            return "ALL";
        }
        if ("NOALL".equals(this.alwaysQueryState)) {
            return "NOALL";
        }
        Path path = new Path(pathString);
        String messageString = path.getFileExtension() == null || path.segmentCount() < 2 ? NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_existsQuestion, (Object)pathString) : NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_overwriteNameAndPathQuestion, (Object)path.lastSegment(), (Object)path.removeLastSegments(1).toOSString());
        final MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), IDEWorkbenchMessages.Question, null, messageString, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        String[] response = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        this.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                dialog.open();
            }
        });
        String string = returnCode = dialog.getReturnCode() < 0 ? "CANCEL" : response[dialog.getReturnCode()];
        if ("ALL".equals(returnCode) || "NOALL".equals(returnCode)) {
            this.alwaysQueryState = returnCode;
        }
        return returnCode;
    }

    public Button getProjectFromDirectoryRadio() {
        return this.projectFromDirectoryRadio;
    }

    public CheckboxTreeViewer getProjectsList() {
        return this.projectsList;
    }

    private IProject[] getProjectsInWorkspace() {
        if (this.wsProjects == null) {
            this.wsProjects = IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getProjects();
        }
        return this.wsProjects;
    }

    public ProjectRecord[] getProjectRecords() {
        ArrayList<ProjectRecord> projectRecords = new ArrayList<ProjectRecord>();
        int i = 0;
        while (i < this.selectedProjects.length) {
            if (this.isProjectInWorkspace(this.selectedProjects[i].getProjectName())) {
                this.selectedProjects[i].hasConflicts = true;
            }
            projectRecords.add(this.selectedProjects[i]);
            ++i;
        }
        return projectRecords.toArray(new ProjectRecord[projectRecords.size()]);
    }

    private boolean isProjectInWorkspace(String projectName) {
        if (projectName == null) {
            return false;
        }
        IProject[] workspaceProjects = this.getProjectsInWorkspace();
        int i = 0;
        while (i < workspaceProjects.length) {
            if (projectName.equals(workspaceProjects[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.copyFiles = settings.getBoolean(STORE_COPY_PROJECT_ID);
            this.copyCheckbox.setSelection(this.copyFiles);
        }
        if (this.initialPath == null && settings != null) {
            boolean archiveSelected = settings.getBoolean(STORE_ARCHIVE_SELECTED);
            this.projectFromDirectoryRadio.setSelection(!archiveSelected);
            this.projectFromArchiveRadio.setSelection(archiveSelected);
            if (archiveSelected) {
                this.archiveRadioSelected();
            } else {
                this.directoryRadioSelected();
            }
        } else if (this.initialPath != null) {
            boolean dir = new File(this.initialPath).isDirectory();
            this.projectFromDirectoryRadio.setSelection(dir);
            this.projectFromArchiveRadio.setSelection(!dir);
            if (dir) {
                this.directoryPathField.setText(this.initialPath);
                this.directoryPathField.setSelection(this.initialPath.length());
                this.directoryRadioSelected();
            } else {
                this.archivePathField.setText(this.initialPath);
                this.archivePathField.setSelection(this.initialPath.length());
                this.archiveRadioSelected();
            }
        }
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_COPY_PROJECT_ID, this.copyCheckbox.getSelection());
            settings.put(STORE_ARCHIVE_SELECTED, this.projectFromArchiveRadio.getSelection());
        }
    }

    public Button getCopyCheckbox() {
        return this.copyCheckbox;
    }

    private final class ProjectLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ProjectLabelProvider() {
        }

        public String getText(Object element) {
            Assert.isTrue((boolean)(element instanceof ProjectRecord));
            return ((ProjectRecord)element).getProjectLabel();
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            Assert.isTrue((boolean)(element instanceof ProjectRecord));
            ProjectRecord projectRecord = (ProjectRecord)element;
            if (projectRecord.hasConflicts) {
                return WebProjectImportWizardPage.this.getShell().getDisplay().getSystemColor(15);
            }
            return null;
        }
    }

    public class ProjectRecord {
        File projectSystemFile;
        Object projectArchiveFile;
        String projectArchiveFilePath;
        String projectName;
        Object parent;
        int level;
        boolean hasConflicts;
        IProjectDescription description;

        ProjectRecord(File file) {
            this.projectSystemFile = file;
            this.setProjectName();
        }

        ProjectRecord(Object file, Object parent, int level) {
            this(file, parent, level, null);
        }

        ProjectRecord(Object file, Object parent, int level, String projectArchiveFilePath) {
            this.projectArchiveFile = file;
            this.parent = parent;
            this.level = level;
            this.projectArchiveFilePath = projectArchiveFilePath;
            this.setProjectName();
        }

        private void setProjectName() {
            try {
                if (this.projectArchiveFile != null && this.projectArchiveFilePath != null) {
                    File projectFile = new File(this.projectArchiveFilePath);
                    this.projectName = FileUtil.getFileNameWithoutExtension((String)projectFile.getName());
                }
                if (this.projectName == null && this.projectSystemFile != null) {
                    Path path = new Path(this.projectSystemFile.getPath());
                    if (this.isDefaultLocation((IPath)path)) {
                        this.projectName = path.segment(path.segmentCount() - 2);
                        this.description = IDEWorkbenchPlugin.getPluginWorkspace().newProjectDescription(this.projectName);
                    } else {
                        this.description = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription((IPath)path);
                        this.projectName = this.description.getName();
                    }
                }
            }
            catch (CoreException coreException) {}
        }

        private boolean isDefaultLocation(IPath path) {
            if (path.segmentCount() < 2) {
                return false;
            }
            return Platform.getLocation() == null ? false : path.removeLastSegments(2).toFile().equals(Platform.getLocation().toFile());
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getProjectLabel() {
            if (this.description == null) {
                return this.projectName;
            }
            String path = this.projectSystemFile == null ? WebProjectImportWizardPage.this.structureProvider.getLabel(this.parent) : this.projectSystemFile.getParent();
            return NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_projectLabel, (Object)this.projectName, (Object)path);
        }

        public boolean hasConflicts() {
            return this.hasConflicts;
        }
    }
}

