/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.gom.launch.GomLaunchData;
import org.tizen.common.gom.launch.IGomSmartLaunchShortcut;
import org.tizen.common.util.SWTUtil;
import org.tizen.web.browser.Activator;
import org.tizen.web.zimlaunch.constants.LaunchType;
import org.tizen.web.zimlaunch.constants.TizenWebLaunchConstants;
import org.tizen.web.zimlaunch.ui.AbstractLaunchShortcut;
import org.tizen.web.zimlaunch.ui.SmartLaunchRunnable;

public class TizenWebLaunchShortcut
extends AbstractLaunchShortcut
implements IGomSmartLaunchShortcut {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    protected ILaunchConfiguration createConfiguration(IProject project) throws CoreException {
        String launchConfigName = this.getLaunchManager().generateLaunchConfigurationName(project.getName());
        return this.createConfiguration(project, launchConfigName);
    }

    private ILaunchConfiguration createConfiguration(IProject project, String configName) throws CoreException {
        ILaunchConfiguration config = null;
        ILaunchConfigurationType configType = this.getConfigurationType();
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, configName);
        wc.setAttribute("org.tizen.common.CONFIG_ATTR_PROJECT_NAME", project.getName());
        wc.setAttribute(TizenWebLaunchConstants.ATTR_UPDATE_MODE, false);
        wc.setAttribute(TizenWebLaunchConstants.ATTR_LATEST_LAUNCH_TYPE, LaunchType.UNKNOWN.ordinal());
        wc.setAttribute(TizenWebLaunchConstants.ATTR_LIVE_EDITING, Activator.isEnabledLiveEditing());
        wc.setMappedResources(new IResource[]{project});
        DebugUITools.setLaunchPerspective((ILaunchConfigurationType)configType, (String)"run", (String)"perspective_default");
        DebugUITools.setLaunchPerspective((ILaunchConfigurationType)configType, (String)"debug", (String)"perspective_default");
        config = wc.doSave();
        return config;
    }

    @Override
    protected List<ILaunchConfiguration> getCandidateConfigs(IProject project, ILaunchConfigurationType configType) {
        List<ILaunchConfiguration> candidateConfigs = Collections.emptyList();
        if (project == null) {
            return candidateConfigs;
        }
        try {
            ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            ILaunchConfiguration[] iLaunchConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                String projectName = config.getAttribute("org.tizen.common.CONFIG_ATTR_PROJECT_NAME", "");
                if (projectName.equals(project.getName())) {
                    candidateConfigs.add(config);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage());
        }
        return candidateConfigs;
    }

    @Override
    protected ILaunchConfigurationType getConfigurationType() {
        ILaunchManager lm = this.getLaunchManager();
        ILaunchConfigurationType configType = lm.getLaunchConfigurationType("org.tizen.web.zimlaunch.WebAppLaunch");
        return configType;
    }

    public void smartLaunch(GomLaunchData data) {
        ILaunchConfiguration configuration = null;
        try {
            configuration = this.createConfiguration(data.getProject(), data.getLaunchConfigurationName());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        SWTUtil.syncExec((Runnable)new SmartLaunchRunnable(configuration, data));
    }
}

