/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.tizen.common.builder.BuildResult;
import org.tizen.common.builder.core.AbstractBuilder;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.IResource;
import org.tizen.common.util.FilenameUtil;
import org.tizen.sdblib.util.IOUtil;
import org.tizen.web.builder.util.WroExceptionUtil;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.js.RhinoCoffeeScriptProcessor;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;

public class CoffeeScriptBuilder
extends AbstractBuilder {
    public CoffeeScriptBuilder(String outputPath) {
        super(outputPath);
    }

    public CoffeeScriptBuilder(FileHandler fh) {
        super(fh);
    }

    public boolean canBuild(IResource resource) {
        if (!"coffee".equalsIgnoreCase(FilenameUtil.getExtension((String)resource.getPath()))) {
            return false;
        }
        return super.canBuild(resource);
    }

    protected BuildResult doBuild(IResource resource) throws BuildException {
        BuildResult br;
        block6: {
            br = new BuildResult(BuildResult.Status.UNKNOWN);
            InputStream is = null;
            ByteArrayOutputStream os = null;
            InputStreamReader isr = null;
            OutputStreamWriter osw = null;
            try {
                is = resource.getContents();
                isr = new InputStreamReader(is);
                os = new ByteArrayOutputStream();
                osw = new OutputStreamWriter(os);
                Resource roResource = new Resource();
                roResource.setType(ResourceType.JS);
                roResource.setUri(resource.getName());
                RhinoCoffeeScriptProcessor csp = new RhinoCoffeeScriptProcessor();
                csp.process(roResource, (Reader)isr, (Writer)osw);
                br.setResult(BuildResult.Status.SUCCESS);
                String path = resource.getPath();
                String outputPath = String.valueOf(path.substring(0, path.lastIndexOf(FilenameUtil.getExtension((String)path)))) + "js";
                this.addOutputResource(br, resource, outputPath, os.toByteArray());
            }
            catch (WroRuntimeException e) {
                br.addBuildErrorInfo(resource, WroExceptionUtil.getErrorLine(e), -1, 2, WroExceptionUtil.getErrorMessage(e));
                IOUtil.tryClose((Object[])new Object[]{is, isr, os, osw});
                break block6;
            }
            catch (IOException e) {
                try {
                    throw new BuildException((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{is, isr, os, osw});
                    throw throwable;
                }
            }
            IOUtil.tryClose((Object[])new Object[]{is, isr, os, osw});
        }
        return br;
    }
}

