/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.step;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ITizenProject;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.core.application.PackageResourceInfo;
import org.tizen.common.core.application.TizenPackageInfoStore;
import org.tizen.common.file.IResource;
import org.tizen.common.launch.TizenPackageInstaller;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.rds.DeltaResourceInfo;
import org.tizen.common.rds.RdsDeployer;
import org.tizen.common.rds.ui.preference.RdsPreferencePage;
import org.tizen.common.sign.util.SigningProfileUtil;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.sdblib.IDevice;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.packager.core.PackageProcessType;
import org.tizen.web.packager.core.exception.PackageException;
import org.tizen.web.packager.ui.ResourceManager;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.deployer.WebRdsDeployer;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebConsole;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.InstallStep;
import org.tizen.web.zimlaunch.step.KillStep;
import org.tizen.web.zimlaunch.step.Messages;
import org.tizen.web.zimlaunch.step.PackageStep;
import org.tizen.web.zimlaunch.step.RdsDeltaInputStep;
import org.tizen.web.zimlaunch.step.TransferStep;
import org.tizen.web.zimlaunch.step.UnInstallStep;
import org.tizen.web.zimlaunch.util.CommandLauncher;

public class RdsStep
extends CompositeStep {
    protected static final Logger logger = LoggerFactory.getLogger(RdsStep.class);
    public static final String name = Messages.STEP_RDS;
    public static final String CONFIG_DELTA = "tizen web config file delta";
    protected CommandLauncher launcher;
    protected TizenWebNotifier notifier;
    protected ZimLaunchResource resource;
    protected boolean isInstalled;
    protected String mode;
    protected int percent;

    public RdsStep() {
        super(new IStep[0]);
    }

    @Override
    public void executeStep(ILaunchContext ctx) throws Exception {
        UserLogger.start((String)"web.launch", (String)".rds");
        this.preExecuteStep(ctx);
        boolean isDeploy = false;
        IProject project = this.resource.getAppinfo().getProject();
        IDevice device = this.resource.getDeviceinfo().getDevice();
        CompositeStep subSteps = null;
        WebRdsDeployer deployer = null;
        try {
            deployer = new WebRdsDeployer(project, device, this.launcher, (ITizenConsoleManager)TizenWebConsole.getInstance(), "wgt", this.resource.getAppinfo().getAppPackageID(), null);
            if (!this.canRdsLaunch(project)) {
                deployer.removeResInfoFile();
                this.notifier.notifyContents(Messages.STEP_RDS_COULD_NOT_LAUNCH_AND_NEW_INSTALL, this.getWorkCount(100));
                subSteps = this.getNormalInstallSteps();
            } else {
                isDeploy = this.runRds(project, deployer);
                if (isDeploy) {
                    logger.debug(Messages.getSuccessMessage((String)Messages.STEP_RDS), (Object)this.getWorkCount(100));
                    UserLogger.end((String)"web.launch", (String)".rds");
                    subSteps = new CompositeStep(new RdsDeltaInputStep());
                    this.copyDeviceProfileToDevice(project, device);
                } else {
                    this.notifier.notifyContents(Messages.STEP_RDS_FAILED_AND_NEW_INSTALL, this.getWorkCount(100));
                    subSteps = this.getNormalInstallSteps();
                }
            }
            if (subSteps != null) {
                subSteps.executeStep(ctx);
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{deployer});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{deployer});
    }

    private void copyDeviceProfileToDevice(IProject project, IDevice device) throws CoreException {
        String profileName = SigningProfileUtil.getActiveProfileName();
        TizenPackageInstaller installer = new TizenPackageInstaller(project, device, profileName);
        installer.installDeviceProfile();
    }

    protected CompositeStep getNormalInstallSteps() {
        return new CompositeStep(new PackageStep(), new TransferStep(), new KillStep(), new UnInstallStep(), new InstallStep(new RdsDeltaInputStep()));
    }

    private boolean runRds(IProject project, WebRdsDeployer deployer) throws CoreException, IOException, ConfigurationException, JAXBException, XMLStreamException, PackageException {
        boolean isDeploy;
        int code;
        String errMsg;
        block8: {
            errMsg = "";
            code = 0;
            isDeploy = false;
            if (!deployer.isDeltaChanged("config.xml")) break block8;
            logger.debug("config.xml was changed.");
            IOUtil.tryClose((Object[])new Object[]{deployer});
            return false;
        }
        try {
            try {
                ResourceManager resourceManager = new ResourceManager(project);
                Collection<IResource> deltaResources = this.getDeltaResources(project, deployer.getDelta());
                resourceManager.setDeltaResources(deltaResources);
                PackageProcessType packageType = PackageProcessType.RUN;
                if ("debug".equals(this.mode)) {
                    packageType = PackageProcessType.DEBUG;
                }
                deployer.setInterestList(this.makeInterestList(project, resourceManager.generatePackagingWebResources(packageType), deployer));
                deployer.cleanDeltaInfo();
                deployer.setIgnoreList(this.makeIgnoreList(project));
                List referencedProjects = ProjectUtil.getReferencedProjects((IProject)project);
                if (referencedProjects != null && referencedProjects.size() > 0) {
                    this.setSubAppInterestList(referencedProjects, deployer);
                    this.setSubAppIgnoreList(referencedProjects, deployer);
                    for (IProject iproject : referencedProjects) {
                        deployer.appendIgnoreList(this.convertBlackListToRDSDeltaList(iproject));
                    }
                }
                deployer.setNotifier(this.notifier);
                deployer.setWork(this.getWorkCount(30));
                isDeploy = deployer.deploy();
            }
            catch (CoreException coreException) {
                code = TizenWebIDEExceptionCode.WEB_IDE_STEPRDSDEPLOY_FAIL.getCode();
                errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name);
                TizenWebIDEException.abort(Messages.getFailMessage((String)Messages.STEP_RDS), new TizenWebIDEException(errMsg, code), this.notifier);
                IOUtil.tryClose((Object[])new Object[]{deployer});
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{deployer});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{deployer});
        return isDeploy;
    }

    private List<DeltaResourceInfo> makeIgnoreList(IProject project) {
        ArrayList<DeltaResourceInfo> ignoreList = new ArrayList<DeltaResourceInfo>();
        ignoreList.add(new DeltaResourceInfo("/.sign/.manifest.tmp"));
        return ignoreList;
    }

    private boolean canRdsLaunch(IProject project) {
        return RdsPreferencePage.isWebRdsMode((IProject)project);
    }

    protected void preExecuteStep(ILaunchContext ctx) throws Exception {
        String errMsg = "";
        int code = 0;
        this.launcher = (CommandLauncher)ctx.getValue((Object)"command launcher");
        String eMsg = Messages.getFailMessage((String)Messages.TRANSFER_PACKAGE);
        if (this.launcher == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_COMMNAD_LAUNCHER.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(eMsg, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.resource = (ZimLaunchResource)ctx.getValue((Object)"resource");
        if (this.resource == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_LAUNCH_RESOURCE.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(eMsg, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.notifier = (TizenWebNotifier)ctx.getValue((Object)"notifier");
        this.isInstalled = (Boolean)ctx.getValue((Object)"widget installation");
        this.mode = (String)ctx.getValue((Object)"mode");
        this.work = 100;
        this.rwork = 100;
        this.percent = 10;
        this.pwork = this.notifier.getRemainWork() < 20 ? this.notifier.getPercentRemainWork(this.percent) : 10;
    }

    protected List<DeltaResourceInfo> makeInterestList(IProject project, Collection<IResource> interestResources, RdsDeployer deployer) throws CoreException, IOException {
        ArrayList<DeltaResourceInfo> interestList = new ArrayList<DeltaResourceInfo>();
        for (IResource resource : interestResources) {
            String localPath = "/";
            if (this.contains(interestList, localPath = String.valueOf(localPath) + FilenameUtil.getRelativePath((String)project.getLocation().toString(), (String)FileUtil.appendPath((String)resource.getFileHandler().getCurrentWorkingDirectory(), (String)resource.getPath())))) continue;
            StringBuilder remotePath = new StringBuilder("/").append("res/wgt").append("/").append(resource.getPath().replaceAll("\\\\", "/"));
            interestList.add(new DeltaResourceInfo(localPath, remotePath.toString()));
        }
        List deltaList = deployer.getDelta();
        interestList.addAll(this.getRemovedDeltaList(deltaList, project.getLocation().toString()));
        deployer.cleanDeltaInfo();
        String signPath = "/.sign/";
        String remoteSignPath = "/res/wgt/";
        if (ProjectUtil.isHybridApp((IProject)project)) {
            String manifestPath = "/info/" + TizenPlatformConstants.MANIFEST_XML_FILE_NAME;
            new DeltaResourceInfo("/.package" + TizenPlatformConstants.MANIFEST_XML_FILE_NAME, manifestPath);
            remoteSignPath = "/";
        }
        interestList.add(new DeltaResourceInfo(signPath, remoteSignPath));
        return interestList;
    }

    private Collection<IResource> getDeltaResources(IProject project, List<DeltaResourceInfo> deltas) {
        HashSet<IResource> deltaResources = new HashSet<IResource>();
        if (deltas == null || deltas.isEmpty()) {
            return deltaResources;
        }
        String projectFullPath = project.getLocation().toOSString();
        Collection originResources = ResourceManager.getOriginResources((IProject)project);
        for (IResource originResource : originResources) {
            for (DeltaResourceInfo dri : deltas) {
                String relativeResourcePath = FilenameUtil.getRelativePath((String)projectFullPath, (String)dri.getFullPath());
                if (!relativeResourcePath.equals(originResource.getPath())) continue;
                deltaResources.add(originResource);
            }
        }
        return deltaResources;
    }

    private Collection<? extends DeltaResourceInfo> getRemovedDeltaList(Collection<DeltaResourceInfo> deltaList, String projectPath) {
        ArrayList<Object> removedDeltas = new ArrayList<Object>();
        if (deltaList == null) {
            return removedDeltas;
        }
        for (DeltaResourceInfo dri : deltaList) {
            StringBuilder sb = new StringBuilder("/");
            sb.append(FilenameUtil.getRelativePath((String)projectPath, (String)dri.getFullPath()));
            if (!"delete".equals(dri.getType())) continue;
            switch (dri.getResourceType()) {
                case 2: {
                    sb.append("/");
                    removedDeltas.addAll(this.getRemovedDeltaList(dri.getChildren(), projectPath));
                }
            }
            String resourcePath = FileUtil.appendPath((String)"/res/wgt", (String)sb.toString());
            resourcePath = resourcePath.replace('\\', '/');
            DeltaResourceInfo removedDelta = new DeltaResourceInfo(sb.toString(), resourcePath);
            removedDeltas.add(removedDelta);
        }
        return removedDeltas;
    }

    private boolean contains(List<DeltaResourceInfo> interestList, String resourcePath) {
        for (DeltaResourceInfo interest : interestList) {
            if (!interest.getFullPath().equals(resourcePath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getStepName() {
        return name;
    }

    private void setSubAppInterestList(List<IProject> referencedProjects, WebRdsDeployer deployer) {
        int i = 0;
        while (i < referencedProjects.size()) {
            IProject referencedProject = referencedProjects.get(i);
            ITizenProject tizenProject = ProjectUtil.getTizenProject((IProject)referencedProject);
            if (tizenProject != null) {
                List subAppInterestList = null;
                subAppInterestList = i == 0 ? tizenProject.setSubAppInterestList(referencedProject, false, true) : tizenProject.setSubAppInterestList(referencedProject, false, false);
                if (subAppInterestList != null && subAppInterestList.size() > 0) {
                    deployer.appendInterestList(subAppInterestList);
                }
            }
            ++i;
        }
    }

    private void setSubAppIgnoreList(List<IProject> referencedProjects, WebRdsDeployer deployer) {
        int i = 0;
        while (i < referencedProjects.size()) {
            List subAppIgnoreList;
            IProject referencedProject = referencedProjects.get(i);
            ITizenProject tizenProject = ProjectUtil.getTizenProject((IProject)referencedProject);
            if (tizenProject != null && (subAppIgnoreList = tizenProject.setSubAppIgnoreList()) != null && subAppIgnoreList.size() > 0) {
                deployer.appendIgnoreList(subAppIgnoreList);
                break;
            }
            ++i;
        }
    }

    private List<DeltaResourceInfo> convertBlackListToRDSDeltaList(IProject project) {
        ArrayList<DeltaResourceInfo> appendIgnoreList = new ArrayList<DeltaResourceInfo>();
        ITizenProject tizenProject = ProjectUtil.getTizenProject((IProject)project);
        TizenPackageInfoStore tizenPkgInfoStore = tizenProject.getTizenPkgInfoStore();
        List blackList = tizenPkgInfoStore.getBlackList();
        if (blackList != null && blackList.size() > 0) {
            for (PackageResourceInfo packageInfo : blackList) {
                String name = packageInfo.getName();
                String remotePath = packageInfo.remotePath();
                int resourceType = packageInfo.getResourceType();
                DeltaResourceInfo ingoreDelta = new DeltaResourceInfo(name, "/" + name, remotePath, null, resourceType, project.getName());
                appendIgnoreList.add(ingoreDelta);
            }
        }
        return appendIgnoreList;
    }
}

