/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.initializer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Collection;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.compiler.libraries.LibraryLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.Assert;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.web.editor.widl.IDLReader;
import org.tizen.web.editor.widl.JavaScriptWriter;
import org.tizen.web.project.Activator;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractLibraryLocation
implements LibraryLocation {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String LIBRARY_DIRECTORY = "JSLibs";
    private IPath stateLocation;
    protected IPath workingLibPath;
    protected boolean isProduct = false;
    private ProfileInfo profileInfo;
    protected TizenProjectDescription tProject;

    public AbstractLibraryLocation(TizenProjectDescription tProject) {
        Assert.notNull((Object)tProject);
        this.tProject = tProject;
        this.stateLocation = Activator.getDefault().getStateLocation();
        this.isProduct = this.isProduct();
        this.convertXmlToJs();
    }

    protected boolean isProduct() {
        boolean result = false;
        this.profileInfo = InstallPathConfig.getProfileInfo((String)this.tProject.getProfileName());
        if (this.profileInfo != null) {
            result = this.profileInfo.isProduct();
        }
        return result;
    }

    protected void convertXmlToJs() {
        try {
            Document document = this.getDocument();
            if (document == null) {
                return;
            }
            Collection modules = IDLReader.getInstance().processDocument(document);
            File jsFile = new File(this.getLibraryPath(this.getLibraryFileNames()[0]));
            if (jsFile.exists()) {
                jsFile.delete();
            }
            JavaScriptWriter.getInstance().writeJSForModule(modules, jsFile);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected SAXReader getReader() {
        SAXReader reader = new SAXReader(false);
        reader.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String arg0, String arg1) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        return reader;
    }

    protected Document getDocument() throws DocumentException, IOException {
        IPath xmlPath;
        IPath platformPath;
        FileInputStream is;
        block3: {
            is = null;
            try {
                platformPath = null;
                platformPath = this.isProduct ? this.getParentPath() : this.getPlatformPath();
                xmlPath = this.getXMLPath();
                if (platformPath != null && xmlPath != null) break block3;
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{is});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{is});
            return null;
        }
        is = new FileInputStream(platformPath.append(xmlPath).toFile());
        Document document = this.getReader().read((InputStream)is);
        IOUtil.tryClose((Object[])new Object[]{is});
        return document;
    }

    protected IPath getParentPath() {
        IPath profilePath = this.getPlatformPath();
        profilePath = profilePath.removeLastSegments(1);
        String parentProfile = this.getParentProfile();
        return profilePath.append(parentProfile);
    }

    protected String getParentProfile() {
        return this.profileInfo.getParentProfileName(this.tProject.getVersion());
    }

    protected IPath getPlatformPath() {
        if (this.profileInfo == null) {
            return null;
        }
        String platformPath = this.profileInfo.getPlatformPath(this.tProject.getVersion());
        if (StringUtil.isEmpty((CharSequence)platformPath)) {
            this.logger.warn("Specified platform is not supported: {}. Use a latest platform.", (Object)this.tProject);
            ProfileInfo latestProfileInfo = InstallPathConfig.getLatestProfileInfo();
            if (latestProfileInfo == null) {
                return null;
            }
            platformPath = latestProfileInfo.getLatestPlatformPath();
        }
        return new Path(platformPath);
    }

    protected abstract IPath getXMLPath();

    public IPath getWorkingLibPath() {
        if (this.workingLibPath == null) {
            String platform = this.tProject.getPlatformName();
            this.workingLibPath = this.stateLocation.append(LIBRARY_DIRECTORY).append(platform);
            File workingLibFolder = this.workingLibPath.toFile();
            if (!workingLibFolder.exists()) {
                workingLibFolder.mkdirs();
            }
        }
        return this.workingLibPath;
    }

    public String getLibraryPath(String name) {
        return this.getWorkingLibPath().append(name).toString();
    }

    public String getLibraryPath(char[] name) {
        return this.getLibraryPath(new String(name));
    }

    public IPath getLibraryPathInPlugin() {
        return null;
    }
}

