/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.account.support;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.tizen.web.config.schema.model.Metadata;
import org.tizen.web.editor.configuration.Messages;

public class AddMetaDataDialog
extends SelectionStatusDialog {
    private List<Metadata> metadataList;
    Metadata fMetaData;
    List<Metadata> fExistingMeta;
    private Label fLabelKey;
    private Label fLabelValue;
    private Text fKeyText;
    private Text fValueText;

    public AddMetaDataDialog(Shell parentShell, List<Metadata> metaList, Metadata editTarget) {
        super(parentShell);
        this.setStatusLineAboveButtons(true);
        this.setHelpAvailable(false);
        this.fExistingMeta = metaList;
        if (editTarget == null) {
            this.setTitle(Messages.TizenPage_Metadata_AddTitle);
        } else {
            this.setTitle(Messages.TizenPage_Metadata_EditTitle);
            this.fMetaData = new Metadata();
            this.fMetaData.setKey(editTarget.getKey());
            this.fMetaData.setValue(editTarget.getValue());
            this.fExistingMeta.remove(editTarget);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite base = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = 20;
        layout.marginBottom = 9;
        layout.marginLeft = 20;
        layout.marginRight = 20;
        layout.verticalSpacing = 10;
        base.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.widthHint = 510;
        base.setLayoutData((Object)gd);
        AddMetaDataDialog.applyDialogFont((Control)base);
        this.fLabelKey = new Label(base, 1024);
        this.fLabelKey.setText(Messages.TizenPage_Metadata_KeyLabel);
        GridData lgd = new GridData(16384, 0x1000000, false, false, 1, 1);
        lgd.widthHint = 115;
        this.fLabelKey.setLayoutData((Object)lgd);
        this.fKeyText = new Text(base, 2048);
        this.fKeyText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fLabelValue = new Label(base, 0);
        this.fLabelValue.setLayoutData((Object)lgd);
        this.fLabelValue.setText(Messages.TizenPage_Metadata_ValueLabel);
        this.fValueText = new Text(base, 2048);
        this.fValueText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.fMetaData != null) {
            this.fKeyText.setText(this.fMetaData.getKey());
            this.fValueText.setText(this.fMetaData.getValue());
        }
        this.fKeyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddMetaDataDialog.this.validate();
            }
        });
        this.fValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddMetaDataDialog.this.validate();
            }
        });
        this.validate();
        return base;
    }

    private void validate() {
        this.computeResult();
        Status status = null;
        if (this.fMetaData.getKey().length() <= 0) {
            status = new Status(4, "org.tizen.common", Messages.TizenPage_Metadata_EmptyKeyError);
            this.updateStatus((IStatus)status);
            return;
        }
        for (Metadata m : this.fExistingMeta) {
            if (!m.getKey().equals(this.fMetaData.getKey())) continue;
            status = new Status(4, "org.tizen.common", Messages.TizenPage_Metadata_DuplicateKeyError);
            this.updateStatus((IStatus)status);
            return;
        }
        status = new Status(0, "org.tizen.common", null);
        this.updateStatus((IStatus)status);
    }

    protected void computeResult() {
        if (this.fMetaData == null) {
            this.fMetaData = new Metadata();
        }
        this.fMetaData.setKey(this.fKeyText.getText().trim());
        this.fMetaData.setValue(this.fValueText.getText().trim());
    }

    public List<Metadata> getMetadataList() {
        if (this.metadataList == null) {
            this.metadataList = new ArrayList<Metadata>();
        }
        return this.metadataList;
    }

    public Metadata getMetaData() {
        return this.fMetaData;
    }
}

