/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.notification;

import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.views.console.ProcessConsoleManager;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.tizen.common.ui.view.console.HyperlinkManager;
import org.tizen.common.ui.view.console.IHyperlinkManager;
import org.tizen.common.ui.view.console.LinkInfo;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.web.zimlaunch.notification.ProcessConsoleSpy;
import org.tizen.web.zimlaunch.notification.ProcessConsoleStream;

public class LaunchProcessConsoleManager
extends ProcessConsoleManager
implements IHyperlinkManager {
    protected final IProcess process;
    protected final ProcessConsoleSpy console;
    protected final HyperlinkManager hyperlinkManager;
    protected int documentLength = 0;

    public LaunchProcessConsoleManager(IProcess process, IConsoleColorProvider colorProvider, String consoleName, boolean focus) {
        this.process = process;
        this.console = this.createProcessConsole(process, colorProvider);
        this.hyperlinkManager = new HyperlinkManager((TextConsole)this.console);
        this.console.getDocument().addDocumentListener((IDocumentListener)this.hyperlinkManager);
        if (focus) {
            this.getConsoleManager().showConsoleView((IConsole)this.console);
        }
        this.setName(consoleName);
    }

    public LaunchProcessConsoleManager(IProcess process, String consoleName, boolean focus) {
        this.process = process;
        this.console = this.createProcessConsole(process, (IConsoleColorProvider)new ConsoleColorProvider());
        this.hyperlinkManager = new HyperlinkManager((TextConsole)this.console);
        this.console.getDocument().addDocumentListener((IDocumentListener)this.hyperlinkManager);
        if (focus) {
            this.console.activate();
        }
        this.setName(consoleName);
    }

    protected synchronized ProcessConsoleSpy createProcessConsole(IProcess process, IConsoleColorProvider colorProvider) {
        IConsole console = this.getConsole(process);
        if (console == null) {
            IConsoleColorProvider color = colorProvider;
            if (color == null) {
                color = new ConsoleColorProvider();
            }
            ProcessConsoleSpy console2 = new ProcessConsoleSpy(process, color);
            this.getConsoleManager().addConsoles(new IConsole[]{console2});
            return console2;
        }
        return (ProcessConsoleSpy)console;
    }

    protected IConsoleManager getConsoleManager() {
        return ConsolePlugin.getDefault().getConsoleManager();
    }

    protected IConsole[] getConsoles() {
        return this.getConsoleManager().getConsoles();
    }

    protected IConsole getConsole() {
        return this.console;
    }

    public void setName(final String newName) {
        if (newName == null) {
            throw new NullPointerException();
        }
        SWTUtil.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (LaunchProcessConsoleManager.this.console == null) {
                    return;
                }
                LaunchProcessConsoleManager.this.console.setName(newName);
            }
        });
    }

    public synchronized void clear() {
        SWTUtil.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                IDocument document = LaunchProcessConsoleManager.this.console.getDocument();
                if (document == null) {
                    return;
                }
                document.set("");
            }
        });
        this.documentLength = 0;
    }

    public void show() {
        SWTUtil.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = SWTUtil.getActivePage();
                if (page == null) {
                    throw new IllegalStateException();
                }
                try {
                    IConsoleView view = (IConsoleView)page.showView("org.eclipse.ui.console.ConsoleView");
                    view.display(LaunchProcessConsoleManager.this.getConsole());
                }
                catch (PartInitException e) {
                    ConsolePlugin.log((Throwable)e);
                }
            }
        });
    }

    protected ProcessConsoleStream getConsoleStream() {
        ProcessConsoleStream stream = this.createConsoleStream();
        return stream;
    }

    protected ProcessConsoleStream createConsoleStream() {
        ProcessConsoleStream stream = this.console.newProcessConsoleOutputStream();
        return stream;
    }

    public synchronized void print(String message) {
        ProcessConsoleStream stream = this.getConsoleStream();
        try {
            stream.print(message);
            this.documentLength += message.length();
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{stream});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{stream});
    }

    public synchronized void println(String line) {
        ProcessConsoleStream output = this.createConsoleStream();
        try {
            output.println(line);
            this.documentLength += line.length() + 1;
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{output});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{output});
    }

    public void addLinker(LinkInfo link) {
        this.hyperlinkManager.addLinker(link);
    }
}

