/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.widl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.IOUtil;
import org.tizen.web.editor.widl.model.Argument;
import org.tizen.web.editor.widl.model.Attribute;
import org.tizen.web.editor.widl.model.Constant;
import org.tizen.web.editor.widl.model.Interface;
import org.tizen.web.editor.widl.model.Method;
import org.tizen.web.editor.widl.model.Module;

public class JavaScriptWriter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static String separator = "\n";
    private static JavaScriptWriter instance;
    private static JavaScriptWriter minifier;
    private byte[] COMMENT_START;
    private byte[] COMMENT_SEP;
    private String SEP;
    private boolean TYPE_IDENTIFIER;
    private List<String> PRIMITIVE_TYPES = Arrays.asList("Boolean", "Number", "Object", "String");

    public static synchronized JavaScriptWriter getInstance() {
        if (instance == null) {
            instance = new JavaScriptWriter();
            JavaScriptWriter.instance.COMMENT_START = ("/**" + separator).getBytes();
            JavaScriptWriter.instance.COMMENT_SEP = (" *" + separator).getBytes();
            JavaScriptWriter.instance.SEP = String.valueOf(separator) + separator;
            JavaScriptWriter.instance.TYPE_IDENTIFIER = true;
        }
        return instance;
    }

    public static synchronized JavaScriptWriter getMinifier() {
        if (minifier == null) {
            minifier = new JavaScriptWriter();
            JavaScriptWriter.minifier.COMMENT_START = "/**".getBytes();
            JavaScriptWriter.minifier.COMMENT_SEP = "".getBytes();
            JavaScriptWriter.minifier.SEP = separator;
            JavaScriptWriter.minifier.TYPE_IDENTIFIER = false;
        }
        return minifier;
    }

    private String getTypeIdentifierString(String type) {
        if (this.TYPE_IDENTIFIER || this.PRIMITIVE_TYPES.indexOf(type) != -1) {
            return "{" + type + "}";
        }
        return type;
    }

    private JavaScriptWriter() {
    }

    public synchronized void writeJSForModule(Collection<Module> modules, File file) {
        block7: {
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(file);
                for (Module module : modules) {
                    this.writeJSForModule(stream, module);
                }
            }
            catch (FileNotFoundException ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
                IOUtil.tryClose((Object[])new Object[]{stream});
                break block7;
            }
            catch (IOException ex) {
                try {
                    this.logger.error(ex.getMessage(), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{stream});
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{stream});
                break block7;
            }
            IOUtil.tryClose((Object[])new Object[]{stream});
        }
    }

    private void writeJSForModule(OutputStream os, Module module) throws IOException {
        Collection<Interface> interfaces = module.getInterfaces();
        for (Interface interfaze : interfaces) {
            if (interfaze.isSupplemental()) continue;
            os.write(this.COMMENT_START);
            os.write(new String(" * " + interfaze.getDescription() + separator).getBytes());
            os.write(this.COMMENT_SEP);
            os.write((" * @super Object" + separator).getBytes());
            os.write((" * @constructor" + separator).getBytes());
            os.write(new String(" * @return {" + interfaze.getName() + "}" + separator).getBytes());
            os.write((" */" + separator).getBytes());
            os.write(new String("function " + interfaze.getName() + "() {};" + separator).getBytes());
            String parentInterface = interfaze.getParentInterface();
            if (parentInterface != null) {
                os.write(new String(String.valueOf(interfaze.getName()) + ".prototype = new " + parentInterface + "();" + this.SEP).getBytes());
                continue;
            }
            os.write(new String(String.valueOf(interfaze.getName()) + ".prototype = new Object();" + this.SEP).getBytes());
        }
        for (Interface interfaze : interfaces) {
            Vector<Constant> constants = interfaze.getConstants();
            for (Constant constant : constants) {
                os.write(this.COMMENT_START);
                os.write(new String(" * " + constant.getDescription() + separator).getBytes());
                os.write(this.COMMENT_SEP);
                os.write(new String(" * @type " + constant.getTypeName() + separator).getBytes());
                os.write((" */" + separator).getBytes());
                os.write(new String(String.valueOf(interfaze.getName()) + "." + constant.getName() + " = new Number();" + this.SEP).getBytes());
            }
            Vector<Attribute> attributes = interfaze.getAttributes();
            for (Attribute attribute : attributes) {
                this.writeAttribute(os, interfaze.getName(), attribute, false);
            }
            Vector<Method> methods = interfaze.getMethods();
            for (Method method : methods) {
                this.writeMethod(os, interfaze.getName(), method, false);
            }
        }
        for (String[] declaration : module.getImplementationDeclarations()) {
            if (2 != declaration.length) continue;
            String target = declaration[0];
            String source = declaration[1];
            Interface sourceInterface = null;
            for (Interface interfaze : interfaces) {
                if (!interfaze.getName().equals(source)) continue;
                sourceInterface = interfaze;
            }
            if (sourceInterface == null) continue;
            for (Attribute attribute : sourceInterface.getAttributes()) {
                this.writeAttribute(os, target, attribute, false);
            }
            for (Method method : sourceInterface.getMethods()) {
                this.writeMethod(os, target, method, false);
            }
        }
    }

    private void writeAttribute(OutputStream os, String targetType, Attribute attribute, boolean isStaticMember) throws IOException {
        os.write(this.COMMENT_START);
        os.write(new String(" * " + attribute.getDescription() + separator).getBytes());
        os.write(this.COMMENT_SEP);
        if (attribute.getFeature() != null) {
            os.write(new String(" * @feature " + attribute.getFeature() + separator).getBytes());
        }
        os.write(new String(" * @type " + attribute.getTypeName() + separator).getBytes());
        os.write((" */" + separator).getBytes());
        if (isStaticMember) {
            os.write(new String(String.valueOf(targetType) + "." + attribute.getName() + " = " + this.getTypeConstructor(attribute.getTypeName()) + ";" + this.SEP).getBytes());
        } else {
            os.write(new String(String.valueOf(targetType) + ".prototype." + attribute.getName() + " = " + this.getTypeConstructor(attribute.getTypeName()) + ";" + this.SEP).getBytes());
        }
    }

    private void writeMethod(OutputStream os, String typeName, Method method, boolean isStaticMember) throws IOException {
        os.write(this.COMMENT_START);
        os.write(new String(" * " + method.getDescription() + separator).getBytes());
        os.write(this.COMMENT_SEP);
        Vector<Argument> args = method.getArguments();
        int k = 0;
        while (k < args.size()) {
            Argument argument = args.elementAt(k);
            os.write(new String(" * @param " + this.getTypeIdentifierString(argument.getTypeName()) + " " + argument.getName() + separator).getBytes());
            ++k;
        }
        os.write(new String(" * @type " + method.getReturnType() + separator).getBytes());
        os.write(new String(" * @memberOf " + typeName + separator).getBytes());
        os.write(new String(" * @returns " + this.getTypeIdentifierString(method.getReturnType()) + separator).getBytes());
        os.write((" */" + separator).getBytes());
        if (isStaticMember) {
            os.write(new String(String.valueOf(typeName) + "." + method.getName() + " = function(").getBytes());
        } else {
            os.write(new String(String.valueOf(typeName) + ".prototype." + method.getName() + " = function(").getBytes());
        }
        k = 0;
        while (k < args.size()) {
            os.write(args.elementAt(k).getName().getBytes());
            if (k + 1 < args.size()) {
                os.write(", ".getBytes());
            }
            ++k;
        }
        os.write(")".getBytes());
        String returnType = method.getReturnType();
        if (returnType == null || "void".equals(returnType)) {
            os.write(("{ return; };" + this.SEP).getBytes());
        } else {
            os.write(("{ var ret = " + this.getTypeConstructor(method.getReturnType()) + "; return ret; };" + this.SEP).getBytes());
        }
    }

    private String getTypeConstructor(String typeName) {
        if (typeName != null && typeName.endsWith("Array")) {
            String returnType = typeName.substring(0, typeName.length() - 5);
            if (returnType.isEmpty()) {
                return "[new Object()]";
            }
            return "[new " + returnType + "()]";
        }
        return "new " + typeName + "()";
    }
}

