/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.cli.command;

import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.util.Assert;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.ZipUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.web.zimlaunch.cli.command.WRTCommand;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class InstallCommand
extends WRTCommand {
    protected static final String WRT_INSTALL_COMMAND = TizenPlatformConstants.PKG_TOOL_INSTALL_COMMAND;
    protected String remotePath;
    protected String localPath;
    protected String pkgNamePrefix = "pkg_name[";
    protected String widget;

    public InstallCommand(IDevice device, String widget) {
        this.setDevice(device);
        this.remotePath = String.valueOf(TizenPlatformConstants.getAppTmpDirectory((IDevice)device)) + "/";
        this.widget = widget;
    }

    public String getWidget() {
        return this.widget;
    }

    public void setWidget(String widget) {
        if (!this.isWidget(widget)) {
            Assert.fail((Object)"correct widget extension is .wgt");
        }
        this.widget = widget;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public void setRemotePath(String remotePath) {
        this.remotePath = remotePath;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    protected String getExtention(String widget) {
        int extentpos = widget.lastIndexOf(46);
        if (extentpos > 0 && extentpos < widget.length() - 1) {
            return widget.substring(extentpos + 1).toLowerCase();
        }
        return "";
    }

    protected boolean isWidget(String widget) {
        return "wgt".equals(this.getExtention(widget));
    }

    protected String createCommand() {
        if (!this.isWidget(this.getWidget())) {
            Assert.fail((Object)"correct widget extension is .wgt");
        }
        String cmd = String.format(WRT_INSTALL_COMMAND, "wgt", String.valueOf(this.getRemotePath()) + this.getWidget());
        return cmd;
    }

    @Override
    protected boolean checkCommandReturnCode() {
        return super.checkCommandReturnCode();
    }

    @Override
    public void run(Executor executor, ExecutionContext context) throws Exception {
        this.setCommand(this.createCommand());
        super.run(executor, context);
        String appid = this.getAppIdLocal();
        String string = appid = appid != null ? appid : this.getAppId();
        if (StringUtil.isEmpty((CharSequence)appid)) {
            appid = this.getWidget();
        }
        String msg = this.checkCommandReturnCode() ? MessageFormat.format("''{0}'' install successful.", appid) : MessageFormat.format("''{0}'' install failed.", appid);
        if (this.isPrintOption()) {
            context.getPrompter().notify(msg);
        }
    }

    @Override
    public void undo(Executor executor, ExecutionContext context) throws Exception {
        super.undo(executor, context);
    }

    protected String getAppIdLocal() throws IOException, ParserConfigurationException, SAXException {
        String path = this.getLocalPath();
        String contents = ZipUtil.getContent((String)path, (String)"config.xml");
        if (StringUtil.isEmpty((CharSequence)contents)) {
            return null;
        }
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(contents));
        Document doc = db.parse(is);
        NodeList nodes = doc.getElementsByTagName("tizen:application");
        if (nodes.getLength() < 1) {
            return null;
        }
        Element tizen = (Element)nodes.item(0);
        return tizen.getAttribute("id");
    }

    protected String getAppId() {
        String ori = this.getResult();
        if (StringUtil.isEmpty((CharSequence)ori)) {
            return ori;
        }
        String[] arr = StringUtil.split((String)ori, (String)"\n");
        if (arr.length > 1) {
            int start = arr[1].indexOf(this.pkgNamePrefix) + this.pkgNamePrefix.length();
            String appID = arr[1].substring(start, start + 10);
            return appID;
        }
        return null;
    }
}

