/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XMLErrorHandler
implements ErrorHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    IFile file = null;

    public XMLErrorHandler(IFile configFile) {
        this.file = configFile;
    }

    private void createMarker(SAXParseException exception, int severityWarning) {
        try {
            IMarker marker = this.file.createMarker("org.tizen.web.editor.configuration.problemmarker.xmlSchema");
            marker.setAttribute("severity", severityWarning);
            String message = this.splitMessage(exception.getMessage());
            if (message == null) {
                message = exception.getMessage();
            }
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("org.eclipse.core.resources.textmarker", (Object)message);
            marker.setAttribute("lineNumber", exception.getLineNumber());
            marker.setAttribute("transient", false);
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private String splitMessage(String message) {
        int index = message.indexOf(":");
        if (index != -1) {
            String splitedMessage = message.substring(index + 2);
            return splitedMessage;
        }
        return null;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.createMarker(exception, 1);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (exception.getLocalizedMessage().contains("ar-ae")) {
            return;
        }
        this.createMarker(exception, 2);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.createMarker(exception, 2);
    }
}

