/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.tizen.common.builder.BuildResult;
import org.tizen.common.builder.core.AbstractBuilder;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.file.IResource;
import org.tizen.sdblib.util.IOUtil;
import org.tizen.web.compressor.minifier.core.HTMLMinifier;
import org.tizen.web.compressor.minifier.core.JavaScriptEvaluatorException;

public class HTMLMinifyBuilder
extends AbstractBuilder {
    protected final HTMLMinifier compressor = new HTMLMinifier();

    public HTMLMinifyBuilder(String output) {
        super(output);
    }

    public boolean canBuild(IResource resource) {
        if (super.canBuild(resource)) {
            return this.compressor.canHandle(resource.getName());
        }
        return false;
    }

    protected BuildResult doBuild(IResource resource) throws BuildException {
        BuildResult result = new BuildResult(BuildResult.Status.UNKNOWN);
        InputStream in = null;
        ByteArrayOutputStream os = null;
        try {
            try {
                in = resource.getContents();
                os = new ByteArrayOutputStream();
                this.logger.debug("html minify : {}", (Object)resource.getPath());
                this.compressor.compress(in, (OutputStream)os);
                this.addOutputResource(result, resource, resource.getPath(), os.toByteArray());
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            catch (JavaScriptEvaluatorException e) {
                throw new BuildException(String.valueOf(resource.getPath()) + " - " + " : " + e.columnNumber() + " : " + e.getDetail() + "\n\nSource:\n" + e.getLineSource(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{in, os});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{in, os});
        return result;
    }
}

