/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.util;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.Version;
import org.tizen.sdblib.Device;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.PlatformCapability;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.web.zimlaunch.step.Messages;

public class ExtensionUtil {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionUtil.class);

    private static boolean isMatchedExtension(IExtension extension, IDevice device, String profile, Version version) {
        String maxVersion;
        block11: {
            IConfigurationElement[] elements;
            String profileName = null;
            String vendorName = null;
            String minVersion = null;
            maxVersion = null;
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals("info")) {
                    profileName = element.getAttribute("profileName");
                    vendorName = element.getAttribute("vendorName");
                    minVersion = element.getAttribute("minProfileVersion");
                    maxVersion = element.getAttribute("maxProfileVersion");
                }
                ++n2;
            }
            if (!profile.equals(profileName)) {
                return false;
            }
            try {
                PlatformCapability pc = new PlatformCapability((Device)device);
                if (!pc.getVendorName().equals(vendorName)) {
                    return false;
                }
            }
            catch (TimeoutException e) {
                logger.warn(Messages.CANNOT_GET_PLATFORM_CAPABILITY);
                logger.warn(e.getMessage());
                return false;
            }
            catch (SdbCommandRejectedException e) {
                logger.warn(Messages.CANNOT_GET_PLATFORM_CAPABILITY);
                logger.warn(e.getMessage());
                return false;
            }
            catch (IOException e) {
                logger.warn(Messages.CANNOT_GET_PLATFORM_CAPABILITY);
                logger.warn(e.getMessage());
                return false;
            }
            try {
                if (minVersion == null || version.compareTo(new Version(minVersion)) >= 0) break block11;
                return false;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.warn("Version of extension is not acceptable format.");
                return false;
            }
        }
        return maxVersion == null || new Version(maxVersion).compareTo(version) >= 0;
    }

    private static <T> T getExtensionExecutable(Class<T> type, IExtension extension, String propertyName) throws CoreException {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("info")) {
                Object o = element.createExecutableExtension(propertyName);
                try {
                    return type.cast(o);
                }
                catch (ClassCastException classCastException) {
                    logger.warn("Type of executable is not a type " + type);
                    return null;
                }
            }
            ++n2;
        }
        return null;
    }

    private static IExtension[] getLaunchExtensions(String pluginID) {
        return Platform.getExtensionRegistry().getExtensionPoint(pluginID, "launchStepFactory").getExtensions();
    }

    public static <T> T getExtendedExecutable(Class<T> type, String property, String pluginID, IDevice device, String profile, Version version) {
        if (profile == null || version == null) {
            logger.info("Profile or version is null.");
            return null;
        }
        IExtension[] extensions = ExtensionUtil.getLaunchExtensions(pluginID);
        if (extensions == null) {
            logger.info("There is no launch extensions extended in " + pluginID);
            return null;
        }
        T executable = null;
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (ExtensionUtil.isMatchedExtension(extension, device, profile, version)) {
                try {
                    executable = ExtensionUtil.getExtensionExecutable(type, extension, property);
                    break;
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            ++n2;
        }
        return executable;
    }
}

