/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.bgcategory;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.tizen.web.config.schema.model.ActivationType;
import org.tizen.web.config.schema.model.BackgroundCategory;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.page.IGroupTableEvent;
import org.tizen.web.editor.configuration.page.TizenPage;

public class BgCategoryGroupTableEvent
implements IGroupTableEvent {
    public static String[] BG_CATEGORY_TYPES = new String[]{"media", "download", "location", "background-network", "sensor", "iot-communication"};
    private TableViewer tableViewer;
    private TizenPage page;

    public BgCategoryGroupTableEvent(TizenPage page, TableViewer tableViewer) {
        this.page = page;
        this.tableViewer = tableViewer;
    }

    @Override
    public void onRemove() {
        IStructuredSelection sel = (IStructuredSelection)this.tableViewer.getSelection();
        Object element = sel.getFirstElement();
        if (element != null) {
            this.tableViewer.remove(element);
            this.page.markDirty();
            if (this.tableViewer.getTable().getItemCount() <= 0) {
                this.page.setBackgroundSupport(ActivationType.DISABLE);
            }
            this.page.setBGCategoryUI(this.page.getRequiredVersion(), this.tableViewer.getTable().getItemCount());
        }
    }

    @Override
    public void onAdd() {
        BackgroundCategory category;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((BackgroundCategory)element).getValue();
            }
        });
        dialog.setTitle(Messages.TizenPage_BackgroundCategoryAddDialogTitle);
        dialog.setMessage("Category types");
        dialog.setElements((Object[])this.getUnusedCategories());
        if (dialog.open() == 0 && (category = (BackgroundCategory)dialog.getFirstResult()) != null) {
            this.tableViewer.add((Object)category);
            this.page.markDirty();
            this.page.setBGCategoryUI(this.page.getRequiredVersion(), this.tableViewer.getTable().getItemCount());
            if (this.tableViewer.getTable().getItemCount() > 0) {
                this.page.setBackgroundSupport(ActivationType.ENABLE);
            }
        }
    }

    private BackgroundCategory[] getUnusedCategories() {
        boolean isUsed = false;
        ArrayList<BackgroundCategory> result = new ArrayList<BackgroundCategory>();
        String[] stringArray = BG_CATEGORY_TYPES;
        int n = BG_CATEGORY_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            isUsed = false;
            TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
            int n3 = tableItemArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TableItem item = tableItemArray[n4];
                if (type.equals(((BackgroundCategory)item.getData()).getValue())) {
                    isUsed = true;
                    break;
                }
                ++n4;
            }
            if (!isUsed) {
                BackgroundCategory bc = new BackgroundCategory();
                bc.setValue(type);
                result.add(bc);
            }
            ++n2;
        }
        return result.toArray(new BackgroundCategory[0]);
    }
}

