/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder;

import java.util.Collection;
import org.tizen.common.builder.BuildResult;
import org.tizen.common.builder.IBuildListener;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.file.IResource;
import org.tizen.web.builder.AbstractLintBuilder;
import org.tizen.web.csslint.CssLintValidator;

public class CssLintBuilder
extends AbstractLintBuilder {
    private String errorLevel = "WARNING";
    protected CssLintValidator validator = new CssLintValidator();
    public static final String CSS = "css";

    public CssLintBuilder() {
        this((IBuildListener)null);
    }

    public CssLintBuilder(IBuildListener buildListener) {
        super(CSS, buildListener);
    }

    public void setCheckingErrorLevel(String level) {
        this.errorLevel = level;
    }

    public CssLintValidator getCSSLintValidator() {
        return this.validator;
    }

    protected BuildResult doBuild(IResource resource) throws BuildException {
        this.logger.debug("CssLintBuilder: " + resource.getName());
        BuildResult buildResult = new BuildResult(BuildResult.Status.UNKNOWN);
        buildResult.setResult(BuildResult.Status.SUCCESS);
        Collection buildErrInfos = this.validator.validate(resource, this.errorLevel);
        if (buildErrInfos == null) {
            return buildResult;
        }
        BuildResult.Status status = BuildResult.Status.WARNING;
        if (this.validator.getSeverity() == 2) {
            status = BuildResult.Status.ERROR;
        }
        buildResult.setResult(status);
        buildResult.getBuildErrorInfos().addAll(buildErrInfos);
        return buildResult;
    }
}

