/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.widl.model;

import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.tizen.web.config.schema.model.AppdefinedPrivilege;
import org.tizen.web.config.schema.model.AppdefinedPrivilegeUserType;
import org.tizen.web.config.schema.model.Privilege;
import org.tizen.web.config.schema.model.ProvidesAppdefinedPrivilege;

public class PrivilegeWrapper
implements Comparable<PrivilegeWrapper> {
    public static final String PUBLIC_LEVEL = "public";
    public static final String PARTNER_LEVEL = "partner";
    public static final String PLATFORM_LEVEL = "platform";
    public static final String PREFIX_PROVIDER = "[App-defined-provider] ";
    public static final String PREFIX_CONSUMER = "[App-defined-consumer] ";
    private String privilgeName;
    private String privilgeLevel;
    private String privilgeDesc;
    private String privilgeUser;
    private String privilgeLicense;

    public PrivilegeWrapper(String name) {
        this.privilgeName = name;
        this.privilgeLevel = PUBLIC_LEVEL;
    }

    public PrivilegeWrapper(Privilege privilegeElement) {
        this.privilgeName = privilegeElement.getName();
        this.privilgeLevel = PUBLIC_LEVEL;
    }

    public PrivilegeWrapper(AppdefinedPrivilege appdefinedPrivilegeElement) {
        this.privilgeName = appdefinedPrivilegeElement.getName();
        this.privilgeLevel = PUBLIC_LEVEL;
        this.privilgeUser = AppdefinedPrivilegeUserType.CONSUMER.value();
        this.privilgeLicense = appdefinedPrivilegeElement.getLicense();
    }

    public PrivilegeWrapper(ProvidesAppdefinedPrivilege providesAppdefinedPrivilegesElement) {
        this.privilgeName = providesAppdefinedPrivilegesElement.getName();
        this.privilgeLevel = PUBLIC_LEVEL;
        this.privilgeUser = AppdefinedPrivilegeUserType.PROVIDER.value();
        this.privilgeLicense = providesAppdefinedPrivilegesElement.getLicense();
    }

    public String getName() {
        return this.privilgeName;
    }

    public String getShowName() {
        if (this.privilgeUser != null) {
            if (AppdefinedPrivilegeUserType.fromValue((String)this.privilgeUser).equals((Object)AppdefinedPrivilegeUserType.PROVIDER)) {
                return PREFIX_PROVIDER + this.privilgeName;
            }
            return PREFIX_CONSUMER + this.privilgeName;
        }
        return this.privilgeName;
    }

    public void setName(String name) {
        this.privilgeName = name;
    }

    public String getPrivilgeLevel() {
        return this.privilgeLevel;
    }

    public void setPrivilgeLevel(String privilgeLevel) {
        this.privilgeLevel = privilgeLevel;
    }

    public String getPrivilgeDesc() {
        return this.privilgeDesc;
    }

    public void setPrivilgeDesc(String privilgeDesc) {
        this.privilgeDesc = privilgeDesc;
    }

    public String getPrivilgeUser() {
        return this.privilgeUser;
    }

    public void setPrivilgeUser(String privilgeUser) {
        this.privilgeUser = privilgeUser;
    }

    public String getPrivilgeLicense() {
        return this.privilgeLicense;
    }

    public void setPrivilgeLicense(String privilgeLicense) {
        this.privilgeLicense = privilgeLicense;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.privilgeName).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PrivilegeWrapper) {
            PrivilegeWrapper privilege = (PrivilegeWrapper)obj;
            return this.privilgeName.equals(privilege.getName());
        }
        return false;
    }

    @Override
    public int compareTo(PrivilegeWrapper privilege) {
        return this.privilgeName.compareTo(privilege.getName());
    }
}

