/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.IApplicationConfiguration;

public class BuildErrorChecker {
    private static Logger logger = LoggerFactory.getLogger(BuildErrorChecker.class);

    public static IApplicationConfiguration getOSPConfiguration(IProject project) {
        assert (project != null);
        return (IApplicationConfiguration)project.getAdapter(IApplicationConfiguration.class);
    }

    public static IProject[] getReferencedProject(IProject project) {
        IProjectDescription description = null;
        try {
            if (project != null) {
                description = project.getDescription();
            }
        }
        catch (CoreException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return description != null ? description.getReferencedProjects() : new IProject[]{};
    }

    public static String getBuildArchitecture(IProject project) {
        IApplicationConfiguration adapter = BuildErrorChecker.getOSPConfiguration(project);
        return adapter != null ? adapter.getBuildArchitecture() : null;
    }
}

