/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.InstallProfileConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.PluginUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.web.config.schema.model.ObjectFactory;
import org.tizen.web.config.schema.model.Widget;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.ObjectFactoryEx;
import org.tizen.web.editor.configuration.TizenConfiguratorImpl;

public class ConfiguratorFactory {
    protected static final Logger logger = LoggerFactory.getLogger(ConfiguratorFactory.class);
    public static final String CUSTOM_XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String EMPTY_CONTENT = "\n    ";
    public static final String SCHEMA_FILE_PATH = String.valueOf(File.separator) + "schemas" + File.separator;
    public static final String DEFAULT_SCHEMA_FILE_NAME = "widgets.xsd";
    static JAXBContext jaxbContext = null;
    static NamespacePrefixMapper mapper;
    static ObjectFactory objFactory;

    static {
        try {
            jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
        }
        catch (JAXBException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        mapper = new NamespacePrefixMapper(){

            public String[] getContextualNamespaceDecls() {
                return new String[]{"its", "http://www.w3.org/2005/11/its"};
            }

            public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
                if (namespaceUri.equals("http://tizen.org/ns/widgets")) {
                    return "tizen";
                }
                return "";
            }
        };
        objFactory = new ObjectFactory();
    }

    public static Widget getWidget() {
        return objFactory.createWidget();
    }

    private ConfiguratorFactory() {
    }

    public static Widget unmarshal(InputStream is) throws ConfigurationException {
        Object object = null;
        XMLInputFactory inputFactory = null;
        XMLEventReader eventReader = null;
        try {
            try {
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                unmarshaller.setProperty("com.sun.xml.bind.ObjectFactory", (Object)new ObjectFactoryEx());
                inputFactory = XMLInputFactory.newInstance();
                inputFactory.setProperty("javax.xml.stream.supportDTD", false);
                inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
                eventReader = inputFactory.createFilteredReader(inputFactory.createXMLEventReader(is), new EventFilter(){

                    @Override
                    public boolean accept(XMLEvent event) {
                        return !event.isCharacters() || !((Characters)event).isWhiteSpace();
                    }
                });
                object = unmarshaller.unmarshal(eventReader);
                if (object == null) {
                    throw new ConfigurationException("Failed to unmarshal");
                }
            }
            catch (JAXBException e) {
                throw new ConfigurationException(e);
            }
            catch (XMLStreamException e) {
                throw new ConfigurationException(e);
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{eventReader});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{eventReader});
        return (Widget)object;
    }

    public static ITizenConfigurator unmarshalWidgetConfiguration(IProject project, InputStream is) throws ConfigurationException {
        return ConfiguratorFactory.unmarshalWidgetConfiguration(project, is, null);
    }

    public static ITizenConfigurator unmarshalWidgetConfiguration(IProject project, InputStream is, String path) throws ConfigurationException {
        ITizenConfigurator config = null;
        try {
            Widget configModel = ConfiguratorFactory.unmarshal(is);
            TizenProjectDescription tizenDesc = ProjectUtil.getTizenProjectDescription((IProject)project);
            if (ProjectUtil.isSupportedPlatform((TizenProjectDescription)tizenDesc)) {
                IConfigurationElement[] ces;
                String platformName = tizenDesc.getPlatformName();
                IConfigurationElement[] iConfigurationElementArray = ces = PluginUtil.getExtensionConfigurationElements((String)"org.tizen.web.editor.configuration");
                int n = ces.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement ce = iConfigurationElementArray[n2];
                    if (platformName.equalsIgnoreCase(ce.getAttribute("platform"))) {
                        if (ce.getAttribute("class") == null) break;
                        config = (ITizenConfigurator)ce.createExecutableExtension("class");
                        config.init(project, configModel, path);
                        break;
                    }
                    ++n2;
                }
            }
            if (config == null) {
                config = new TizenConfiguratorImpl();
                config.init(project, configModel);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        return config;
    }

    public static ITizenConfigurator unmarshalWidgetConfiguration(IProject project) throws ConfigurationException {
        return ConfiguratorFactory.unmarshalWidgetConfiguration(project, "config.xml");
    }

    public static ITizenConfigurator unmarshalWidgetConfiguration(IProject project, String configurationPath) throws ConfigurationException {
        Assert.isNotNull((Object)project);
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            throw new ConfigurationException(e);
        }
        if (!project.isAccessible()) {
            throw new ConfigurationException(Messages.WidgetConfigurator_Project_Error);
        }
        IFile file = project.getFile(configurationPath);
        if (!file.isAccessible()) {
            throw new ConfigurationException(Messages.WidgetConfigurator_File_Error);
        }
        ITizenConfigurator config = null;
        InputStream is = null;
        File checkSize = new File(String.valueOf(project.getLocation().toString()) + "/" + configurationPath);
        if (checkSize.length() == 0L) {
            return config;
        }
        try {
            try {
                is = file.getContents();
                Widget configModel = ConfiguratorFactory.unmarshal(is);
                TizenProjectDescription tizenDesc = ProjectUtil.getTizenProjectDescription((IProject)project);
                if (ProjectUtil.isSupportedPlatform((TizenProjectDescription)tizenDesc)) {
                    IConfigurationElement[] ces;
                    String platformName = tizenDesc.getPlatformName();
                    IConfigurationElement[] iConfigurationElementArray = ces = PluginUtil.getExtensionConfigurationElements((String)"org.tizen.web.editor.configuration");
                    int n = ces.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement ce = iConfigurationElementArray[n2];
                        if (platformName.equalsIgnoreCase(ce.getAttribute("platform"))) {
                            if (ce.getAttribute("class") == null) break;
                            config = (ITizenConfigurator)ce.createExecutableExtension("class");
                            config.init(project, configModel);
                            break;
                        }
                        ++n2;
                    }
                }
                if (config == null) {
                    config = new TizenConfiguratorImpl();
                    config.init(project, configModel);
                }
            }
            catch (CoreException e) {
                throw new ConfigurationException(e);
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{is});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{is});
        return config;
    }

    public static void marshal(Widget widget, OutputStream os, Schema schema) throws ConfigurationException {
        Marshaller marshaller = null;
        try {
            marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)mapper);
            if (schema != null) {
                marshaller.setSchema(schema);
            }
            marshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    return true;
                }
            });
            os.write(CUSTOM_XML_DECLARATION.getBytes());
            marshaller.marshal((Object)widget, os);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public static void marshalObject(IProject project, Widget widget, OutputStream os) throws ConfigurationException {
        ConfiguratorFactory.refineContent(widget);
        String rootSchemaFilePath = null;
        String platformPath = null;
        String platformName = null;
        TizenProjectDescription tizenDesc = ProjectUtil.getTizenProjectDescription((IProject)project);
        if (!ProjectUtil.isSupportedPlatform((TizenProjectDescription)tizenDesc)) {
            if (InstallPathConfig.getProfileInfos().isEmpty()) {
                throw new ConfigurationException("Failed to find the platform information");
            }
            ProfileInfo latestProfileInfo = InstallPathConfig.getLatestProfileInfo();
            if (latestProfileInfo == null) {
                throw new ConfigurationException("Failed to find the platform information");
            }
            platformName = latestProfileInfo.getLatestPlatformName();
            platformPath = latestProfileInfo.getLatestPlatformPath();
        } else {
            platformName = tizenDesc.getPlatformName();
            platformPath = tizenDesc.getPlatformInfo().getPlatformPath(tizenDesc.getVersion());
        }
        ProfileInfo checkProfile = InstallProfileConfig.getProfileInfoToProfile((String)tizenDesc.getProfileName());
        if (checkProfile.isCustomProfile()) {
            rootSchemaFilePath = String.valueOf(platformPath) + SCHEMA_FILE_PATH + DEFAULT_SCHEMA_FILE_NAME;
        } else {
            IConfigurationElement[] ces;
            IConfigurationElement[] iConfigurationElementArray = ces = PluginUtil.getExtensionConfigurationElements((String)"org.tizen.web.editor.configuration");
            int n = ces.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                if (platformName.equalsIgnoreCase(ce.getAttribute("platform"))) {
                    rootSchemaFilePath = String.valueOf(platformPath) + SCHEMA_FILE_PATH + ce.getAttribute("schema");
                    break;
                }
                ++n2;
            }
        }
        if (rootSchemaFilePath == null) {
            throw new ConfigurationException("Failed to load " + platformName + " schema model.");
        }
        URL url = null;
        try {
            url = new URL("file:///" + rootSchemaFilePath);
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf.newSchema(url);
            ConfiguratorFactory.marshal(widget, os, schema);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public static void refineContent(Widget widget) {
        List widgetContents = widget.getContent();
        ArrayList emptyContents = new ArrayList();
        for (Object content : widgetContents) {
            if (!EMPTY_CONTENT.equals(content)) continue;
            emptyContents.add(content);
        }
        widgetContents.removeAll(emptyContents);
        Collections.sort(widgetContents, new Comparator<Object>(){

            @Override
            public int compare(Object element1, Object element2) {
                return element1.getClass().getSimpleName().compareTo(element2.getClass().getSimpleName());
            }
        });
    }
}

