/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.widl.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.CollectionMap;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.config.schema.model.Privilege;
import org.tizen.web.config.schema.model.Widget;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.widl.util.WidgetUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PrivilegeUtil {
    protected static final Logger logger = LoggerFactory.getLogger(PrivilegeUtil.class);
    protected static CollectionMap<String, Document> CACHED_WIDLPROCXML = new CollectionMap();
    public static final String PRIVILEGE_EXCLUEDED_PATTERN_SEP = "[,{ }]+";
    public static final String TIZEN_WIDLPROCXML_DIR = "widlprocxmls";
    public static final String PRODUCT_WIDLPROCXML_FILE_NAME = "product.widlprocxml";
    public static final String TIZEN_WIDLPROCXML_FILE_NAME = "tizen.widlprocxml";

    public static Collection<Document> getWidlProcXmls(IProject project) {
        ArrayList<Document> xmls = new ArrayList<Document>();
        TizenProjectDescription tizenDesc = ProjectUtil.getTizenProjectDescription((IProject)project);
        if (!ProjectUtil.isSupportedPlatform((TizenProjectDescription)tizenDesc)) {
            return xmls;
        }
        String platformName = tizenDesc.getPlatformName();
        Collection widlProcXml = CACHED_WIDLPROCXML.get((Object)platformName);
        if (widlProcXml != null) {
            logger.debug("Get cached widlprocxml : {}", (Object)platformName);
            return widlProcXml;
        }
        try {
            List<File> list = PrivilegeUtil.getWidlProcXmlFiles(tizenDesc);
            for (File file : list) {
                FileInputStream input = null;
                try {
                    try {
                        input = new FileInputStream(file);
                        Document widlDoc = PrivilegeUtil.getWidlProcXml(input);
                        xmls.add(widlDoc);
                        logger.debug("Put widlprocxml : {}", (Object)platformName);
                        CACHED_WIDLPROCXML.put((Object)platformName, (Object)widlDoc);
                    }
                    catch (DocumentException e) {
                        logger.error(e.getLocalizedMessage(), (Throwable)e);
                        IOUtil.tryClose((Object[])new Object[]{input});
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{input});
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{input});
            }
        }
        catch (FileNotFoundException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return xmls;
    }

    private static List<File> getWidlProcXmlFiles(TizenProjectDescription tizenDesc) {
        String widlProcDir;
        File tizenWidlFile;
        ArrayList<File> list = new ArrayList<File>();
        String profilePlatformPath = null;
        if (tizenDesc.getPlatformInfo().isProduct()) {
            ProfileInfo profile;
            String parentPlatformName = tizenDesc.getPlatformInfo().getParentProfile();
            String productPlatformPath = tizenDesc.getPlatformInfo().getPlatformPath(tizenDesc.getVersion());
            String widlProcDir2 = FileUtil.appendPath((String)productPlatformPath, (String)TIZEN_WIDLPROCXML_DIR);
            File productWidlFile = new File(FileUtil.appendPath((String)widlProcDir2, (String)PRODUCT_WIDLPROCXML_FILE_NAME));
            if (productWidlFile.exists()) {
                list.add(productWidlFile);
            }
            if ((profile = InstallPathConfig.getProfileInfo((String)parentPlatformName)) != null) {
                profilePlatformPath = profile.getPlatformPath(tizenDesc.getVersion());
            }
        } else {
            profilePlatformPath = tizenDesc.getPlatformInfo().getPlatformPath(tizenDesc.getVersion());
        }
        if ((tizenWidlFile = new File(FileUtil.appendPath((String)(widlProcDir = FileUtil.appendPath((String)profilePlatformPath, (String)TIZEN_WIDLPROCXML_DIR)), (String)TIZEN_WIDLPROCXML_FILE_NAME))).exists()) {
            list.add(tizenWidlFile);
        }
        return list;
    }

    private static Document getWidlProcXml(InputStream input) throws DocumentException {
        SAXReader reader = new SAXReader();
        reader.setValidation(false);
        reader.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        return reader.read(input);
    }

    public static HashSet<String> getPrivilegesFromConfig(IProject project) {
        HashSet<String> configPrivileges;
        block9: {
            if (project == null) {
                return null;
            }
            configPrivileges = new HashSet<String>();
            InputStream is = null;
            try {
                IFile file = project.getFile("config.xml");
                if (!file.isAccessible()) {
                    throw new ConfigurationException(Messages.WidgetConfigurator_File_Error);
                }
                is = file.getContents();
                Widget widget = ConfiguratorFactory.unmarshal(is);
                List<Privilege> privileges = WidgetUtil.getPrivileges(widget);
                for (Privilege privilegeElement : privileges) {
                    configPrivileges.add(privilegeElement.getName());
                }
            }
            catch (ConfigurationException e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
                IOUtil.tryClose((Object[])new Object[]{is});
                break block9;
            }
            catch (CoreException e) {
                try {
                    logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{is});
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{is});
                break block9;
            }
            IOUtil.tryClose((Object[])new Object[]{is});
        }
        return configPrivileges;
    }
}

