/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.service.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.dialog.LocaleDialog;
import org.tizen.common.ui.widget.ImageButton;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.ValidationUtil;
import org.tizen.web.common.WebConstant;
import org.tizen.web.common.core.WebProjectUtil;
import org.tizen.web.config.schema.model.Category;
import org.tizen.web.config.schema.model.DataBoolean;
import org.tizen.web.config.schema.model.Metadata;
import org.tizen.web.config.schema.model.Service;
import org.tizen.web.config.schema.model.TizenContent;
import org.tizen.web.config.schema.model.TizenDescription;
import org.tizen.web.config.schema.model.TizenName;
import org.tizen.web.config.schema.model.TizenServiceIcon;
import org.tizen.web.editor.configuration.IMobileConfigurator;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.page.EditorFormToolkit;
import org.tizen.web.editor.configuration.support.AbstractChangeListener;
import org.tizen.web.editor.configuration.tizen.metadata.MetadataEditingSupport;
import org.tizen.web.editor.configuration.tizen.service.support.ServiceCategoryContentProvider;
import org.tizen.web.editor.configuration.tizen.service.support.ServiceCategoryEditingSupport;
import org.tizen.web.editor.configuration.tizen.service.support.ServiceCategoryLabelProvider;
import org.tizen.web.editor.configuration.tizen.service.support.ServiceDescriptionContentProvider;
import org.tizen.web.editor.configuration.tizen.service.support.ServiceDescriptionLabelProvider;
import org.tizen.web.editor.configuration.tizen.service.support.ServiceMetadataContentProvider;
import org.tizen.web.editor.configuration.tizen.service.support.ServiceMetadataLabelProvider;
import org.tizen.web.editor.configuration.tizen.service.support.ServiceNameContentProvider;
import org.tizen.web.editor.configuration.tizen.service.support.ServiceNameLabelProvider;

public class AddServicePage
extends WizardPage {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ITizenConfigurator configurator;
    private Service service;
    private Boolean bEditMode;
    private EditorFormToolkit editorToolkit;
    private Text serviceIdText;
    private Combo onBootCombo;
    private Combo autoRestartCombo;
    private Text contentText;
    private Text iconText;
    private TableViewer nameViewer;
    private ImageButton nameAddBtn;
    private ImageButton nameRemoveBtn;
    private SelectionListener nameAddBtnSelectionListener;
    private SelectionListener nameRemoveBtnSelectionListener;
    private ISelectionChangedListener nameViewerSelectionChangedListener;
    private IDoubleClickListener nameViewerDoubleClickListener;
    private List<TizenName> internalNames;
    private TableViewer descriptionViewer;
    private ImageButton descriptionAddBtn;
    private ImageButton descriptionRemoveBtn;
    private SelectionListener descriptionAddBtnSelectionListener;
    private SelectionListener descriptionRemoveBtnSelectionListener;
    private ISelectionChangedListener descriptionViewerSelectionChangedListener;
    private IDoubleClickListener descriptionViewerDoubleClickListener;
    private List<TizenDescription> internalDescriptions;
    private TableViewer metadataViewer;
    private MetadataEditingSupport metadataKeyEditingSupport;
    private MetadataEditingSupport metadataValueEditingSupport;
    private ImageButton metadataAddBtn;
    private ImageButton metadataRemoveBtn;
    private SelectionListener metadataAddBtnSelectionListener;
    private SelectionListener metadataRemoveBtnSelectionListener;
    private ISelectionChangedListener metadataViewerSelectionChangedListener;
    private List<Metadata> internalMetadatas;
    private TableViewer categoryViewer;
    private ServiceCategoryEditingSupport categoryEditingSupport;
    private ImageButton categoryAddBtn;
    private ImageButton categoryRemoveBtn;
    private List<Category> internalCategories;
    private SelectionListener categoryAddBtnSelectionListener;
    private SelectionListener categoryRemoveBtnSelectionListener;
    private ISelectionChangedListener categoryViewerSelectionChangedListener;
    private ModifyListener modifyListener;
    private SelectionListener selectionListener;
    private AbstractChangeListener changeListener;

    protected AddServicePage(String pageName, ITizenConfigurator configurator) {
        super(pageName);
        this.setPageComplete(false);
        this.configurator = configurator;
        this.bEditMode = false;
    }

    public AddServicePage(String pageName, ITizenConfigurator configurator, Service service) {
        super(pageName);
        this.setPageComplete(false);
        this.configurator = configurator;
        this.service = service;
        this.bEditMode = true;
    }

    public void createControl(Composite parent) {
        this.editorToolkit = new EditorFormToolkit(parent.getDisplay());
        this.initializeDialogUnits((Control)parent);
        ScrolledComposite scrolledRootComposite = new ScrolledComposite(parent, 768);
        scrolledRootComposite.setExpandHorizontal(true);
        scrolledRootComposite.setExpandVertical(true);
        this.internalNames = new ArrayList<TizenName>();
        this.internalDescriptions = new ArrayList<TizenDescription>();
        this.internalMetadatas = new ArrayList<Metadata>();
        this.internalCategories = new ArrayList<Category>();
        Composite innerComposite = new Composite((Composite)scrolledRootComposite, 0);
        GridLayout grid = new GridLayout(1, false);
        grid.marginHeight = 20;
        grid.marginWidth = 20;
        grid.verticalSpacing = 10;
        innerComposite.setLayout((Layout)grid);
        innerComposite.setLayoutData((Object)new GridData(768));
        this.createAttributeControl(innerComposite);
        this.createContentControl(innerComposite);
        this.createIconControl(innerComposite);
        this.createNameControl(innerComposite);
        this.createDescControl(innerComposite);
        this.createMetaDataControl(innerComposite);
        this.createCategoryControl(innerComposite);
        if (this.bEditMode.booleanValue()) {
            this.loadServiceData();
        }
        this.validatePage();
        this.addListener();
        scrolledRootComposite.setContent((Control)innerComposite);
        scrolledRootComposite.setMinSize(innerComposite.computeSize(-1, -1));
        Dialog.applyDialogFont((Control)scrolledRootComposite);
        this.setControl((Control)scrolledRootComposite);
    }

    private void createAttributeControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout grid = new GridLayout(2, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        grid.horizontalSpacing = 30;
        grid.verticalSpacing = 10;
        container.setLayout((Layout)grid);
        container.setLayoutData((Object)new GridData(768));
        Label idLabel = new Label(container, 64);
        idLabel.setText(Messages.TizenPage_ServiceIdLabel);
        idLabel.setToolTipText(Messages.TizenPage_ServiceIdLabelTooltip);
        GridData data = new GridData(1, 2, false, false);
        data.widthHint = 105;
        idLabel.setLayoutData((Object)data);
        this.serviceIdText = new Text(container, 2048);
        this.serviceIdText.setText(String.valueOf(this.configurator.getApplicationPackage()) + "." + "Service");
        data = new GridData(4, 2, true, false);
        data.widthHint = 335;
        this.serviceIdText.setLayoutData((Object)data);
        this.onBootCombo = SWTUtil.createEnumCombo((Composite)container, (String)Messages.TizenPage_ServiceOnBootLabel, (String)Messages.TizenPage_ServiceOnBootLabelTooltip, (Enum[])DataBoolean.values(), (int)DataBoolean.FALSE.ordinal());
        this.onBootCombo.setLayoutData((Object)new GridData(4, 2, true, false));
        this.autoRestartCombo = SWTUtil.createEnumCombo((Composite)container, (String)Messages.TizenPage_ServiceAutoRestartLabel, (String)Messages.TizenPage_ServiceAutoRestartLabelTooltip, (Enum[])DataBoolean.values(), (int)DataBoolean.FALSE.ordinal());
        this.autoRestartCombo.setLayoutData((Object)new GridData(4, 2, true, false));
    }

    private void createContentControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout grid = new GridLayout(2, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        grid.horizontalSpacing = 30;
        container.setLayout((Layout)grid);
        container.setLayoutData((Object)new GridData(768));
        Label label = new Label(container, 64);
        label.setText(Messages.TizenPage_ServiceContentLabel);
        label.setToolTipText(Messages.TizenPage_ServiceContentLabelTooltip);
        GridData data = new GridData(1, 2, false, false);
        data.widthHint = 105;
        label.setLayoutData((Object)data);
        Composite contentComposite = new Composite(container, 0);
        grid = new GridLayout(2, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 10;
        contentComposite.setLayout((Layout)grid);
        data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 335;
        contentComposite.setLayoutData((Object)data);
        this.contentText = new Text(contentComposite, 2048);
        this.contentText.setLayoutData((Object)new GridData(4, 2, true, false));
        SWTUtil.createFileBrowserButton((Composite)contentComposite, (Text)this.contentText, (String[])WebConstant.JS_FILE_EXTENSIONS);
    }

    private void createIconControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout grid = new GridLayout(2, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        grid.horizontalSpacing = 30;
        container.setLayout((Layout)grid);
        container.setLayoutData((Object)new GridData(768));
        Label label = new Label(container, 64);
        label.setText(Messages.TizenPage_ServiceIconLabel);
        label.setToolTipText(Messages.TizenPage_ServiceIconLabelTooltip);
        GridData data = new GridData(1, 2, false, false);
        data.widthHint = 105;
        label.setLayoutData((Object)data);
        Composite iconComposite = new Composite(container, 0);
        grid = new GridLayout(2, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 10;
        iconComposite.setLayout((Layout)grid);
        data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 335;
        iconComposite.setLayoutData((Object)data);
        this.iconText = new Text(iconComposite, 2048);
        this.iconText.setLayoutData((Object)new GridData(4, 2, true, false));
        SWTUtil.createFileBrowserButton((Composite)iconComposite, (Text)this.iconText, (String[])WebConstant.ICON_FILTER_EXTENSIONS);
    }

    private void createNameControl(Composite parent) {
        Composite base = new Composite(parent, 64);
        GridLayout grid = new GridLayout(1, false);
        grid.marginTop = 10;
        grid.verticalSpacing = 0;
        grid.marginBottom = 0;
        grid.marginWidth = 0;
        base.setLayout((Layout)grid);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        base.setLayoutData((Object)data);
        Composite btnComposite = new Composite(base, 0);
        grid = new GridLayout(2, false);
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 0;
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        btnComposite.setLayout((Layout)grid);
        btnComposite.setLayoutData((Object)new GridData(768));
        Label label = new Label(btnComposite, 64);
        label.setText(Messages.TizenPage_ServiceNameLabel);
        label.setToolTipText(Messages.TizenPage_ServiceNameLabelTooltip);
        data = new GridData(1, 1, true, false);
        label.setLayoutData((Object)data);
        Composite tableBtns = new Composite(btnComposite, 0);
        grid = new GridLayout(3, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        tableBtns.setLayout((Layout)grid);
        tableBtns.setLayoutData((Object)new GridData(128));
        this.nameAddBtn = this.editorToolkit.createAddButton(tableBtns);
        this.nameRemoveBtn = this.editorToolkit.createRemoveButton(tableBtns);
        this.nameRemoveBtn.setEnabled(false);
        this.nameViewer = new TableViewer(base, 68354);
        Table nameTable = this.nameViewer.getTable();
        nameTable.setHeaderVisible(true);
        nameTable.setLinesVisible(true);
        data = new GridData(1808);
        data.heightHint = 99;
        nameTable.setLayoutData((Object)data);
        TableViewerColumn nameLangColumn = new TableViewerColumn(this.nameViewer, 0);
        nameLangColumn.getColumn().setText(Messages.ATTRIBUTE_XML_LANG);
        nameLangColumn.getColumn().setToolTipText(Messages.ATTRIBUTE_XML_LANG_TOOLTIP);
        TableViewerColumn nameColumn = new TableViewerColumn(this.nameViewer, 0);
        nameColumn.getColumn().setText(Messages.TizenPage_ServiceNameLabel);
        nameColumn.getColumn().setToolTipText(Messages.TizenPage_ServiceNameLabel);
        TableLayout nameTableLayout = new TableLayout();
        nameTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2));
        nameTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(7));
        this.nameViewer.getTable().setLayout((Layout)nameTableLayout);
        ServiceNameContentProvider nameContentProvider = new ServiceNameContentProvider();
        ServiceNameLabelProvider nameLabelProvider = new ServiceNameLabelProvider();
        this.nameViewer.setContentProvider((IContentProvider)nameContentProvider);
        this.nameViewer.setLabelProvider((IBaseLabelProvider)nameLabelProvider);
    }

    private void createDescControl(Composite parent) {
        Composite base = new Composite(parent, 64);
        GridLayout grid = new GridLayout(1, false);
        grid.marginTop = 10;
        grid.verticalSpacing = 0;
        grid.marginBottom = 0;
        grid.marginWidth = 0;
        base.setLayout((Layout)grid);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        base.setLayoutData((Object)data);
        Composite btnComposite = new Composite(base, 0);
        grid = new GridLayout(2, false);
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 0;
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        btnComposite.setLayout((Layout)grid);
        btnComposite.setLayoutData((Object)new GridData(768));
        Label label = new Label(btnComposite, 64);
        label.setText(Messages.TizenPage_ServiceDescriptionLabel);
        label.setToolTipText(Messages.TizenPage_ServiceDescriptionLabelTooltip);
        data = new GridData(1, 1, true, false);
        label.setLayoutData((Object)data);
        Composite tableBtns = new Composite(btnComposite, 0);
        grid = new GridLayout(3, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        tableBtns.setLayout((Layout)grid);
        tableBtns.setLayoutData((Object)new GridData(128));
        this.descriptionAddBtn = this.editorToolkit.createAddButton(tableBtns);
        this.descriptionRemoveBtn = this.editorToolkit.createRemoveButton(tableBtns);
        this.descriptionRemoveBtn.setEnabled(false);
        this.descriptionViewer = new TableViewer(base, 68354);
        Table descriptiontaTable = this.descriptionViewer.getTable();
        descriptiontaTable.setHeaderVisible(true);
        descriptiontaTable.setLinesVisible(true);
        data = new GridData(1808);
        data.heightHint = 99;
        descriptiontaTable.setLayoutData((Object)data);
        TableViewerColumn descriptionLangColumn = new TableViewerColumn(this.descriptionViewer, 0);
        descriptionLangColumn.getColumn().setText(Messages.ATTRIBUTE_XML_LANG);
        descriptionLangColumn.getColumn().setToolTipText(Messages.ATTRIBUTE_XML_LANG_TOOLTIP);
        TableViewerColumn descriptionColumn = new TableViewerColumn(this.descriptionViewer, 0);
        descriptionColumn.getColumn().setText(Messages.TizenPage_ServiceDescriptionLabel);
        descriptionColumn.getColumn().setToolTipText(Messages.TizenPage_ServiceDescriptionLabel);
        TableLayout descriptionTableLayout = new TableLayout();
        descriptionTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2));
        descriptionTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(7));
        this.descriptionViewer.getTable().setLayout((Layout)descriptionTableLayout);
        ServiceDescriptionContentProvider descriptionContentProvider = new ServiceDescriptionContentProvider();
        ServiceDescriptionLabelProvider descriptionTableLabelProvider = new ServiceDescriptionLabelProvider();
        this.descriptionViewer.setContentProvider((IContentProvider)descriptionContentProvider);
        this.descriptionViewer.setLabelProvider((IBaseLabelProvider)descriptionTableLabelProvider);
    }

    private void createMetaDataControl(Composite parent) {
        Composite base = new Composite(parent, 64);
        GridLayout grid = new GridLayout(1, false);
        grid.marginTop = 10;
        grid.verticalSpacing = 0;
        grid.marginBottom = 0;
        grid.marginWidth = 0;
        base.setLayout((Layout)grid);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        base.setLayoutData((Object)data);
        Composite btnComposite = new Composite(base, 0);
        grid = new GridLayout(2, false);
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 0;
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        btnComposite.setLayout((Layout)grid);
        btnComposite.setLayoutData((Object)new GridData(768));
        Label label = new Label(btnComposite, 64);
        label.setText(Messages.TizenPage_ServiceMetadataLabel);
        label.setToolTipText(Messages.TizenPage_ServiceMetadataLabelTooltip);
        data = new GridData(1, 1, true, false);
        label.setLayoutData((Object)data);
        Composite tableBtns = new Composite(btnComposite, 0);
        grid = new GridLayout(3, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        tableBtns.setLayout((Layout)grid);
        tableBtns.setLayoutData((Object)new GridData(128));
        this.metadataAddBtn = this.editorToolkit.createAddButton(tableBtns);
        this.metadataRemoveBtn = this.editorToolkit.createRemoveButton(tableBtns);
        this.metadataRemoveBtn.setEnabled(false);
        this.metadataViewer = new TableViewer(base, 68354);
        Table metadataTable = this.metadataViewer.getTable();
        metadataTable.setHeaderVisible(true);
        metadataTable.setLinesVisible(true);
        data = new GridData(1808);
        data.heightHint = 99;
        metadataTable.setLayoutData((Object)data);
        TableViewerColumn metadataKeyColumn = new TableViewerColumn(this.metadataViewer, 0);
        metadataKeyColumn.getColumn().setText(Messages.TizenPage_Metadata_KeyLabel);
        metadataKeyColumn.getColumn().setToolTipText(Messages.TizenPage_Metadata_KeyTooltip);
        this.metadataKeyEditingSupport = new MetadataEditingSupport((ColumnViewer)this.metadataViewer, 0);
        metadataKeyColumn.setEditingSupport((EditingSupport)this.metadataKeyEditingSupport);
        TableViewerColumn metadataValueColumn = new TableViewerColumn(this.metadataViewer, 0);
        metadataValueColumn.getColumn().setText(Messages.TizenPage_Metadata_ValueLabel);
        metadataValueColumn.getColumn().setToolTipText(Messages.TizenPage_Metadata_ValueTooltip);
        this.metadataValueEditingSupport = new MetadataEditingSupport((ColumnViewer)this.metadataViewer, 1);
        metadataValueColumn.setEditingSupport((EditingSupport)this.metadataValueEditingSupport);
        TableLayout metadataTableLayout = new TableLayout();
        metadataTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        metadataTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        this.metadataViewer.getTable().setLayout((Layout)metadataTableLayout);
        ServiceMetadataContentProvider metadataContentProvider = new ServiceMetadataContentProvider();
        ServiceMetadataLabelProvider metadataTableLabelProvider = new ServiceMetadataLabelProvider();
        this.metadataViewer.setContentProvider((IContentProvider)metadataContentProvider);
        this.metadataViewer.setLabelProvider((IBaseLabelProvider)metadataTableLabelProvider);
    }

    private void createCategoryControl(Composite parent) {
        Composite base = new Composite(parent, 64);
        GridLayout grid = new GridLayout(1, false);
        grid.marginTop = 10;
        grid.verticalSpacing = 0;
        grid.marginBottom = 0;
        grid.marginWidth = 0;
        base.setLayout((Layout)grid);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        base.setLayoutData((Object)data);
        Composite btnComposite = new Composite(base, 0);
        grid = new GridLayout(2, false);
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 0;
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        btnComposite.setLayout((Layout)grid);
        btnComposite.setLayoutData((Object)new GridData(768));
        Label label = new Label(btnComposite, 64);
        label.setText(Messages.TizenPage_ServiceCategoryLabel);
        label.setToolTipText(Messages.TizenPage_ServiceCategoryLabelTooltip);
        data = new GridData(1, 1, true, false);
        label.setLayoutData((Object)data);
        Composite tableBtns = new Composite(btnComposite, 0);
        grid = new GridLayout(3, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        tableBtns.setLayout((Layout)grid);
        tableBtns.setLayoutData((Object)new GridData(128));
        this.categoryAddBtn = this.editorToolkit.createAddButton(tableBtns);
        this.categoryRemoveBtn = this.editorToolkit.createRemoveButton(tableBtns);
        this.categoryRemoveBtn.setEnabled(false);
        this.categoryViewer = new TableViewer(base, 68354);
        Table categoryTable = this.categoryViewer.getTable();
        categoryTable.setHeaderVisible(true);
        categoryTable.setLinesVisible(true);
        data = new GridData(1808);
        data.heightHint = 99;
        categoryTable.setLayoutData((Object)data);
        TableViewerColumn categoryColumn = new TableViewerColumn(this.categoryViewer, 0);
        categoryColumn.getColumn().setText(Messages.TizenPage_ServiceCategoryLabel);
        categoryColumn.getColumn().setToolTipText(Messages.TizenPage_ServiceCategoryLabel);
        this.categoryEditingSupport = new ServiceCategoryEditingSupport((ColumnViewer)this.categoryViewer, 0);
        categoryColumn.setEditingSupport((EditingSupport)this.categoryEditingSupport);
        TableLayout categoryTableLayout = new TableLayout();
        categoryTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        this.categoryViewer.getTable().setLayout((Layout)categoryTableLayout);
        ServiceCategoryContentProvider serviceCategoryContentProvider = new ServiceCategoryContentProvider();
        ServiceCategoryLabelProvider serviceCategoryLabelProvider = new ServiceCategoryLabelProvider();
        this.categoryViewer.setContentProvider((IContentProvider)serviceCategoryContentProvider);
        this.categoryViewer.setLabelProvider((IBaseLabelProvider)serviceCategoryLabelProvider);
    }

    private void loadServiceData() {
        this.serviceIdText.setText(this.service.getId());
        if (!this.service.getIcon().isEmpty()) {
            this.iconText.setText(((TizenServiceIcon)this.service.getIcon().get(0)).getSrc());
        }
        if (this.service.getAutoRestart() != null) {
            int autoRestartIndex = this.service.getAutoRestart().ordinal();
            this.autoRestartCombo.select(autoRestartIndex);
        }
        if (this.service.getOnBoot() != null) {
            int onBootIndex = this.service.getOnBoot().ordinal();
            this.onBootCombo.select(onBootIndex);
        }
        if (this.service.getContent() != null) {
            this.contentText.setText(this.service.getContent().getSrc());
        }
        for (Object obj : this.service.getCategory()) {
            this.internalCategories.add((Category)obj);
        }
        for (Object obj : this.service.getMetadata()) {
            this.internalMetadatas.add((Metadata)obj);
        }
        for (Object obj : this.service.getDescription()) {
            TizenDescription description = (TizenDescription)obj;
            if (description.getLang() == null) {
                description.setLang("");
            }
            this.internalDescriptions.add(description);
        }
        for (Object obj : this.service.getName()) {
            TizenName name = (TizenName)obj;
            if (name.getLang() == null) {
                name.setLang("");
            }
            this.internalNames.add(name);
        }
        this.categoryViewer.setInput(this.internalCategories);
        this.categoryViewer.refresh();
        this.categoryViewer.getTable().setEnabled(true);
        this.metadataViewer.setInput(this.internalMetadatas);
        this.metadataViewer.refresh();
        this.metadataViewer.getTable().setEnabled(true);
        this.descriptionViewer.setInput(this.internalDescriptions);
        this.descriptionViewer.refresh();
        this.descriptionViewer.getTable().setEnabled(true);
        this.nameViewer.setInput(this.internalNames);
        this.nameViewer.refresh();
        this.nameViewer.getTable().setEnabled(true);
    }

    private void createListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddServicePage.this.validatePage();
                }
            };
        }
        if (this.changeListener == null) {
            this.changeListener = new AbstractChangeListener(){

                @Override
                public void notifyChange() {
                    AddServicePage.this.validatePage();
                }
            };
        }
        if (this.selectionListener == null) {
            this.selectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    AddServicePage.this.validatePage();
                }
            };
        }
        if (this.categoryAddBtnSelectionListener == null) {
            this.categoryAddBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Category category = new Category();
                    category.setName("");
                    AddServicePage.this.categoryViewer.add((Object)category);
                }
            };
            this.categoryAddBtn.addSelectionListener(this.categoryAddBtnSelectionListener);
        }
        if (this.categoryRemoveBtnSelectionListener == null) {
            this.categoryRemoveBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = AddServicePage.this.categoryViewer.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        for (Object object : (IStructuredSelection)selection) {
                            if (!(object instanceof Category)) continue;
                            AddServicePage.this.categoryViewer.remove(object);
                            AddServicePage.this.validatePage();
                        }
                    }
                }
            };
            this.categoryRemoveBtn.addSelectionListener(this.categoryRemoveBtnSelectionListener);
        }
        if (this.categoryViewerSelectionChangedListener == null) {
            this.categoryViewerSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!selection.isEmpty()) {
                        AddServicePage.this.categoryRemoveBtn.setEnabled(true);
                    } else {
                        AddServicePage.this.categoryRemoveBtn.setEnabled(false);
                    }
                }
            };
        }
        if (this.nameAddBtnSelectionListener == null) {
            this.nameAddBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    HashMap<String, String> locales = new HashMap<String, String>();
                    for (TizenName name : AddServicePage.this.internalNames) {
                        locales.put(name.getLang(), name.getContent());
                    }
                    LocaleDialog dlg = new LocaleDialog(SWTUtil.getActiveShell(), "Name", locales);
                    if (dlg.open() == 0) {
                        TizenName name = new TizenName();
                        name.setLang(dlg.getLang());
                        name.setContent(dlg.getContent());
                        AddServicePage.this.internalNames.add(name);
                        AddServicePage.this.nameViewer.add((Object)name);
                        AddServicePage.this.validatePage();
                    }
                    if (AddServicePage.this.internalNames.size() == LocaleDialog.getDefaultLangLength()) {
                        AddServicePage.this.nameAddBtn.setEnabled(false);
                    }
                }
            };
            this.nameAddBtn.addSelectionListener(this.nameAddBtnSelectionListener);
        }
        if (this.nameRemoveBtnSelectionListener == null) {
            this.nameRemoveBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = AddServicePage.this.nameViewer.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        for (Object object : (IStructuredSelection)selection) {
                            if (!(object instanceof TizenName)) continue;
                            TizenName name = (TizenName)object;
                            AddServicePage.this.internalNames.remove(name);
                            AddServicePage.this.nameViewer.remove((Object)name);
                            AddServicePage.this.validatePage();
                            if (AddServicePage.this.nameAddBtn.isEnabled()) continue;
                            AddServicePage.this.nameAddBtn.setEnabled(true);
                        }
                    }
                }
            };
            this.nameRemoveBtn.addSelectionListener(this.nameRemoveBtnSelectionListener);
        }
        if (this.nameViewerDoubleClickListener == null) {
            this.nameViewerDoubleClickListener = new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)AddServicePage.this.nameViewer.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    TizenName selectedName = (TizenName)selection.getFirstElement();
                    HashMap<String, String> locales = new HashMap<String, String>();
                    for (TizenName name : AddServicePage.this.internalNames) {
                        locales.put(name.getLang(), name.getContent());
                    }
                    LocaleDialog dlg = new LocaleDialog(SWTUtil.getActiveShell(), "Name", locales);
                    dlg.editLang(selectedName.getLang(), selectedName.getContent());
                    if (dlg.open() == 0) {
                        selectedName.setLang(dlg.getLang());
                        selectedName.setContent(dlg.getContent());
                        AddServicePage.this.nameViewer.update((Object)selectedName, null);
                        AddServicePage.this.validatePage();
                    }
                }
            };
        }
        if (this.nameViewerSelectionChangedListener == null) {
            this.nameViewerSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!selection.isEmpty()) {
                        AddServicePage.this.nameRemoveBtn.setEnabled(true);
                    } else {
                        AddServicePage.this.nameRemoveBtn.setEnabled(false);
                    }
                }
            };
        }
        if (this.descriptionAddBtnSelectionListener == null) {
            this.descriptionAddBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    HashMap<String, String> locales = new HashMap<String, String>();
                    for (TizenDescription description : AddServicePage.this.internalDescriptions) {
                        locales.put(description.getLang(), description.getContent());
                    }
                    LocaleDialog dlg = new LocaleDialog(SWTUtil.getActiveShell(), "Description", locales);
                    if (dlg.open() == 0) {
                        TizenDescription description = new TizenDescription();
                        description.setLang(dlg.getLang());
                        description.setContent(dlg.getContent());
                        AddServicePage.this.descriptionViewer.add((Object)description);
                        AddServicePage.this.internalDescriptions.add(description);
                        AddServicePage.this.validatePage();
                    }
                    if (AddServicePage.this.internalDescriptions.size() == LocaleDialog.getDefaultLangLength()) {
                        AddServicePage.this.descriptionAddBtn.setEnabled(false);
                    }
                }
            };
            this.descriptionAddBtn.addSelectionListener(this.descriptionAddBtnSelectionListener);
        }
        if (this.descriptionRemoveBtnSelectionListener == null) {
            this.descriptionRemoveBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = AddServicePage.this.descriptionViewer.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        for (Object object : (IStructuredSelection)selection) {
                            if (!(object instanceof TizenDescription)) continue;
                            TizenDescription description = (TizenDescription)object;
                            AddServicePage.this.descriptionViewer.remove((Object)description);
                            AddServicePage.this.internalDescriptions.remove(description);
                            AddServicePage.this.validatePage();
                            if (AddServicePage.this.descriptionAddBtn.isEnabled()) continue;
                            AddServicePage.this.descriptionAddBtn.setEnabled(true);
                        }
                    }
                }
            };
            this.descriptionRemoveBtn.addSelectionListener(this.descriptionRemoveBtnSelectionListener);
        }
        if (this.descriptionViewerDoubleClickListener == null) {
            this.descriptionViewerDoubleClickListener = new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)AddServicePage.this.descriptionViewer.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    TizenDescription selectedDescription = (TizenDescription)selection.getFirstElement();
                    HashMap<String, String> locales = new HashMap<String, String>();
                    for (TizenDescription description : AddServicePage.this.internalDescriptions) {
                        locales.put(description.getLang(), description.getContent());
                    }
                    LocaleDialog dlg = new LocaleDialog(SWTUtil.getActiveShell(), "Description", locales);
                    dlg.editLang(selectedDescription.getLang(), selectedDescription.getContent());
                    if (dlg.open() == 0) {
                        selectedDescription.setLang(dlg.getLang());
                        selectedDescription.setContent(dlg.getContent());
                        AddServicePage.this.descriptionViewer.update((Object)selectedDescription, null);
                        AddServicePage.this.validatePage();
                    }
                }
            };
        }
        if (this.descriptionViewerSelectionChangedListener == null) {
            this.descriptionViewerSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!selection.isEmpty()) {
                        AddServicePage.this.descriptionRemoveBtn.setEnabled(true);
                    } else {
                        AddServicePage.this.descriptionRemoveBtn.setEnabled(false);
                    }
                }
            };
        }
        if (this.metadataAddBtnSelectionListener == null) {
            this.metadataAddBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Metadata metadata = new Metadata();
                    metadata.setKey("");
                    metadata.setValue("");
                    AddServicePage.this.metadataViewer.add((Object)metadata);
                }
            };
            this.metadataAddBtn.addSelectionListener(this.metadataAddBtnSelectionListener);
        }
        if (this.metadataRemoveBtnSelectionListener == null) {
            this.metadataRemoveBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = AddServicePage.this.metadataViewer.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        for (Object object : (IStructuredSelection)selection) {
                            if (!(object instanceof Metadata)) continue;
                            AddServicePage.this.metadataViewer.remove(object);
                            AddServicePage.this.validatePage();
                        }
                    }
                }
            };
            this.metadataRemoveBtn.addSelectionListener(this.metadataRemoveBtnSelectionListener);
        }
        if (this.metadataViewerSelectionChangedListener == null) {
            this.metadataViewerSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!selection.isEmpty()) {
                        AddServicePage.this.metadataRemoveBtn.setEnabled(true);
                    } else {
                        AddServicePage.this.metadataRemoveBtn.setEnabled(false);
                    }
                }
            };
        }
    }

    private void addListener() {
        this.createListener();
        if (this.modifyListener != null) {
            this.serviceIdText.addModifyListener(this.modifyListener);
            this.contentText.addModifyListener(this.modifyListener);
            this.iconText.addModifyListener(this.modifyListener);
        }
        if (this.changeListener != null) {
            this.metadataKeyEditingSupport.setListener(this.changeListener);
            this.metadataValueEditingSupport.setListener(this.changeListener);
            this.categoryEditingSupport.setListener(this.changeListener);
        }
        if (this.selectionListener != null) {
            this.onBootCombo.addSelectionListener(this.selectionListener);
            this.autoRestartCombo.addSelectionListener(this.selectionListener);
        }
        if (this.categoryViewerSelectionChangedListener != null) {
            this.categoryViewer.addSelectionChangedListener(this.categoryViewerSelectionChangedListener);
        }
        if (this.nameViewerSelectionChangedListener != null) {
            this.nameViewer.addSelectionChangedListener(this.nameViewerSelectionChangedListener);
        }
        if (this.nameViewerDoubleClickListener != null) {
            this.nameViewer.addDoubleClickListener(this.nameViewerDoubleClickListener);
        }
        if (this.descriptionViewerSelectionChangedListener != null) {
            this.descriptionViewer.addSelectionChangedListener(this.descriptionViewerSelectionChangedListener);
        }
        if (this.descriptionViewerDoubleClickListener != null) {
            this.descriptionViewer.addDoubleClickListener(this.descriptionViewerDoubleClickListener);
        }
        if (this.metadataViewerSelectionChangedListener != null) {
            this.metadataViewer.addSelectionChangedListener(this.metadataViewerSelectionChangedListener);
        }
    }

    protected void validatePage() {
        boolean canFinish = false;
        String message = null;
        String serviceId = this.serviceIdText.getText();
        String contentSrc = this.contentText.getText();
        String serviceIcon = this.iconText.getText();
        if (StringUtil.isEmpty((CharSequence)serviceId) || !ValidationUtil.checkForServiceId((String)serviceId)) {
            message = Messages.AddServicePage_ServiceIdErrorMessage;
        } else if (!StringUtil.isEmpty((CharSequence)serviceId) && this.isContainAppID(((IMobileConfigurator)this.configurator).getServices(), serviceId)) {
            message = Messages.AddServicePage_ServiceIdDuplicationErrorMessage;
        } else if (!ValidationUtil.checkForServiceContentFileExtension((String)contentSrc) || !WebProjectUtil.isFileInTheProject((IProject)this.configurator.getProject(), (String)contentSrc)) {
            message = Messages.AddServicePage_ServiceContentErrorMessage;
        } else if (!(StringUtil.isEmpty((CharSequence)serviceIcon) || WebProjectUtil.isFileInTheProject((IProject)this.configurator.getProject(), (String)serviceIcon) && ValidationUtil.checkForWidgetIconFileExtension((String)serviceIcon))) {
            message = Messages.AddServicePage_ServiceIconErrorMessage;
        }
        if (message == null) {
            this.createService();
            canFinish = true;
        }
        this.setErrorMessage(message);
        this.setPageComplete(canFinish);
    }

    protected void createService() {
        TableItem[] metadataItems;
        TableItem[] categoryItems;
        if (this.bEditMode.booleanValue()) {
            this.service.getCategory().clear();
            this.service.getDescription().clear();
            this.service.getName().clear();
            this.service.getMetadata().clear();
            this.service.getIcon().clear();
        } else {
            this.service = new Service();
        }
        this.service.setId(this.serviceIdText.getText());
        TizenContent content = new TizenContent();
        content.setSrc(this.contentText.getText());
        this.service.setContent(content);
        if (!StringUtil.isEmpty((CharSequence)this.iconText.getText())) {
            TizenServiceIcon icon = new TizenServiceIcon();
            icon.setSrc(this.iconText.getText());
            this.service.getIcon().add(icon);
        }
        if (this.onBootCombo.getSelectionIndex() == 0) {
            this.service.setOnBoot(DataBoolean.TRUE);
        } else {
            this.service.setOnBoot(DataBoolean.FALSE);
        }
        if (this.autoRestartCombo.getSelectionIndex() == 0) {
            this.service.setAutoRestart(DataBoolean.TRUE);
        } else {
            this.service.setAutoRestart(DataBoolean.FALSE);
        }
        for (TizenName serviceName : this.internalNames) {
            TizenName name = new TizenName();
            if (!StringUtil.isEmpty((CharSequence)serviceName.getLang())) {
                name.setLang(serviceName.getLang());
            }
            name.setContent(serviceName.getContent());
            this.service.getName().add(name);
        }
        for (TizenDescription serviceDescription : this.internalDescriptions) {
            TizenDescription description = new TizenDescription();
            if (!StringUtil.isEmpty((CharSequence)serviceDescription.getLang())) {
                description.setLang(serviceDescription.getLang());
            }
            description.setContent(serviceDescription.getContent());
            this.service.getDescription().add(description);
        }
        TableItem[] tableItemArray = categoryItems = this.categoryViewer.getTable().getItems();
        int n = categoryItems.length;
        int description = 0;
        while (description < n) {
            Category category;
            String name;
            TableItem tableItem = tableItemArray[description];
            Object data = tableItem.getData();
            if (data instanceof Category && !StringUtil.isEmpty((CharSequence)(name = (category = (Category)data).getName()))) {
                Category newCategory = new Category();
                newCategory.setName(name);
                this.service.getCategory().add(newCategory);
            }
            ++description;
        }
        TableItem[] tableItemArray2 = metadataItems = this.metadataViewer.getTable().getItems();
        int n2 = metadataItems.length;
        n = 0;
        while (n < n2) {
            TableItem tableItem = tableItemArray2[n];
            Object data = tableItem.getData();
            if (data instanceof Metadata) {
                Metadata metadata = (Metadata)data;
                String key = metadata.getKey();
                String value = metadata.getValue();
                if (!StringUtil.isEmpty((CharSequence)key)) {
                    Metadata newMetadata = new Metadata();
                    newMetadata.setKey(key);
                    newMetadata.setValue(value);
                    this.service.getMetadata().add(newMetadata);
                }
            }
            ++n;
        }
    }

    private boolean isContainAppID(List<Service> services, String appid) {
        for (Service service : services) {
            if (!appid.equals(service.getId()) || this.bEditMode.booleanValue() && appid.equals(this.service.getId())) continue;
            return true;
        }
        return false;
    }

    public Service getService() {
        return this.service;
    }

    public void dispose() {
        this.editorToolkit.dispose();
        super.dispose();
    }
}

