/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.fastdeploy;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.builder.IBuildDependency;
import org.tizen.common.builder.dependency.DependencyInMemory;
import org.tizen.common.core.application.TizenPackageInfoStore;
import org.tizen.common.fastdeploy.FastDeployer;
import org.tizen.common.file.IResource;
import org.tizen.common.rds.DeltaResourceInfo;
import org.tizen.common.rds.RdsMessages;
import org.tizen.common.sign.signer.SignatureGenerator;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.common.util.CollectionUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.web.builder.ide.manager.BuildManager;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.packager.core.PackageProcessType;
import org.tizen.web.packager.ui.ResourceManager;
import org.tizen.web.zimlaunch.fastdeploy.WebFastDeployListener;

public class WebFastDeployer
extends FastDeployer {
    private static final String EMPTY_STRING = "";
    public static String WEBAPP_SEPARATOR = "/";
    private final Logger logger = LoggerFactory.getLogger(WebFastDeployer.class);

    public WebFastDeployer(IProject project, IDevice device, ITizenConsoleManager console, String pkgType, IProgressMonitor monitor) {
        super(project, device, console, pkgType, monitor);
    }

    protected void printInfo(String message) {
        if (this.console != null) {
            this.console.println(message);
        }
    }

    protected String getAppInstallPath() {
        return String.valueOf(TizenPlatformConstants.getAppTmpDirectory((IDevice)this.device)) + "/" + this.getPkgId();
    }

    protected String getPkgId() {
        return WebFastDeployListener.getPkgId(this.project);
    }

    protected boolean sign(List<DeltaResourceInfo> deltaInfoList) throws CoreException, IOException, IllegalStateException {
        this.remakeDeltaListForSign(deltaInfoList);
        this.incrementalSign(deltaInfoList);
        return true;
    }

    private void remakeDeltaListForSign(List<DeltaResourceInfo> deltaList) {
        String remotePath = null;
        String remakeRemotePath = null;
        for (DeltaResourceInfo delta : deltaList) {
            remotePath = delta.getRemotePath();
            remakeRemotePath = remotePath.replaceFirst("res/wgt/", EMPTY_STRING);
            delta.setRemotePath(remakeRemotePath);
            List childrenDris = delta.getChildren();
            if (childrenDris.isEmpty()) continue;
            this.remakeDeltaListForSign(delta.getChildren());
        }
    }

    protected void incrementalSign(List<DeltaResourceInfo> deltaList) throws CoreException {
        File file = new File(FileUtil.appendPath((String)this.project.getLocation().toOSString(), (String)".sign"));
        file.mkdir();
        SignatureGenerator.generate((IProject)this.project, (IContainer)this.project.getFolder(".sign"), (IDevice)this.device, deltaList, (boolean)true);
    }

    protected void mergeApplicationXML() throws Exception {
    }

    public boolean isDeltaChanged(String name) {
        boolean isDeltaChanged = false;
        if (!this.hasOldResourceInfo()) {
            return isDeltaChanged;
        }
        List deltaInfoList = this.getDelta();
        if (CollectionUtil.isEmpty((Collection)deltaInfoList)) {
            return isDeltaChanged;
        }
        for (DeltaResourceInfo node : deltaInfoList) {
            if (!name.equals(node.getName()) || !"modify".equals(node.getType())) continue;
            isDeltaChanged = true;
            break;
        }
        return isDeltaChanged;
    }

    public List<DeltaResourceInfo> getInterestDelta(List<DeltaResourceInfo> deltaInfoList) throws CoreException {
        ArrayList<DeltaResourceInfo> delta = new ArrayList<DeltaResourceInfo>();
        DeltaResourceInfo interestNode = null;
        String strRemotePath = EMPTY_STRING;
        for (DeltaResourceInfo node : deltaInfoList) {
            String strProjectPath = this.project.getLocation().toString();
            String nodeProjectName = node.getProjectName();
            if (nodeProjectName != null && !this.project.getName().equals(nodeProjectName)) {
                strProjectPath = strProjectPath.replace(this.project.getName(), nodeProjectName);
            }
            interestNode = null;
            if (this.containsNode(node, this.ignoreList, strProjectPath) != null) continue;
            if (interestNode == null && "delete" == node.getType()) {
                interestNode = node;
            } else {
                interestNode = this.containsNode(node, this.interestList, strProjectPath);
                if (interestNode == null) continue;
            }
            strRemotePath = this.getRemotePathOfDelta(interestNode, strProjectPath, node);
            node.setRemotePath(strRemotePath);
            delta.add(node);
            this.getInterestDelta(node.getChildren());
        }
        return delta;
    }

    protected String getRemotePathOfDelta(DeltaResourceInfo interest, String strProjectPath, DeltaResourceInfo delta) throws CoreException {
        String installDirectoryPrefix;
        String strRemotePath = EMPTY_STRING;
        String prefix = EMPTY_STRING;
        if (interest == null || interest.getRemotePath() == null) {
            prefix = strProjectPath;
            strRemotePath = DeltaResourceInfo.convertToRemotePath((String)delta.getFullPath(), (String)prefix, (String)EMPTY_STRING);
        } else {
            File file = new File(delta.getFullPath());
            String interestRemotePath = EMPTY_STRING;
            String interestFullPath = EMPTY_STRING;
            if (this.isDirectory(interest.getFullPath())) {
                if (file.exists()) {
                    interestFullPath = interest.getFullPath();
                    interestRemotePath = interest.getRemotePath();
                } else {
                    interestFullPath = interest.getFullPath().substring(0, interest.getFullPath().length() - 1);
                    interestRemotePath = interest.getRemotePath().substring(0, interest.getRemotePath().length() - 1);
                }
            } else {
                interestFullPath = interest.getFullPath();
                interestRemotePath = interest.getRemotePath();
            }
            String rootProjectName = this.project.getName();
            String currentProjectName = delta.getProjectName();
            String deltaFullPath = delta.getFullPath();
            if (!rootProjectName.equals(currentProjectName) && !deltaFullPath.contains(".exe")) {
                strProjectPath = strProjectPath.replace(currentProjectName, rootProjectName);
                deltaFullPath = deltaFullPath.replace(currentProjectName, rootProjectName);
            }
            prefix = String.valueOf(strProjectPath) + interestFullPath;
            if (deltaFullPath.contains("manifest_multi.xml")) {
                deltaFullPath = deltaFullPath.replace("manifest_multi.xml", "manifest.xml");
            }
            strRemotePath = DeltaResourceInfo.convertToRemotePath((String)deltaFullPath, (String)prefix, (String)interestRemotePath);
        }
        if (strRemotePath == null) {
            this.logger.error(String.format("Cannot make remotePath (host: %s, prefix: %s)", delta.getFullPath(), prefix));
            this.newCoreException(FastDeployer.makeRdsLog((String)RdsMessages.CANNOT_FIND_DELTA), null);
        }
        if (2 == delta.getResourceType() && !"delete".equals(delta.getType()) && !strRemotePath.endsWith("/")) {
            strRemotePath = String.valueOf(strRemotePath) + "/";
        }
        if (!strRemotePath.startsWith(installDirectoryPrefix = "/res/wgt")) {
            strRemotePath = String.valueOf(installDirectoryPrefix) + strRemotePath;
        }
        return strRemotePath.replaceFirst("/", EMPTY_STRING);
    }

    public void init(IProject project, PackageProcessType packageType, WebFastDeployer fastDeployer) throws CoreException {
        ResourceManager resourceManager = new ResourceManager(project);
        project.accept((IResourceVisitor)resourceManager);
        BuildManager.getBuildDependency((String)project.getName(), (IBuildDependency)new DependencyInMemory());
        Collection<IResource> deltaResources = this.getDeltaResources(project, fastDeployer.getDelta());
        resourceManager.setDeltaResources(deltaResources);
        ArrayList<DeltaResourceInfo> ignoreList = new ArrayList<DeltaResourceInfo>();
        try {
            fastDeployer.setInterestList(this.makeInterestList(project, resourceManager.generatePackagingWebResources(packageType), fastDeployer));
            fastDeployer.cleanDeltaInfo();
            fastDeployer.setIgnoreList(this.makeIgnoreList(ignoreList));
        }
        catch (Exception e) {
            this.logger.error("[FastDeploy] An exception occurs during launch in FastDeploy mode.", (Throwable)e);
            return;
        }
    }

    private Collection<IResource> getDeltaResources(IProject project, List<DeltaResourceInfo> deltas) {
        HashSet<IResource> deltaResources = new HashSet<IResource>();
        if (deltas == null || deltas.isEmpty()) {
            return deltaResources;
        }
        String projectFullPath = project.getLocation().toOSString();
        Collection originResources = ResourceManager.getOriginResources((IProject)project);
        for (IResource originResource : originResources) {
            for (DeltaResourceInfo dri : deltas) {
                String relativeResourcePath = FilenameUtil.getRelativePath((String)projectFullPath, (String)dri.getFullPath());
                if (!relativeResourcePath.equals(originResource.getPath())) continue;
                deltaResources.add(originResource);
            }
        }
        return deltaResources;
    }

    public List<DeltaResourceInfo> makeInterestList(IProject project) {
        TizenPackageInfoStore store = org.tizen.common.util.ProjectUtil.getTizenProject((IProject)project).getTizenPkgInfoStore();
        return store.getInterestList();
    }

    public List<DeltaResourceInfo> makeIgnoreList(List<DeltaResourceInfo> ignoreList) {
        ignoreList.add(new DeltaResourceInfo("/.sign/.manifest.tmp"));
        return ignoreList;
    }

    protected List<DeltaResourceInfo> makeInterestList(IProject project, Collection<IResource> collection, WebFastDeployer deployer) throws CoreException {
        ArrayList<DeltaResourceInfo> interestList = new ArrayList<DeltaResourceInfo>();
        for (IResource resource : collection) {
            String localPath = WEBAPP_SEPARATOR;
            if (this.contains(interestList, localPath = String.valueOf(localPath) + FilenameUtil.getRelativePath((String)project.getLocation().toString(), (String)FileUtil.appendPath((String)resource.getFileHandler().getCurrentWorkingDirectory(), (String)resource.getPath())))) continue;
            StringBuilder remotePath = new StringBuilder(WEBAPP_SEPARATOR).append("res/wgt").append(WEBAPP_SEPARATOR).append(resource.getPath().replaceAll("\\\\", WEBAPP_SEPARATOR));
            interestList.add(new DeltaResourceInfo(localPath, remotePath.toString()));
        }
        deployer.cleanDeltaInfo();
        String signPath = String.valueOf(WEBAPP_SEPARATOR) + ".sign" + WEBAPP_SEPARATOR;
        String remoteSignPath = String.valueOf(WEBAPP_SEPARATOR) + "res/wgt" + WEBAPP_SEPARATOR;
        if (ProjectUtil.isHybridApp((IProject)project)) {
            String manifestPath = String.valueOf(WEBAPP_SEPARATOR) + "info" + WEBAPP_SEPARATOR + TizenPlatformConstants.MANIFEST_XML_FILE_NAME;
            new DeltaResourceInfo(String.valueOf(WEBAPP_SEPARATOR) + ".package" + TizenPlatformConstants.MANIFEST_XML_FILE_NAME, manifestPath);
            remoteSignPath = WEBAPP_SEPARATOR;
        }
        interestList.add(new DeltaResourceInfo(signPath, remoteSignPath));
        return interestList;
    }

    private boolean contains(List<DeltaResourceInfo> interestList, String resourcePath) {
        for (DeltaResourceInfo interest : interestList) {
            if (!interest.getFullPath().equals(resourcePath)) continue;
            return true;
        }
        return false;
    }
}

