/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib.model.plugin;

import java.util.HashMap;

public class PluginEnvironmentVariable {
    private static HashMap<String, String> envVar = new HashMap();

    public static void setEnvVar(String key, String value) {
        envVar.put(key, value);
    }

    public static String getValue(String key) {
        String value = envVar.get(key);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public static HashMap<String, String> getAllEnvVar() {
        return envVar;
    }

    public static String changeEnvVarToValue(String line) {
        if (line == null || line.isEmpty()) {
            return null;
        }
        String retValue = line;
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) != '#') continue;
            String key = null;
            String envVar = null;
            if (line.charAt(i + 1) == '{') {
                key = PluginEnvironmentVariable.seperateKey(line.substring(i + 2, line.length()), '}');
                envVar = "#{" + key + "}";
            } else {
                key = PluginEnvironmentVariable.seperateKey(line.substring(i + 1, line.length()), ' ');
                if (key == null && (key = PluginEnvironmentVariable.seperateKey(line.substring(i + 1, line.length()), '#')) == null) {
                    key = line.substring(i + 1, line.length());
                }
                envVar = "#" + key;
            }
            if (key == null || key.isEmpty()) continue;
            retValue = retValue.replace(envVar, PluginEnvironmentVariable.getValue(key));
            i += envVar.length() - 1;
        }
        return retValue;
    }

    private static String seperateKey(String line, char endChar) {
        int i = line.indexOf(endChar);
        if (i < 0) {
            return null;
        }
        return line.substring(0, i);
    }

    public static void clear() {
        envVar.clear();
    }
}

