/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.ui;

import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.IWorkingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.wizards.online.ITizenWizardFileService;
import org.tizen.common.ui.wizards.online.TizenWizardFileServiceImpl;
import org.tizen.common.ui.wizards.project.ITizenProjectCreator;
import org.tizen.common.ui.wizards.project.TizenProjectWizardThread;
import org.tizen.common.ui.wizards.project.pages.TizenNewWizardSelectionPage;
import org.tizen.common.ui.wizards.project.template.IToolChainExtension;
import org.tizen.common.ui.wizards.project.template.TizenNewTemplateProjectWizard;
import org.tizen.common.ui.wizards.project.template.pages.ProjectPropertyPage;
import org.tizen.common.util.log.UserLogger;
import org.tizen.web.project.wizard.model.ProjectTemplate;
import org.tizen.web.project.wizard.model.TizenTemplateLibrariesPool;
import org.tizen.web.project.wizard.operation.ContentAssistOperation;
import org.tizen.web.project.wizard.operation.DefaultNatureOperation;
import org.tizen.web.project.wizard.operation.IProjectTemplateOperation;
import org.tizen.web.project.wizard.operation.LibraryCopyOperation;
import org.tizen.web.project.wizard.operation.OptionProcessOperation;
import org.tizen.web.project.wizard.operation.ProjectCreateOperation;
import org.tizen.web.project.wizard.operation.TemplateCopyOperation;
import org.tizen.web.project.wizard.operation.TizenProjectDescriptOperation;

public class TizenWebProjectCreator
implements ITizenProjectCreator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ProjectTemplate webTemplate;
    private String createProjectName;
    private TizenNewTemplateProjectWizard projectWizard;
    private IWorkingSet[] workingSets;
    private Collection<IProjectTemplateOperation> operations;
    private ITizenWizardFileService metaFileService = new TizenWizardFileServiceImpl();
    private String finalPerspectiveId = "org.tizen.web.ui.perspective.WebWidget";
    private String activeConfigFileName = "config.xml";
    private boolean isOpenConfigFile = true;
    private Map<IFile, Boolean> generatedFileMap;

    public void preCreateProject(TizenNewTemplateProjectWizard tizenNewProjectWizard) {
        UserLogger.start((String)"web.wizard", (String)"web.wizard.finish");
        this.webTemplate = (ProjectTemplate)tizenNewProjectWizard.getSelectedTemplate();
        this.createProjectName = tizenNewProjectWizard.getProjectPropertyPage().getProjectName();
        this.projectWizard = tizenNewProjectWizard;
        this.workingSets = tizenNewProjectWizard.getProjectPropertyPage().getSelectedWorkingSets();
        this.operations = this.createOperationList();
    }

    public WorkspaceJob createProjectJob() {
        return new WorkspaceJob("Creating web project"){

            /*
             * Exception decompiling
             */
            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 37[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
    }

    private void extensionCreateProcess(IProgressMonitor monitor, IProject project) {
        if (TizenNewTemplateProjectWizard.getActiveExtDeviceModel() != null && this.projectWizard.useNaclAndWasm()) {
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 10);
            IToolChainExtension.TizenProjectType tizenProjectType = TizenNewWizardSelectionPage.isTemplateSelected() ? IToolChainExtension.TizenProjectType.TEMPLATE : IToolChainExtension.TizenProjectType.SAMPLE;
            this.generatedFileMap = TizenNewTemplateProjectWizard.getActiveExtDeviceModel().performFinish(project, (IProgressMonitor)subMonitor, tizenProjectType);
            if (this.generatedFileMap != null) {
                this.openWithEditor(project);
            }
        }
    }

    private void openWithEditor(IProject project) {
        for (Map.Entry<IFile, Boolean> item : this.generatedFileMap.entrySet()) {
            IFile file = item.getKey();
            boolean toBeOpened = item.getValue();
            if (!toBeOpened || file == null || !file.exists()) continue;
            String path = file.getProjectRelativePath().toOSString();
            new TizenProjectWizardThread().activatePerspectiveAndOpenFile(this.projectWizard, project, this.finalPerspectiveId, path, true);
        }
    }

    private void deleteProject(IProject project) {
        try {
            if (project != null && project.exists()) {
                project.delete(true, true, null);
            }
        }
        catch (CoreException e) {
            this.logger.error("Failed to delete a project", (Throwable)e);
        }
    }

    private Collection<IProjectTemplateOperation> createOperationList() {
        LinkedList<IProjectTemplateOperation> operations = new LinkedList<IProjectTemplateOperation>();
        URI locationURI = null;
        ProjectPropertyPage projectPropertyPage = this.projectWizard.getProjectPropertyPage();
        if (projectPropertyPage != null) {
            locationURI = projectPropertyPage.useDefaults() ? null : projectPropertyPage.getLocationURI();
        }
        TizenTemplateLibrariesPool librariesPool = new TizenTemplateLibrariesPool(this.webTemplate.getProfileInfo());
        operations.add(new ProjectCreateOperation(locationURI));
        operations.add(new TemplateCopyOperation());
        LibraryCopyOperation libraryCopyOperation = new LibraryCopyOperation(librariesPool);
        operations.add(libraryCopyOperation);
        operations.add(new OptionProcessOperation(librariesPool));
        operations.add(new DefaultNatureOperation());
        operations.add(new TizenProjectDescriptOperation());
        operations.add(new ContentAssistOperation(libraryCopyOperation));
        return operations;
    }

    public static boolean isWebWidgetTemplate(ProjectTemplate template) {
        if (template == null) {
            return false;
        }
        return "WebWidget".equals(template.getProjectType());
    }

    static /* synthetic */ String access$0(TizenWebProjectCreator tizenWebProjectCreator) {
        return tizenWebProjectCreator.createProjectName;
    }

    static /* synthetic */ ITizenWizardFileService access$1(TizenWebProjectCreator tizenWebProjectCreator) {
        return tizenWebProjectCreator.metaFileService;
    }

    static /* synthetic */ ProjectTemplate access$2(TizenWebProjectCreator tizenWebProjectCreator) {
        return tizenWebProjectCreator.webTemplate;
    }

    static /* synthetic */ TizenNewTemplateProjectWizard access$3(TizenWebProjectCreator tizenWebProjectCreator) {
        return tizenWebProjectCreator.projectWizard;
    }

    static /* synthetic */ String access$4(TizenWebProjectCreator tizenWebProjectCreator) {
        return tizenWebProjectCreator.finalPerspectiveId;
    }

    static /* synthetic */ String access$5(TizenWebProjectCreator tizenWebProjectCreator) {
        return tizenWebProjectCreator.activeConfigFileName;
    }

    static /* synthetic */ boolean access$6(TizenWebProjectCreator tizenWebProjectCreator) {
        return tizenWebProjectCreator.isOpenConfigFile;
    }

    static /* synthetic */ Collection access$7(TizenWebProjectCreator tizenWebProjectCreator) {
        return tizenWebProjectCreator.operations;
    }

    static /* synthetic */ void access$8(TizenWebProjectCreator tizenWebProjectCreator, IProject iProject) {
        tizenWebProjectCreator.deleteProject(iProject);
    }

    static /* synthetic */ IWorkingSet[] access$9(TizenWebProjectCreator tizenWebProjectCreator) {
        return tizenWebProjectCreator.workingSets;
    }

    static /* synthetic */ void access$10(TizenWebProjectCreator tizenWebProjectCreator, IProgressMonitor iProgressMonitor, IProject iProject) {
        tizenWebProjectCreator.extensionCreateProcess(iProgressMonitor, iProject);
    }
}

