/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.preferences;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.tizen.common.util.StringUtil;
import org.tizen.web.common.WebCommonActivator;
import org.tizen.web.preferences.ChromePreferenceInitializer;
import org.tizen.web.preferences.Messages;

public class ChromePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREFERENCE_PAGE_ID = "org.tizen.web.preferences.ChromePreferencePage";
    static final int PREFERENCE_PAGE_WIDTH = 600;
    private Group grpChrome;

    public ChromePreferencePage() {
        super(0);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(WebCommonActivator.getDefault().getPreferenceStore());
        this.setDescription(Messages.MSG_PREFERENCE_PAGE_DESCRIPTION);
    }

    protected Control createContents(Composite parent) {
        Composite page = new Composite(parent, 0);
        page.setLayout((Layout)new GridLayout());
        this.grpChrome = new Group(page, 0);
        this.grpChrome.setLayout((Layout)new GridLayout());
        this.grpChrome.setLayoutData((Object)new GridData(4, -1, true, false));
        this.grpChrome.setText(Messages.CHROME_SETTINGS);
        GridLayout grpChromePageGl = new GridLayout();
        grpChromePageGl.numColumns = 3;
        grpChromePageGl.makeColumnsEqualWidth = false;
        GridData grpChromePageGd = new GridData(4, -1, true, false);
        grpChromePageGd.widthHint = 600;
        Composite grpChromePage = new Composite((Composite)this.grpChrome, 0);
        grpChromePage.setLayout((Layout)grpChromePageGl);
        grpChromePage.setLayoutData((Object)grpChromePageGd);
        FileFieldEditor chromeLocationEditor = new FileFieldEditor("CHROME_EXECUTABLE", Messages.CHROME_EXCUTABLE_LOCATION, false, 0, grpChromePage){

            protected boolean checkState() {
                this.setErrorMessage(Messages.MSG_ERR_FILE_IS_NOT_EXIST);
                return super.checkState();
            }

            protected boolean doCheckState() {
                if (StringUtil.isEmpty((CharSequence)this.getStringValue())) {
                    this.getTextControl().setMessage("please select chrome execution file");
                }
                return true;
            }
        };
        chromeLocationEditor.fillIntoGrid(grpChromePage, grpChromePageGl.numColumns);
        StringFieldEditor chromeOptionsEditor = new StringFieldEditor("EXTRA_PARAM", Messages.CHROME_EXTRA_PARAMETERS, grpChromePage);
        chromeOptionsEditor.fillIntoGrid(grpChromePage, grpChromePageGl.numColumns);
        DirectoryFieldEditor chromeProfilePathEditor = new DirectoryFieldEditor("PROFILE_PATH", Messages.CHROME_PROFILE_DATA_LOCATION, grpChromePage){

            protected boolean doCheckState() {
                String fileName = this.getTextControl().getText();
                if (StringUtil.isEmpty((CharSequence)fileName)) {
                    return this.isEmptyStringAllowed();
                }
                if (!ChromePreferencePage.isWritableDirectory(fileName)) {
                    this.setErrorMessage(String.format(Messages.MSG_ERR_PROFILE_WRITABLE_DIRECTORY, new Object[0]));
                    return false;
                }
                if ("win32".equals(Platform.getOS())) {
                    return true;
                }
                return true;
            }

            public boolean isEmptyStringAllowed() {
                return true;
            }
        };
        chromeProfilePathEditor.fillIntoGrid(grpChromePage, grpChromePageGl.numColumns);
        this.addField((FieldEditor)chromeLocationEditor);
        this.addField((FieldEditor)chromeOptionsEditor);
        this.addField((FieldEditor)chromeProfilePathEditor);
        this.initialize();
        this.checkState();
        return page;
    }

    protected void performDefaults() {
        ChromePreferenceInitializer.setDefaultValue();
        super.performDefaults();
    }

    protected void createFieldEditors() {
    }

    private static boolean isWritableDirectory(String fileName) {
        File file = new File(fileName);
        return file.isDirectory() && file.canWrite();
    }
}

