/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.util.jsconsole;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.Version;
import org.tizen.common.ui.CommonColor;
import org.tizen.common.ui.view.console.ConsoleManager2;
import org.tizen.common.util.StringUtil;
import org.tizen.sdblib.dlog.DlogFormat;
import org.tizen.sdblib.dlog.DlogInfo;
import org.tizen.sdblib.receiver.DlogReceiver;
import org.tizen.sdblib.util.DlogUtil;
import org.tizen.sdblib.util.LogLevel;
import org.tizen.web.editor.configuration.util.ConfigurationUtil;
import org.tizen.web.zimlaunch.constants.TizenWebLaunchConstants;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogInfo;

public class JsLogReceiver
extends DlogReceiver {
    private static final Pattern DLOG_PATTERN_LEGACY = Pattern.compile("file:\\S*opt/usr/apps/([^/]*).*$");
    private static final Pattern DLOG_PATTERN = Pattern.compile("^\\[(.*?)\\] .*:\\d*: .*");
    private static final Pattern JS_LOG_PATTERN_LEGACY = Pattern.compile("(^.*?):(\\d*):(.*)");
    private static final Pattern JS_LOG_PATTERN = Pattern.compile("^\\[.*?\\] (.*?):(\\d*): (.*)");
    private static final Pattern JS_LOG_PATTERN_CHROMIUM = Pattern.compile("^\\[.*\\((.*?)\\)\\] \"(.*?)\", .*: (.*?) \\((.*?)\\)");
    public static final String MIN_PLATFORM_VERSION_FOR_CHROMIUM_LOG = "5.5";
    protected ConsoleManager2 consoleManager;
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String packageID = "";
    private boolean isClosed = false;
    private Calendar calendar;
    private Version targetVersion;
    private Pattern dlogPattern = DLOG_PATTERN_LEGACY;
    private Pattern jsLogPattern = JS_LOG_PATTERN_LEGACY;

    public JsLogReceiver() {
        this("", TizenWebLaunchConstants.DLOGUTIL_V_OPTION);
    }

    public JsLogReceiver(String packageID) {
        this(packageID, TizenWebLaunchConstants.DLOGUTIL_V_OPTION);
    }

    public JsLogReceiver(String packageID, DlogFormat dlogFormat) {
        super(dlogFormat);
        this.setTrimLines(false);
        this.setPackageID(packageID);
    }

    public synchronized void processNewLines(String[] lines) {
        if (this.isClosed) {
            return;
        }
        this.logger.trace("Process new lines({})", (Object)lines.length);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.logger.trace("line: {}", (Object)line);
            ++n2;
        }
        this.printJsLog(this.parseJsLog(lines));
    }

    protected List<JsLogInfo> parseJsLog(String[] lines) {
        if (lines == null) {
            return null;
        }
        ArrayList<JsLogInfo> jsLogInfos = new ArrayList<JsLogInfo>();
        DlogInfo[] dlogInfos = DlogUtil.getDlogInfos((DlogFormat)this.getDlogFormat(), (String[])lines);
        if (dlogInfos == null) {
            this.logger.debug("Dlog's information list is null");
            return null;
        }
        if (this.targetVersion != null && this.targetVersion.isSameOrBiggerThanVersion3()) {
            this.dlogPattern = DLOG_PATTERN;
            this.jsLogPattern = JS_LOG_PATTERN;
        }
        if (this.targetVersion != null && ConfigurationUtil.checkApiVersion((String)this.targetVersion.get(), (String)MIN_PLATFORM_VERSION_FOR_CHROMIUM_LOG)) {
            this.jsLogPattern = JS_LOG_PATTERN_CHROMIUM;
        }
        DlogInfo[] dlogInfoArray = dlogInfos;
        int n = dlogInfos.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                JsLogInfo jsLogInfo;
                DlogInfo info;
                block12: {
                    Calendar infoCalendar;
                    info = dlogInfoArray[n2];
                    String pkgID = "";
                    Matcher m = this.dlogPattern.matcher(info.getCommand());
                    if (m.find()) {
                        pkgID = m.group(1);
                    }
                    if (!this.packageID.equals("") && !this.packageID.equals(pkgID) && !ConfigurationUtil.checkApiVersion((String)this.targetVersion.get(), (String)MIN_PLATFORM_VERSION_FOR_CHROMIUM_LOG)) break block11;
                    if (this.calendar == null || (infoCalendar = info.getCalendar()) == null) break block12;
                    if (infoCalendar.get(1) == 1) {
                        infoCalendar.set(1, this.calendar.get(1));
                    }
                    if (this.calendar.compareTo(infoCalendar) > 0) break block11;
                }
                if ((jsLogInfo = this.createJsLogInfo(info)) != null) {
                    jsLogInfos.add(jsLogInfo);
                }
            }
            ++n2;
        }
        return jsLogInfos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsLogInfo createJsLogInfo(DlogInfo info) {
        String command = info.getCommand();
        if (command == null) {
            return null;
        }
        JsLogInfo jsLogInfo = new JsLogInfo(info);
        String sourceName = "";
        String line = "";
        String msg = "";
        String[] path = StringUtil.split((String)command, (Pattern)this.jsLogPattern);
        try {
            if (path == null) return jsLogInfo;
            if (ConfigurationUtil.checkApiVersion((String)this.targetVersion.get(), (String)MIN_PLATFORM_VERSION_FOR_CHROMIUM_LOG)) {
                line = path[0];
                msg = path[1];
                sourceName = path[2];
            } else {
                sourceName = path[0];
                line = path[1];
                msg = path[2];
            }
            URL url = new URL(command);
            if ("http".equals(url.getProtocol())) {
                if (msg.contains("livereload.js")) {
                    return null;
                }
                jsLogInfo.sourceName = sourceName;
                jsLogInfo.sourceName = StringUtil.split((String)jsLogInfo.sourceName, (String)"?")[0];
                if (jsLogInfo.sourceName.startsWith("/")) {
                    jsLogInfo.sourceName = jsLogInfo.sourceName.substring(1);
                }
            } else if ("file".equals(url.getProtocol())) {
                jsLogInfo.sourceName = this.getSourceName(sourceName);
            }
            jsLogInfo.line = line;
            jsLogInfo.msg = msg;
            return jsLogInfo;
        }
        catch (MalformedURLException e) {
            if (this.targetVersion.isSameOrBiggerThanVersion3()) {
                jsLogInfo.sourceName = sourceName;
                jsLogInfo.line = line;
                jsLogInfo.msg = msg;
                return jsLogInfo;
            }
            jsLogInfo.msg = command;
            this.logger.debug(e.getMessage());
        }
        return jsLogInfo;
    }

    protected void printJsLog(List<JsLogInfo> logMessageList) {
        if (this.consoleManager == null) {
            return;
        }
        if (logMessageList == null) {
            return;
        }
        for (JsLogInfo jsLogInfo : logMessageList) {
            LogLevel level = jsLogInfo.getDlogInfo().getLogLevel();
            if (level == null) continue;
            String consoleMessage = jsLogInfo.toString();
            if ('W' == level.getLetter()) {
                this.consoleManager.println(consoleMessage, 0, CommonColor.DARK_GOLDENROD);
                continue;
            }
            if ('E' == level.getLetter()) {
                this.consoleManager.println(consoleMessage, 0, CommonColor.RED);
                continue;
            }
            this.consoleManager.println(consoleMessage, 0, CommonColor.BLACK);
        }
        logMessageList.clear();
    }

    protected String getSourceName(String message) {
        if (StringUtil.isEmpty((CharSequence)message)) {
            return "";
        }
        StringBuilder name = new StringBuilder();
        String[] temp = StringUtil.split((String)message, (String)"/");
        int i = 3;
        while (i < temp.length) {
            if ("res".equals(temp[i - 2]) && "wgt".equals(temp[i - 1])) {
                name.append(temp[i]);
            } else if (!StringUtil.isEmpty((CharSequence)name)) {
                name.append("/");
                name.append(temp[i]);
            }
            ++i;
        }
        return name.toString();
    }

    public void setPackageID(String packageID) {
        this.packageID = packageID;
        this.logger.debug("Receiver's package id: {}", (Object)packageID);
    }

    public boolean isCancelled() {
        return this.isClosed;
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    public void init() {
        this.isClosed = false;
    }

    public void setConsoleManager(ConsoleManager2 consoleManager) {
        this.consoleManager = consoleManager;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public void setTargetVersion(Version targetVersion) {
        this.targetVersion = targetVersion;
    }
}

