/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.util;

import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.IOUtil;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.config.schema.model.Application;
import org.tizen.web.config.schema.model.Widget;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;
import org.tizen.web.editor.configuration.ITizenConfigurator;

public class ConfigurationUtil {
    public static String MIN_VERSION_SUPPORT_TRUST_ANCHOR = "4.0";
    public static String MIN_VERSION_SUPPORT_APPDEFINED_PRIVILEGE = "4.0";
    public static String MIN_VERSION_SUPPORT_MULTI_PACKAGE_DEPENDENCY = "5.5";

    public static Widget getWidget(IProject project) throws CoreException, ConfigurationException {
        Assert.isNotNull((Object)project);
        if (!project.isAccessible()) {
            return null;
        }
        IFile file = project.getFile("config.xml");
        if (!file.isAccessible()) {
            return null;
        }
        InputStream is = null;
        Widget widget = null;
        try {
            is = file.getContents();
            widget = ConfiguratorFactory.unmarshal(is);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{is});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{is});
        return widget;
    }

    public static String getApplicationVersion(IProject project) throws CoreException, ConfigurationException {
        TizenProjectDescription description = ProjectUtil.getTizenProjectDescription((IProject)project);
        if (description != null) {
            return description.getVersion();
        }
        return null;
    }

    public static String getRequiredVersion(IProject project) throws CoreException, ConfigurationException {
        Application application = ConfigurationUtil.getApplication(project);
        if (application != null) {
            return application.getRequiredVersion();
        }
        return null;
    }

    private static Application getApplication(IProject project) throws CoreException, ConfigurationException {
        Widget widget = ConfigurationUtil.getWidget(project);
        if (widget == null) {
            return null;
        }
        List elements = widget.getContent();
        for (Object element : elements) {
            if (!(element instanceof Application)) continue;
            return (Application)element;
        }
        return null;
    }

    private static boolean compareVersions(String[] projVersion, String[] minVersion) {
        int length = Math.max(minVersion.length, projVersion.length);
        int i = 0;
        while (i < length) {
            int minV;
            int projectV = i < projVersion.length ? Integer.valueOf(projVersion[i]) : 0;
            int n = minV = i < minVersion.length ? Integer.valueOf(minVersion[i]) : 0;
            if (projectV < minV) {
                return false;
            }
            if (projectV > minV) {
                return true;
            }
            ++i;
        }
        return true;
    }

    public static boolean checkApiVersion(String appVersion, String minVersion) {
        String[] versions = appVersion.split("\\.");
        String[] supportedVersions = minVersion.split("\\.");
        return ConfigurationUtil.compareVersions(versions, supportedVersions);
    }

    public static boolean isUIAppType(ITizenConfigurator config) {
        return config != null && config.getContent() != null || config.getProject().getFile("index.html").exists();
    }

    public static boolean isGlobalServiceAppType(ITizenConfigurator config) {
        return config != null && config.getService() != null && config.getService().getType().equals("global");
    }
}

