/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.dependency;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.tizen.web.config.schema.model.ActivationType;
import org.tizen.web.config.schema.model.Dependency;
import org.tizen.web.editor.configuration.ConfigurationEditor;
import org.tizen.web.editor.configuration.IMobileConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.MobileConfiguratorImpl;
import org.tizen.web.editor.configuration.page.EditorFormToolkit;
import org.tizen.web.editor.configuration.page.IGroupTableEvent;
import org.tizen.web.editor.configuration.page.TizenPage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DependencyGroupTableEvent
implements IGroupTableEvent {
    private Table dependencyListTable;
    private TableViewer tableViewer;
    private EditorFormToolkit editorToolkit;
    private TizenPage page;
    private ConfigurationEditor mConfig;

    public DependencyGroupTableEvent(TizenPage page, TableViewer tableViewer, EditorFormToolkit editorToolkit, ConfigurationEditor mConfig) {
        this.mConfig = mConfig;
        this.page = page;
        this.tableViewer = tableViewer;
        this.editorToolkit = editorToolkit;
    }

    @Override
    public void onRemove() {
        IStructuredSelection sel = (IStructuredSelection)this.tableViewer.getSelection();
        Object element = sel.getFirstElement();
        if (element != null) {
            this.tableViewer.remove(element);
            this.page.markDirty();
            if (this.tableViewer.getTable().getItemCount() <= 0) {
                this.page.setBackgroundSupport(ActivationType.DISABLE);
            }
            this.page.setBGCategoryUI(this.page.getRequiredVersion(), this.tableViewer.getTable().getItemCount());
        }
    }

    private static boolean isAdded(String value, List<Dependency> currentDependencies) {
        if (currentDependencies != null) {
            for (Dependency dep : currentDependencies) {
                if (!dep.getContent().equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private Element getDocumentElementFromManifest(String filepath) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(filepath);
            doc.getDocumentElement().normalize();
            return doc.getDocumentElement();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Element getDocumentElementFromConfig(String filepath) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(filepath);
            Element element = doc.getDocumentElement();
            element.normalize();
            return element;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List<Dependency> getTobeReferenceProjectList(List<Dependency> currentDependencies) {
        String pkgID = "";
        String version = "";
        String targetPkgID = "";
        Element configElement = null;
        IProject targetProject = this.mConfig.getProject();
        ArrayList<Dependency> tobeRefPojectList = new ArrayList<Dependency>();
        if (targetProject == null) {
            return tobeRefPojectList;
        }
        IProject[] workspaceProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        configElement = this.getDocumentElementFromConfig(String.valueOf(targetProject.getLocation().toOSString()) + File.separator + "config.xml");
        if (configElement == null) {
            return tobeRefPojectList;
        }
        IProject[] iProjectArray = workspaceProjects;
        int n = workspaceProjects.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                block11: {
                    Element manifestElement;
                    block9: {
                        IProject project = iProjectArray[n2];
                        manifestElement = this.getDocumentElementFromManifest(String.valueOf(project.getLocation().toOSString()) + File.separator + "tizen-manifest.xml");
                        if (manifestElement != null) break block9;
                        configElement = this.getDocumentElementFromConfig(String.valueOf(project.getLocation().toOSString()) + File.separator + "config.xml");
                        if (configElement == null) break block10;
                        version = configElement.getAttribute("version").toString();
                        Node node = configElement.getFirstChild();
                        while (node != null) {
                            String nodeName = node.getNodeName();
                            if (nodeName.equals("tizen:application")) {
                                NamedNodeMap attrs = node.getAttributes();
                                int i = 0;
                                while (i < attrs.getLength()) {
                                    Node subNode = attrs.item(i);
                                    if (subNode.getNodeName().equals("package")) {
                                        pkgID = subNode.getNodeValue();
                                        if (targetProject.getName().equals(project.getName())) {
                                            targetPkgID = subNode.getNodeValue();
                                        }
                                    }
                                    ++i;
                                }
                            }
                            node = node.getNextSibling();
                        }
                        break block11;
                    }
                    pkgID = manifestElement.getAttribute("package").toString();
                    version = manifestElement.getAttribute("version").toString();
                }
                if (!(pkgID.isEmpty() || DependencyGroupTableEvent.isAdded(pkgID, currentDependencies) || pkgID.equals(targetPkgID))) {
                    Dependency dep = new Dependency();
                    dep.setContent(pkgID);
                    dep.setRequiredVersion(version);
                    tobeRefPojectList.add(dep);
                }
            }
            ++n2;
        }
        return tobeRefPojectList;
    }

    @Override
    public void onAdd() {
        List<Dependency> newDependencies;
        AddDependecyDialog dialog;
        List<Dependency> currentDependencies = null;
        Object obj = this.tableViewer.getInput();
        if (obj == null) {
            return;
        }
        if (obj instanceof MobileConfiguratorImpl) {
            currentDependencies = ((IMobileConfigurator)obj).getDependencyList();
        }
        if ((dialog = new AddDependecyDialog(this.editorToolkit, this.getTobeReferenceProjectList(currentDependencies))).open() == 0 && (newDependencies = dialog.getSelectedDependencies()) != null) {
            for (Dependency dep : newDependencies) {
                this.tableViewer.add((Object)dep);
            }
            this.page.markDirty();
            this.page.setBGCategoryUI(this.page.getRequiredVersion(), this.tableViewer.getTable().getItemCount());
            if (this.tableViewer.getTable().getItemCount() > 0) {
                this.page.setBackgroundSupport(ActivationType.ENABLE);
            }
        }
    }

    public class AddDependecyDialog
    extends SelectionStatusDialog {
        protected FormToolkit toolkit;
        private final String DEFAULT_TYPE = "wants";
        private final String[] TITLES;
        private final String[] TYPES;
        private List<Dependency> selectedDependencies;
        private List<Dependency> dependencies;

        public AddDependecyDialog(FormToolkit tk, List<Dependency> dependencies) {
            super(Display.getDefault().getActiveShell());
            this.DEFAULT_TYPE = "wants";
            this.TITLES = new String[]{"Packages List", "Type"};
            this.TYPES = new String[]{"requires", "wants"};
            this.toolkit = tk;
            this.dependencies = dependencies;
            this.setTitle(Messages.TizenPage_addPackageLabel);
        }

        public List<Dependency> getSelectedDependencies() {
            return this.selectedDependencies;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginTop = 20;
            layout.marginBottom = 9;
            layout.marginLeft = 20;
            layout.marginRight = 10;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            composite.setLayout((Layout)layout);
            composite.setBackground(new Color(null, 255, 255, 255));
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 450;
            gd.heightHint = 400;
            composite.setLayoutData((Object)gd);
            GridData data = new GridData();
            data.heightHint = 150;
            data.widthHint = 600;
            data.grabExcessVerticalSpace = true;
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            data.verticalAlignment = 4;
            DependencyGroupTableEvent.this.dependencyListTable = new Table(composite, 68128);
            DependencyGroupTableEvent.this.dependencyListTable.setLayoutData((Object)data);
            DependencyGroupTableEvent.this.dependencyListTable.setHeaderVisible(true);
            int loopIndex = 0;
            while (loopIndex < this.TITLES.length) {
                TableColumn column = new TableColumn(DependencyGroupTableEvent.this.dependencyListTable, 0);
                column.setText(this.TITLES[loopIndex]);
                ++loopIndex;
            }
            for (Dependency dep : this.dependencies) {
                TableItem item = new TableItem(DependencyGroupTableEvent.this.dependencyListTable, 0);
                item.setText(0, dep.getContent());
                item.setText(1, "wants");
            }
            TableLayout tableLayout = new TableLayout();
            DependencyGroupTableEvent.this.dependencyListTable.setLayout((Layout)tableLayout);
            int loopIndex2 = 0;
            while (loopIndex2 < this.TITLES.length) {
                tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
                DependencyGroupTableEvent.this.dependencyListTable.getColumn(loopIndex2).pack();
                ++loopIndex2;
            }
            final TableEditor editor = new TableEditor(DependencyGroupTableEvent.this.dependencyListTable);
            editor.horizontalAlignment = 16384;
            editor.grabHorizontal = true;
            DependencyGroupTableEvent.this.dependencyListTable.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent event) {
                    Control old = editor.getEditor();
                    if (old != null) {
                        old.dispose();
                    }
                    Point pt = new Point(event.x, event.y);
                    final TableItem item = DependencyGroupTableEvent.this.dependencyListTable.getItem(pt);
                    if (item != null) {
                        int column = -1;
                        int i = 0;
                        int n = DependencyGroupTableEvent.this.dependencyListTable.getColumnCount();
                        while (i < n) {
                            Rectangle rect = item.getBounds(i);
                            if (rect.contains(pt)) {
                                column = i;
                                break;
                            }
                            ++i;
                        }
                        if (column == 1) {
                            final CCombo combo = new CCombo((Composite)DependencyGroupTableEvent.this.dependencyListTable, 8);
                            int i2 = 0;
                            int n2 = AddDependecyDialog.this.TYPES.length;
                            while (i2 < n2) {
                                combo.add(AddDependecyDialog.this.TYPES[i2]);
                                ++i2;
                            }
                            combo.select(combo.indexOf(item.getText(column)));
                            combo.setFocus();
                            editor.setEditor((Control)combo, item, column);
                            final int col = column;
                            combo.addModifyListener(new ModifyListener(){

                                public void modifyText(ModifyEvent e) {
                                    item.setText(col, combo.getText());
                                    combo.dispose();
                                }
                            });
                        }
                    }
                }
            });
            return composite;
        }

        protected void computeResult() {
            this.selectedDependencies = new ArrayList<Dependency>();
            TableItem[] tableItems = DependencyGroupTableEvent.this.dependencyListTable.getItems();
            int index = 0;
            TableItem[] tableItemArray = tableItems;
            int n = tableItems.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getChecked()) {
                    Dependency dep = new Dependency();
                    dep.setContent(item.getText(0));
                    dep.setRequiredVersion(this.dependencies.get(index).getRequiredVersion());
                    dep.setType(item.getText(1));
                    this.selectedDependencies.add(dep);
                }
                ++index;
                ++n2;
            }
        }
    }
}

