/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.rds.ui.preference.RdsPreferencePage;
import org.tizen.common.util.ImageUtil;
import org.tizen.web.common.CommonMessages;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.zimlaunch.Activator;
import org.tizen.web.zimlaunch.constants.TizenWebLaunchConstants;
import org.tizen.web.zimlaunch.ui.Messages;
import org.tizen.web.zimlaunch.util.LaunchUtil;

public class TizenWebMainTab
extends AbstractLaunchConfigurationTab {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String PROJECT_NAME = "project_name";
    protected Label fProjLabel;
    protected Text fProjText;
    protected Button fProjButton;
    protected Slider fslider;
    protected Label fsliderLabel;
    protected Button updateMode;
    private String launchMode;
    private Button fEnableLiveEditing;

    public TizenWebMainTab(String mode) {
        this.launchMode = mode;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        this.createProjectGroup(comp, 1);
        this.createVerticalSpacer(comp, 1);
        this.createTargetTypeGroup(comp, 1);
        this.createVerticalSpacer(comp, 1);
        if (!this.isDebugMode()) {
            this.createLiveEditingGroup(comp, 1);
        }
        this.createVerticalSpacer(comp, 1);
        this.createTimeoutGroup(comp, 1);
    }

    private void createLiveEditingGroup(Composite comp, int i) {
        this.fEnableLiveEditing = this.createCheckButton(comp, Messages.ENABLE_LIVE_EDITING);
        this.fEnableLiveEditing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TizenWebMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createTimeoutGroup(Composite parent, int colSpan) {
        Composite timeoutComp = new Composite(parent, 0);
        timeoutComp.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = colSpan;
        timeoutComp.setLayoutData((Object)gd);
        Label timeoutLabel = new Label(timeoutComp, 0);
        timeoutLabel.setText(Messages.TIMEOUT_NAME);
        gd = new GridData();
        gd.horizontalSpan = 2;
        timeoutLabel.setLayoutData((Object)gd);
        this.fslider = new Slider(timeoutComp, 0);
        this.fslider.setIncrement(1);
        this.fslider.setMinimum(90);
        this.fslider.setMaximum(610);
        this.fslider.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String msg = NLS.bind((String)Messages.TIMEOUT_VALUE, (Object)TizenWebMainTab.this.fslider.getSelection());
                TizenWebMainTab.this.fsliderLabel.setText(msg);
                TizenWebMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        gd = new GridData(768);
        this.fslider.setLayoutData((Object)gd);
        this.fsliderLabel = new Label(timeoutComp, 131072);
        gd = new GridData();
        this.fsliderLabel.setLayoutData((Object)gd);
    }

    protected void createProjectGroup(Composite parent, int colSpan) {
        Composite projComp = new Composite(parent, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        projComp.setLayoutData((Object)gd);
        this.fProjLabel = new Label(projComp, 0);
        this.fProjLabel.setText(Messages.PROJECT_NAME);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProjLabel.setLayoutData((Object)gd);
        this.fProjText = new Text(projComp, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TizenWebMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fProjButton = this.createPushButton(projComp, CommonMessages.Dialog_browse, null);
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TizenWebMainTab.this.handleProjectButtonSelected();
                TizenWebMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createTargetTypeGroup(Composite parent, int colSpan) {
        final Composite targetGroup = new Composite(parent, 0);
        GridLayout Layout2 = new GridLayout();
        Layout2.numColumns = 2;
        Layout2.marginHeight = 0;
        Layout2.marginWidth = 0;
        targetGroup.setLayout((Layout)Layout2);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        targetGroup.setLayoutData((Object)gd);
        targetGroup.addListener(32, new Listener(){

            public void handleEvent(Event event) {
                if (!TizenWebMainTab.this.updateMode.isEnabled()) {
                    targetGroup.setToolTipText(Messages.UPDATE_MODE_TOOLTIP);
                }
            }
        });
        this.updateMode = new Button(targetGroup, 32);
        this.updateMode.setText(Messages.UPDATE_MODE_LABEL);
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 4;
        this.updateMode.setLayoutData((Object)gdata);
        this.updateMode.setFont(parent.getFont());
        this.updateMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TizenWebMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.updateMode.addListener(32, new Listener(){

            public void handleEvent(Event event) {
                if (TizenWebMainTab.this.updateMode.isEnabled()) {
                    TizenWebMainTab.this.updateMode.setToolTipText(Messages.UPDATE_MODE_ENABLE_STATE_MSG);
                }
            }
        });
        this.updateMode.setEnabled(true);
    }

    protected void handleProjectButtonSelected() {
        IProject project = this.chooseWebProject();
        if (project == null) {
            return;
        }
        this.fProjText.setText(project.getName());
        this.hanldeUpdateModeButtonEnable(project);
    }

    private IProject chooseWebProject() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> webProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (ProjectUtil.isWebProject((IProject)project)) {
                webProjects.add(project);
            }
            ++n2;
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider());
        dialog.setTitle(Messages.MAINTAB_TITLE);
        dialog.setMessage(Messages.MAINTAB_MESSAGE);
        dialog.setElements((Object[])webProjects.toArray(new IProject[webProjects.size()]));
        if (dialog.open() == 0) {
            return (IProject)dialog.getFirstResult();
        }
        return null;
    }

    public String getName() {
        return Messages.MAINTAB;
    }

    public Image getImage() {
        return ImageUtil.getImage((Plugin)Activator.getDefault(), (String)"icons/c_app.gif");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateProjectFromConfig(configuration);
        this.updateTimeoutFromConfig(configuration);
        this.updateTargetTypeFromConfig(configuration);
        if (!this.isDebugMode()) {
            this.updateLiveEditingFromConfig(configuration);
        }
    }

    private boolean isDebugMode() {
        return "debug".equals(this.launchMode);
    }

    private void updateLiveEditingFromConfig(ILaunchConfiguration configuration) {
        boolean canRun = false;
        try {
            canRun = LaunchUtil.canRun(this.getCurrentProject(configuration));
        }
        catch (ConfigurationException e) {
            this.logger.debug("Don't know the project can run or not", (Throwable)e);
        }
        this.fEnableLiveEditing.setEnabled(canRun);
        try {
            if (canRun) {
                boolean enableLiveEditing = configuration.getAttribute(TizenWebLaunchConstants.ATTR_LIVE_EDITING, org.tizen.web.browser.Activator.isEnabledLiveEditing());
                this.fEnableLiveEditing.setSelection(enableLiveEditing);
            } else {
                this.fEnableLiveEditing.setSelection(false);
            }
        }
        catch (CoreException e) {
            this.logger.debug(e.getMessage());
        }
    }

    private IProject getCurrentProject(ILaunchConfiguration configuration) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        String projectName = this.getProjectName(configuration);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.getName().equals(projectName)) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    protected void updateTimeoutFromConfig(ILaunchConfiguration config) {
        int timeoutValue = 300;
        try {
            timeoutValue = config.getAttribute(TizenWebLaunchConstants.ATTR_TIMEOUT_VALUE, 300);
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        this.fslider.setSelection(timeoutValue);
        this.fsliderLabel.setText(NLS.bind((String)Messages.TIMEOUT_VALUE, (Object)timeoutValue));
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        this.fProjText.setText(this.getProjectName(config));
    }

    private String getProjectName(ILaunchConfiguration config) {
        String projectName = "";
        try {
            IProject project = LaunchUtil.getProject((ILaunchConfiguration)config);
            if (project != null && (ProjectUtil.isWebProject((IProject)project) || ProjectUtil.isWebWidgetProject((IProject)project))) {
                projectName = project.getName();
            }
        }
        catch (CoreException coreException) {
            return "";
        }
        return projectName;
    }

    protected void updateTargetTypeFromConfig(ILaunchConfiguration config) {
        boolean updateFlag = false;
        try {
            updateFlag = config.getAttribute(TizenWebLaunchConstants.ATTR_UPDATE_MODE, false);
            IProject project = LaunchUtil.getProject((ILaunchConfiguration)config);
            this.hanldeUpdateModeButtonEnable(project);
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        this.updateMode.setSelection(updateFlag);
    }

    protected void hanldeUpdateModeButtonEnable(IProject project) {
        boolean isRds = true;
        if (project != null && project.isOpen()) {
            isRds = RdsPreferencePage.isWebRdsMode((IProject)project);
        }
        if (project == null || isRds) {
            this.updateMode.setEnabled(false);
        } else {
            this.updateMode.setEnabled(true);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean isValid = false;
        String name = this.fProjText.getText().trim();
        if ("".equals(name)) {
            this.setErrorMessage(Messages.PROJECT_NOT_SPECIFIED);
            return isValid;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (!project.exists()) {
            this.setErrorMessage(CommonMessages.Project_does_not_exist);
        } else if (!project.isOpen()) {
            this.setErrorMessage(Messages.PROJECT_NOT_OPENED);
        } else if (!ProjectUtil.isWebProject((IProject)project) && !ProjectUtil.isWebWidgetProject((IProject)project)) {
            this.setErrorMessage(Messages.NOT_WEB_APP_PROJECT);
        } else {
            char[] modeChars = this.launchMode.toCharArray();
            modeChars[0] = Character.toUpperCase(modeChars[0]);
            String mode = new String(modeChars);
            this.setMessage(NLS.bind((String)Messages.RUN_WEB_PROJECT, (Object)mode));
            isValid = true;
        }
        return isValid;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.tizen.common.CONFIG_ATTR_PROJECT_NAME", this.fProjText.getText());
        configuration.setAttribute(TizenWebLaunchConstants.ATTR_TIMEOUT_VALUE, this.fslider.getSelection());
        configuration.setAttribute(TizenWebLaunchConstants.ATTR_UPDATE_MODE, this.updateMode.getSelection());
        if (!this.isDebugMode()) {
            configuration.setAttribute(TizenWebLaunchConstants.ATTR_LIVE_EDITING, this.fEnableLiveEditing.getSelection());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        try {
            try {
                configuration.setAttribute("org.tizen.common.CONFIG_ATTR_PROJECT_NAME", this.getProjectName(configuration.doSave()));
            }
            catch (CoreException coreException) {
                configuration.setAttribute("org.tizen.common.CONFIG_ATTR_PROJECT_NAME", "");
                configuration.setAttribute(TizenWebLaunchConstants.ATTR_TIMEOUT_VALUE, 300);
                configuration.setAttribute(TizenWebLaunchConstants.ATTR_UPDATE_MODE, false);
                configuration.setAttribute(TizenWebLaunchConstants.ATTR_LIVE_EDITING, org.tizen.web.browser.Activator.isEnabledLiveEditing());
            }
        }
        finally {
            configuration.setAttribute(TizenWebLaunchConstants.ATTR_TIMEOUT_VALUE, 300);
            configuration.setAttribute(TizenWebLaunchConstants.ATTR_UPDATE_MODE, false);
            configuration.setAttribute(TizenWebLaunchConstants.ATTR_LIVE_EDITING, org.tizen.web.browser.Activator.isEnabledLiveEditing());
        }
    }
}

