/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.htmlcompressor.compressor;

import com.googlecode.htmlcompressor.compressor.Compressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class YuiJavaScriptCompressor
implements Compressor {
    private boolean noMunge = false;
    private boolean preserveAllSemiColons = false;
    private boolean disableOptimizations = false;
    private int lineBreak = -1;
    private ErrorReporter errorReporter = new DefaultErrorReporter();

    public String compress(String source) {
        StringWriter result = new StringWriter();
        try {
            JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)new StringReader(source), this.errorReporter);
            compressor.compress((Writer)result, this.lineBreak, !this.noMunge, false, this.preserveAllSemiColons, this.disableOptimizations);
        }
        catch (IOException e) {
            result.write(source);
            e.printStackTrace();
        }
        return result.toString();
    }

    public boolean isNoMunge() {
        return this.noMunge;
    }

    public void setNoMunge(boolean noMunge) {
        this.noMunge = noMunge;
    }

    public boolean isPreserveAllSemiColons() {
        return this.preserveAllSemiColons;
    }

    public void setPreserveAllSemiColons(boolean preserveAllSemiColons) {
        this.preserveAllSemiColons = preserveAllSemiColons;
    }

    public boolean isDisableOptimizations() {
        return this.disableOptimizations;
    }

    public void setDisableOptimizations(boolean disableOptimizations) {
        this.disableOptimizations = disableOptimizations;
    }

    public int getLineBreak() {
        return this.lineBreak;
    }

    public void setLineBreak(int lineBreak) {
        this.lineBreak = lineBreak;
    }

    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    public static class DefaultErrorReporter
    implements ErrorReporter {
        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                System.err.println("[WARNING] HtmlCompressor: \"" + message + "\" during JavaScript compression");
            } else {
                System.err.println("[WARNING] HtmlCompressor: \"" + message + "\" at line [" + line + ":" + lineOffset + "] during JavaScript compression" + (lineSource != null ? ": " + lineSource : ""));
            }
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                System.err.println("[ERROR] HtmlCompressor: \"" + message + "\" during JavaScript compression");
            } else {
                System.err.println("[ERROR] HtmlCompressor: \"" + message + "\" at line [" + line + ":" + lineOffset + "] during JavaScript compression" + (lineSource != null ? ": " + lineSource : ""));
            }
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message);
        }
    }
}

