/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib.for_cli.sbiplugin;

public class SBIArch {
    public static final String[] ARCHGROUP_X86 = new String[]{"86", "x86", "X86", "i386", "ia32", "i586", "i686", "LLVM-Bitcode/X86"};
    public static final String[] ARCHGROUP_ARM = new String[]{"arm", "ARMv7-a", "armel", "armv7", "armv7l", "LLVM-Bitcode/ARM"};
    public static final String[] ARCHGROUP_X86_64 = new String[]{"x86_64", "X86_64", "x64", "X64"};
    public static final String[] ARCHGROUP_ARM_64 = new String[]{"aarch64", "armv8"};

    public static boolean isSameArchType(String arch1, String arch2) {
        if (SBIArch.isX86Arch(arch1)) {
            return SBIArch.isX86Arch(arch2);
        }
        if (SBIArch.isArmArch(arch1)) {
            return SBIArch.isArmArch(arch2);
        }
        if (SBIArch.isX86_64Arch(arch1)) {
            return SBIArch.isX86_64Arch(arch2);
        }
        if (SBIArch.isArm_64Arch(arch1)) {
            return SBIArch.isArm_64Arch(arch2);
        }
        return false;
    }

    public static boolean isX86Arch(String arch) {
        for (String a : ARCHGROUP_X86) {
            if (!a.equals(arch)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArmArch(String arch) {
        for (String a : ARCHGROUP_ARM) {
            if (!a.equals(arch)) continue;
            return true;
        }
        return false;
    }

    public static boolean isX86_64Arch(String arch) {
        for (String a : ARCHGROUP_X86_64) {
            if (!a.equals(arch)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArm_64Arch(String arch) {
        for (String a : ARCHGROUP_ARM_64) {
            if (!a.equals(arch)) continue;
            return true;
        }
        return false;
    }
}

