/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.privilege;

import java.util.Collection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.widl.model.PrivilegeWrapper;

public class PrivilegeSorter
extends ViewerSorter {
    private static final int KNOWN_PRIVILEGE = 1;
    private static final int FOREIGN_PRIVILEGE = 2;
    private Collection<PrivilegeWrapper> knownPrivileges;

    public PrivilegeSorter(ITizenConfigurator configurator) {
        this.knownPrivileges = configurator.getKnownPrivileges();
    }

    public int category(Object element) {
        if (element instanceof PrivilegeWrapper) {
            PrivilegeWrapper privilege = (PrivilegeWrapper)element;
            if (this.knownPrivileges.contains(privilege)) {
                return 1;
            }
            return 2;
        }
        return super.category(element);
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int category2;
        int category1 = this.category(e1);
        if (category1 != (category2 = this.category(e2))) {
            if (category1 > category2) {
                return 1;
            }
            if (category1 < category2) {
                return -1;
            }
        }
        if (e1 instanceof PrivilegeWrapper && e2 instanceof PrivilegeWrapper) {
            PrivilegeWrapper f1 = (PrivilegeWrapper)e1;
            PrivilegeWrapper f2 = (PrivilegeWrapper)e2;
            return f1.getName().compareTo(f2.getName());
        }
        return super.compare(viewer, e1, e2);
    }
}

