/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.webwidget.support;

import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.tizen.common.util.StringUtil;
import org.tizen.web.config.schema.model.WidgetMetadata;
import org.tizen.web.editor.configuration.Messages;

public class AddMetaDataDialog
extends SelectionStatusDialog {
    private Label lKey = null;
    private Label lValue = null;
    private Text txKey = null;
    private Text txValue = null;
    private String editKey = "";
    private String editValue = "";
    private Set<String> keySet = null;

    public AddMetaDataDialog(Shell parentShell, Set<String> keySet, WidgetMetadata editData) {
        super(parentShell);
        this.setStatusLineAboveButtons(true);
        this.setHelpAvailable(false);
        this.keySet = keySet;
        if (editData == null) {
            this.setTitle(Messages.TizenPage_Metadata_AddTitle);
        } else {
            this.setTitle(Messages.TizenPage_Metadata_EditTitle);
            this.editKey = editData.getKey();
            this.editValue = editData.getValue();
            keySet.remove(this.editKey);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = 20;
        layout.marginBottom = 9;
        layout.marginLeft = 20;
        layout.marginRight = 20;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        layoutData.widthHint = 510;
        composite.setLayoutData((Object)layoutData);
        AddMetaDataDialog.applyDialogFont((Control)composite);
        this.lKey = new Label(composite, 1024);
        this.lKey.setText(Messages.TizenPage_Metadata_KeyLabel);
        GridData lgd = new GridData(16384, 0x1000000, false, false, 1, 1);
        lgd.widthHint = 115;
        this.lKey.setLayoutData((Object)lgd);
        this.txKey = new Text(composite, 2048);
        this.txKey.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lValue = new Label(composite, 0);
        this.lValue.setLayoutData((Object)lgd);
        this.lValue.setText(Messages.TizenPage_Metadata_ValueLabel);
        this.txValue = new Text(composite, 2048);
        this.txValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (!StringUtil.isEmpty((CharSequence)this.editKey)) {
            this.txKey.setText(this.editKey);
        }
        if (!StringUtil.isEmpty((CharSequence)this.editValue)) {
            this.txValue.setText(this.editValue);
        }
        this.txKey.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddMetaDataDialog.this.validate();
            }
        });
        this.txValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddMetaDataDialog.this.validate();
            }
        });
        this.validate();
        return composite;
    }

    private void validate() {
        this.computeResult();
        Status status = null;
        if (this.editKey.length() <= 0) {
            status = new Status(4, "org.tizen.web.editor.configuration", Messages.TizenPage_Metadata_EmptyKeyError);
            this.updateStatus((IStatus)status);
            return;
        }
        if (this.keySet.contains(this.editKey)) {
            status = new Status(4, "org.tizen.web.editor.configuration", Messages.TizenPage_Metadata_DuplicateKeyError);
            this.updateStatus((IStatus)status);
            return;
        }
        status = new Status(0, "org.tizen.web.editor.configuration", null);
        this.updateStatus((IStatus)status);
    }

    protected void computeResult() {
        this.editKey = this.txKey.getText().trim();
        this.editValue = this.txValue.getText().trim();
    }

    public String getNewKey() {
        return this.editKey;
    }

    public String getNewValue() {
        return this.editValue;
    }
}

