/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class ChildBasedConditionalRule
extends Rule {
    private Rule discriminator;
    private Rule delegate;

    public ChildBasedConditionalRule(Rule condition, Rule delegate) {
        this.discriminator = condition;
        this.delegate = delegate;
    }

    @Override
    public List<Suggestion> getSuggestions(List<Node> pathToRoot, ParsingContext context) {
        if (this.discriminator.matches(pathToRoot.get(0))) {
            return this.delegate.getSuggestions(pathToRoot, context);
        }
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return this.delegate.getSuggestions(node, context);
    }

    @Override
    public List<? extends Rule> getChildren() {
        return Collections.singletonList(this.delegate);
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        List<Node> children = node.getChildren();
        boolean matches = this.delegate.matches(node);
        return matches && (children.isEmpty() || this.discriminator.matches(children.get(0)));
    }

    @Override
    public Node apply(@Nonnull Node node) {
        return this.delegate.apply(node);
    }

    @Override
    public String getDescription() {
        return this.delegate.getDescription();
    }
}

