/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.nodes;

import javax.annotation.Nonnull;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.yagi.framework.nodes.AbstractPosition;
import org.raml.yagi.framework.nodes.Node;

public class DefaultPosition
extends AbstractPosition {
    public static final String ARTIFICIAL_NODE = "[artificial node]";
    private final int index;
    private final int line;
    private final int column;
    private final String resource;
    private final ResourceLoader resourceLoader;
    private String includedResourceUri;

    public DefaultPosition(int index, int line, int column, String resource, ResourceLoader resourceLoader) {
        this.index = index;
        this.line = line;
        this.column = column;
        this.resource = resource;
        this.resourceLoader = resourceLoader;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.resource;
    }

    @Override
    public String getIncludedResourceUri() {
        return this.includedResourceUri;
    }

    @Override
    public void setIncludedResourceUri(String includedResourceURI) {
        this.includedResourceUri = includedResourceURI;
    }

    @Override
    @Nonnull
    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public static DefaultPosition emptyPosition() {
        return new DefaultPosition(-1, -1, -1, ARTIFICIAL_NODE, new DefaultResourceLoader());
    }

    public static boolean isDefaultNode(Node node) {
        return node.getStartPosition().getLine() == -1 && ARTIFICIAL_NODE.equals(node.getStartPosition().getPath()) && node.getEndPosition().getLine() == -1 && ARTIFICIAL_NODE.equals(node.getEndPosition().getPath());
    }
}

