/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.build;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.util.Dictionary;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.keyword.validator.KeywordValidatorFactory;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.processors.data.SchemaDigest;
import com.github.fge.jsonschema.processors.data.ValidatorList;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.TreeMap;

public final class ValidatorBuilder
implements Processor<SchemaDigest, ValidatorList> {
    private final Map<String, KeywordValidatorFactory> factories;

    public ValidatorBuilder(Library library) {
        this.factories = library.getValidators().entries();
    }

    public ValidatorBuilder(Dictionary<KeywordValidatorFactory> dict) {
        this.factories = dict.entries();
    }

    public ValidatorList process(ProcessingReport report, SchemaDigest input) throws ProcessingException {
        TreeMap map = Maps.newTreeMap();
        for (Map.Entry<String, JsonNode> entry : input.getDigests().entrySet()) {
            String keyword = entry.getKey();
            JsonNode digest = entry.getValue();
            KeywordValidatorFactory factory = this.factories.get(keyword);
            KeywordValidator validator = factory.getKeywordValidator(digest);
            map.put(keyword, validator);
        }
        return new ValidatorList(input.getContext(), map.values());
    }

    public String toString() {
        return "validator builder";
    }
}

