/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.rules;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.internal.impl.commons.rule.RamlErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.FloatingNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class FormatValueRule
extends Rule {
    private String format;

    public FormatValueRule(String format) {
        this.format = format;
    }

    public boolean matches(@Nonnull Node node) {
        if (node instanceof FloatingNode && (this.format.equals("long") || this.format.startsWith("int"))) {
            BigDecimal value = ((FloatingNode)node).getValue();
            return value.scale() <= 0;
        }
        return true;
    }

    @Nonnull
    public Node apply(@Nonnull Node node) {
        if (this.matches(node)) {
            return this.createNodeUsingFactory(node, new Object[]{((SimpleTypeNode)node).getValue()});
        }
        return RamlErrorNodeFactory.createInvalidFormatValue(((SimpleTypeNode)node).getValue().toString(), this.format);
    }

    public String getDescription() {
        return "Format of value";
    }

    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return Collections.emptyList();
    }
}

