/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.api.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.raml.v2.api.loader.ResourceLoaderExtended;
import org.raml.v2.api.loader.ResourceUriCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileResourceLoader
implements ResourceLoaderExtended {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private File parentPath;

    public FileResourceLoader(String path) {
        this(new File(path));
    }

    public FileResourceLoader(File path) {
        this.parentPath = path;
    }

    @Override
    public InputStream fetchResource(String resourceName, ResourceUriCallback callback) {
        File includedFile = new File(resourceName);
        if (!includedFile.isAbsolute()) {
            includedFile = new File(this.parentPath, resourceName);
            this.logger.debug("Looking for resource: {} on directory: {}...", (Object)resourceName, (Object)this.parentPath);
        } else {
            this.logger.debug("Looking for absolute file: {}...", (Object)resourceName);
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(includedFile);
            if (callback != null) {
                callback.onResourceFound(includedFile.toURI());
            }
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        return inputStream;
    }

    @Override
    @Nullable
    public InputStream fetchResource(String resourceName) {
        return this.fetchResource(resourceName, null);
    }
}

