/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.IntegerNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class IntegerValueRule
extends Rule {
    private BigInteger number;

    public IntegerValueRule(BigInteger number) {
        this.number = number;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return Collections.emptyList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        if (node instanceof IntegerNode) {
            return ((IntegerNode)node).getValue().equals(this.number.intValue());
        }
        return false;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (!this.matches(node)) {
            return ErrorNodeFactory.createInvalidValue(node, String.valueOf(this.number));
        }
        return this.createNodeUsingFactory(node, new Object[0]);
    }

    @Override
    public String getDescription() {
        return this.number.toString();
    }
}

