${filecomment}

#include <stdio.h>
#include <string.h>
#include <stdbool.h>
#include <app_common.h>
#include "st_things.h"
#include "thing.h"
#include "log.h"

#define JSON_PATH "device_def.json"

<#list data.resourceDatas as resourceData>
static const char* ${resourceData.globalConstVar} = "${resourceData.uri}";
</#list>

/* OCF callback functions */
extern bool handle_reset_request(void);
extern void handle_reset_result(bool result);
extern bool handle_ownership_transfer_request(void);
extern void handle_things_status_change(st_things_status_e things_status);

/* get and set request handlers */
<#list data.resourceDatas as resourceData>
<#if resourceData.hasReadableProps()>
extern bool handle_get_request_on_resource_${resourceData.uniqueName}(st_things_get_request_message_s* req_msg, st_things_representation_s* resp_rep);
</#if>
<#if resourceData.hasWritableProps()>
extern bool handle_set_request_on_resource_${resourceData.uniqueName}(st_things_set_request_message_s* req_msg, st_things_representation_s* resp_rep);
</#if>
</#list>

extern bool init_user();

/* handle : for getting request on resources */
bool handle_get_request(st_things_get_request_message_s* req_msg, st_things_representation_s* resp_rep)
{
	DBG("resource_uri [%s]", req_msg->resource_uri);

    <#list data.resourceDatas as resourceData><#if resourceData.hasReadableProps()>
    if (0 == strcmp(req_msg->resource_uri, ${resourceData.globalConstVar})) {
        return handle_get_request_on_resource_${resourceData.uniqueName}(req_msg, resp_rep);
    }
    </#if></#list>

    ERR("not supported uri");
    return false;
}

/* handle : for setting request on resources */
bool handle_set_request(st_things_set_request_message_s* req_msg, st_things_representation_s* resp_rep)
{
	DBG("resource_uri [%s]", req_msg->resource_uri);

    <#list data.resourceDatas as resourceData><#if resourceData.hasWritableProps()>
    if (0 == strcmp(req_msg->resource_uri, ${resourceData.globalConstVar})) {
        return handle_set_request_on_resource_${resourceData.uniqueName}(req_msg, resp_rep);
    }
    </#if></#list>

    ERR("not supported uri");
    return false;
}

/* initialize */
void init_thing()
{
	FN_CALL;
	static bool binitialized = false;
	if (binitialized) {
		DBG("Already initialized!!");
		return;
	}

	bool easysetup_complete = false;

	char app_json_path[128] = {0,};
	char *app_res_path = NULL;
	char *app_data_path = NULL;

	app_res_path = app_get_resource_path();
	if (!app_res_path) {
		ERR("app_res_path is NULL!!");
		return;
	}

	app_data_path = app_get_data_path();
	if (!app_data_path) {
		ERR("app_data_path is NULL!!");
		free(app_res_path);
		return;
	}

	snprintf(app_json_path, sizeof(app_json_path), "%s/%s", app_res_path, JSON_PATH);

	if (0 != st_things_set_configuration_prefix_path((const char *)app_res_path, (const char *)app_data_path)) {
		ERR("st_things_set_configuration_prefix_path() failed!!");
		free(app_res_path);
		free(app_data_path);
		return;
	}

	free(app_res_path);
	free(app_data_path);

	if (0 != st_things_initialize(app_json_path, &easysetup_complete)) {
		ERR("st_things_initialize() failed!!");
		return;
	}

	binitialized = true;
	init_user();

	DBG("easysetup_complete:[%d] ", easysetup_complete);

	st_things_register_request_cb(handle_get_request, handle_set_request);
	st_things_register_reset_cb(handle_reset_request, handle_reset_result);
	st_things_register_user_confirm_cb(handle_ownership_transfer_request);
	st_things_register_things_status_change_cb(handle_things_status_change);

	st_things_start();

	FN_END;
}
