/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ocf.tizen.codegen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.tizen.ocf.core.model.json.Collection;
import org.tizen.ocf.core.model.json.Device;
import org.tizen.ocf.core.model.json.DeviceModel;
import org.tizen.ocf.core.model.json.Meta;
import org.tizen.ocf.core.model.json.Property;
import org.tizen.ocf.core.model.json.ResourceType;
import org.tizen.ocf.core.model.json.Single;
import org.tizen.ocf.tizen.codegen.MetaMap;
import org.tizen.ocf.tizen.codegen.template.datamodel.DeviceData;
import org.tizen.ocf.tizen.codegen.template.datamodel.PropertyData;
import org.tizen.ocf.tizen.codegen.template.datamodel.PropertyType;
import org.tizen.ocf.tizen.codegen.template.datamodel.ResourceData;
import org.tizen.ocf.tizen.exception.UnknownPropertyTypeException;

public class DeviceDataProxy {
    private String filename;
    private DeviceData deviceData;
    private HashMap<String, String> name_to_unique_id = new HashMap();
    private HashSet<String> used_ids = new HashSet();
    private int counter = 0;

    public DeviceDataProxy(String filename, DeviceModel deviceModel) throws UnknownPropertyTypeException {
        this.filename = filename;
        this.deviceData = this.convert(deviceModel);
    }

    private String getUniqueIdForName(String name) {
        if (this.name_to_unique_id.containsKey(name)) {
            return this.name_to_unique_id.get(name);
        }
        String name_norm = name.toLowerCase().replaceAll("[^A-Za-z0-9]", "_");
        if (!this.used_ids.contains(name_norm)) {
            this.used_ids.add(name_norm);
            this.name_to_unique_id.put(name, name_norm);
            return name_norm;
        }
        while (true) {
            String name_norm_with_suffix;
            if (!this.used_ids.contains(name_norm_with_suffix = String.valueOf(name_norm) + "_" + this.counter)) {
                this.used_ids.add(name_norm_with_suffix);
                this.name_to_unique_id.put(name, name_norm_with_suffix);
                return name_norm_with_suffix;
            }
            ++this.counter;
        }
    }

    private DeviceData convert(DeviceModel deviceModel) throws UnknownPropertyTypeException {
        ArrayList<Object> resources = new ArrayList<Object>();
        for (Device device : deviceModel.getDevice()) {
            for (Single single : device.getResources().getSingle()) {
                resources.add(single);
            }
            for (Collection collection : device.getResources().getCollection()) {
                resources.add(collection);
                for (Single single : collection.getLinks()) {
                    resources.add(single);
                }
            }
        }
        MetaMap metaMap = null;
        Meta meta = deviceModel.getMeta();
        if (meta != null) {
            metaMap = new MetaMap(deviceModel.getMeta());
        }
        HashMap<String, List> resourceTypeToProperties = new HashMap<String, List>();
        for (ResourceType resourceType : deviceModel.getResourceTypes()) {
            resourceTypeToProperties.put(resourceType.getType(), resourceType.getProperties());
        }
        Property linksProperty = new Property("links", 9, true, 1);
        ArrayList<Property> collectionProperties = new ArrayList<Property>();
        collectionProperties.add(linksProperty);
        resourceTypeToProperties.put("oic.wk.col", collectionProperties);
        ArrayList<ResourceData> resourceDatas = new ArrayList<ResourceData>();
        for (Single single : resources) {
            String uri = single.getUri();
            String uniqueNameForResource = this.getUniqueIdForName(uri.substring(1));
            String globalConstVarForResource = "RES_" + uniqueNameForResource.toUpperCase();
            ArrayList<PropertyData> propertyDatas = new ArrayList<PropertyData>();
            for (String resourceType : single.getTypes()) {
                HashSet processedKeys = new HashSet();
                for (Property property : (List)resourceTypeToProperties.get(resourceType)) {
                    PropertyType propertyType;
                    if (processedKeys.contains(property.getKey())) continue;
                    String key = property.getKey();
                    String uniqueNameForProp = this.getUniqueIdForName(key);
                    String globalConstVarForProp = "PROP_" + uniqueNameForProp.toUpperCase();
                    switch (property.getType()) {
                        case 0: {
                            propertyType = PropertyType.BOOLEAN;
                            break;
                        }
                        case 1: {
                            propertyType = PropertyType.INTEGER;
                            break;
                        }
                        case 2: {
                            propertyType = PropertyType.DOUBLE;
                            break;
                        }
                        case 3: {
                            propertyType = PropertyType.STRING;
                            break;
                        }
                        case 4: {
                            propertyType = PropertyType.OBJECT;
                            break;
                        }
                        case 5: {
                            propertyType = PropertyType.BYTES;
                            break;
                        }
                        case 6: {
                            propertyType = PropertyType.INTEGER_ARRAY;
                            break;
                        }
                        case 7: {
                            propertyType = PropertyType.DOUBLE_ARRAY;
                            break;
                        }
                        case 8: {
                            propertyType = PropertyType.STRING_ARRAY;
                            break;
                        }
                        case 9: {
                            propertyType = PropertyType.OBJECT_ARRAY;
                            break;
                        }
                        default: {
                            throw new UnknownPropertyTypeException("Unknown type : " + property.getType());
                        }
                    }
                    boolean isReadable = (property.getRw() & 1) != 0;
                    boolean isWritable = (property.getRw() & 2) != 0;
                    String propDesc = metaMap == null ? "" : metaMap.getPropDesc(uri, key);
                    PropertyData propertyData = new PropertyData(key, uniqueNameForProp, globalConstVarForProp, propertyType, isReadable, isWritable, propDesc);
                    propertyDatas.add(propertyData);
                }
            }
            String resourceDesc = metaMap == null ? "" : metaMap.getResDesc(uri);
            resourceDatas.add(new ResourceData(uri, uniqueNameForResource, globalConstVarForResource, propertyDatas, resourceDesc));
        }
        return new DeviceData(this.filename, resourceDatas);
    }

    public DeviceData get() {
        return this.deviceData;
    }
}

