/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ocf.tizen.ui.wizard;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.ocf.core.ui.wizard.OcfDeviceWizardPage;
import org.tizen.ocf.core.util.EclipseResourceUtil;
import org.tizen.ocf.tizen.Messages;

public class TizenCodeGenerationWizard
extends BasicNewResourceWizard
implements IWorkbenchWizard {
    private static Logger logger = LoggerFactory.getLogger(TizenCodeGenerationWizard.class);
    private Shell activeShell;
    private IProject selectedProject;
    private OcfDeviceWizardPage deviceWizardPage;
    protected Map<IFile, Boolean> generatedFileMap;

    public TizenCodeGenerationWizard(Shell activeShell, IProject selectedProject) {
        this.setWindowTitle(Messages.RtCodeGenerationWizard_WindowTitle);
        this.activeShell = activeShell;
        this.selectedProject = selectedProject;
    }

    public void addPages() {
        this.deviceWizardPage = new OcfDeviceWizardPage();
        this.deviceWizardPage.setSelection((ISelection)this.getSelection());
        this.addPage((IWizardPage)this.deviceWizardPage);
    }

    public boolean performFinish() {
        this.generatedFileMap = this.deviceWizardPage.performFinish(this.getSelectedProject(), (IProgressMonitor)new NullProgressMonitor());
        this.openWithEditor();
        return true;
    }

    private void openWithEditor() {
        IWorkbenchWindow dw = EclipseResourceUtil.getWorkbenchWindow();
        try {
            IWorkbenchPage page;
            if (dw != null && (page = dw.getActivePage()) != null && this.generatedFileMap != null && this.generatedFileMap.size() > 0) {
                for (Map.Entry<IFile, Boolean> item : this.generatedFileMap.entrySet()) {
                    IFile file = item.getKey();
                    boolean toBeOpened = item.getValue();
                    if (!toBeOpened || file == null || !file.exists()) continue;
                    this.selectAndReveal((IResource)file);
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
            }
        }
        catch (PartInitException e) {
            logger.error(e.getLocalizedMessage());
        }
    }

    public Shell getActiveShell() {
        return this.activeShell;
    }

    public IProject getSelectedProject() {
        return this.selectedProject;
    }
}

